/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.classmodel;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;

public abstract class ClassPath {
    private static Logger logger = Logger.getLogger(ClassPath.class.getName());
    public final LinkedHashSet<String> classPathEntries = new LinkedHashSet();
    public final LinkedHashSet<String> expandedClassPathEntries = new LinkedHashSet();

    public static ClassPath create(Habitat h, boolean allowTestClassPath) {
        return new ClassPath(allowTestClassPath){};
    }

    public static ClassPath create(Habitat h, String classPath) {
        return new ClassPath(classPath){};
    }

    public static ClassPath create(Habitat h, Collection<File> classPath) {
        return new ClassPath((Collection)classPath){};
    }

    protected ClassPath(boolean allowTestClassPath) {
        String classPath;
        String string = classPath = allowTestClassPath ? System.getProperty("surefire.test.class.path") : null;
        if (null == classPath) {
            classPath = System.getProperty("java.class.path");
        }
        this.initialize(classPath);
    }

    public ClassPath(String classPath) {
        this.initialize(classPath);
    }

    public ClassPath(Collection<File> classPath) {
        if (null != classPath) {
            for (File file : classPath) {
                this.initialize(file.getAbsolutePath());
            }
        }
    }

    protected void initialize(String classPath) {
        if (classPath != null) {
            String[] filenames;
            for (String filename : filenames = classPath.split(File.pathSeparator)) {
                if (filename.equals("")) continue;
                File classpathEntry = new File(filename);
                logger.log(Level.FINE, "adding cpEntry={0}", classpathEntry);
                this.classPathEntries.add(classpathEntry.getAbsolutePath());
                ClassPath.addTransitiveJars(this.expandedClassPathEntries, classpathEntry);
            }
        }
    }

    public String toString() {
        return "ClassPath-" + System.identityHashCode(this) + "=" + this.expandedClassPathEntries;
    }

    public int hashCode() {
        return this.expandedClassPathEntries.hashCode();
    }

    public boolean equals(Object another) {
        if (ClassPath.class.isInstance(another)) {
            return this.expandedClassPathEntries.equals(((ClassPath)another).expandedClassPathEntries);
        }
        return false;
    }

    public Set<String> getEntries() {
        return Collections.unmodifiableSet(this.expandedClassPathEntries);
    }

    public Set<File> getFileEntries() {
        LinkedHashSet<File> fileEntries = new LinkedHashSet<File>();
        for (String fileName : this.expandedClassPathEntries) {
            File file = new File(fileName);
            if (!file.exists()) {
                logger.log(Level.FINE, "warning: {0} does not exist.", fileName);
            }
            fileEntries.add(file);
        }
        return Collections.unmodifiableSet(fileEntries);
    }

    public URL[] getRawURLs() throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>(this.classPathEntries.size());
        for (String fileName : this.classPathEntries) {
            File file = new File(fileName);
            if (file.exists()) {
                urls.add(file.toURL());
                continue;
            }
            logger.log(Level.FINE, "warning: {0} does not exist.", fileName);
        }
        return urls.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addTransitiveJars(Set<String> cpSet, File classpathFile) {
        cpSet.add(classpathFile.getAbsolutePath());
        if (classpathFile.exists()) {
            try {
                String additionalClasspath;
                Manifest mf;
                if (!classpathFile.isFile()) return;
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(classpathFile);
                    mf = jarFile.getManifest();
                }
                finally {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                if (mf == null || (additionalClasspath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) == null) return;
                for (String classpathEntry : additionalClasspath.split(" ")) {
                    if (classpathEntry.equals("")) continue;
                    File mfClasspathFile = new File(classpathFile.getParent(), classpathEntry.trim());
                    if (mfClasspathFile.exists() && !cpSet.contains(mfClasspathFile.getAbsolutePath())) {
                        logger.log(Level.FINE, "adding transitive cpEntry={0}", mfClasspathFile);
                        ClassPath.addTransitiveJars(cpSet, mfClasspathFile);
                        continue;
                    }
                    logger.log(Level.FINE, "skipping cpEntry={0}", mfClasspathFile);
                }
                return;
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "an error occurred", ex);
                return;
            }
        }
        logger.log(Level.FINE, "cpEntry={0} does not exist", classpathFile);
    }
}

