/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.NamedImpl;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;

public abstract class AbstractActiveDescriptor<T>
extends DescriptorImpl
implements ActiveDescriptor<T>,
Serializable {
    private static final long serialVersionUID = 7080312303893604939L;
    private static final Set<Annotation> EMPTY_QUALIFIER_SET = Collections.emptySet();
    private Set<Type> advertisedContracts = new LinkedHashSet<Type>();
    private Class<? extends Annotation> scope;
    private Set<Annotation> qualifiers;
    private Long factoryServiceId;
    private Long factoryLocatorId;
    private boolean isReified = true;
    private transient boolean cacheSet = false;
    private transient T cachedValue;

    public AbstractActiveDescriptor() {
    }

    protected AbstractActiveDescriptor(Descriptor baseDescriptor) {
        super(baseDescriptor);
        this.isReified = false;
    }

    protected AbstractActiveDescriptor(Set<Type> advertisedContracts, Class<? extends Annotation> scope, String name, Set<Annotation> qualifiers, DescriptorType descriptorType, DescriptorVisibility descriptorVisibility, int ranking, Boolean proxy, Boolean proxyForSameScope, String analyzerName, Map<String, List<String>> metadata) {
        this.scope = scope;
        this.advertisedContracts.addAll(advertisedContracts);
        if (qualifiers != null && !qualifiers.isEmpty()) {
            this.qualifiers = new LinkedHashSet<Annotation>();
            this.qualifiers.addAll(qualifiers);
        }
        this.setRanking(ranking);
        this.setDescriptorType(descriptorType);
        this.setDescriptorVisibility(descriptorVisibility);
        this.setName(name);
        this.setProxiable(proxy);
        this.setProxyForSameScope(proxyForSameScope);
        if (scope != null) {
            this.setScope(scope.getName());
        }
        for (Type type : advertisedContracts) {
            Class raw = ReflectionHelper.getRawClass((Type)type);
            if (raw == null) continue;
            this.addAdvertisedContract(raw.getName());
        }
        if (qualifiers != null) {
            for (Annotation annotation : qualifiers) {
                this.addQualifier(annotation.annotationType().getName());
            }
        }
        this.setClassAnalysisName(analyzerName);
        if (metadata == null) {
            return;
        }
        for (Map.Entry entry : metadata.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            for (String value : values) {
                this.addMetadata(key, value);
            }
        }
    }

    private void removeNamedQualifier() {
        if (this.qualifiers == null) {
            return;
        }
        for (Annotation qualifier : this.qualifiers) {
            if (!qualifier.annotationType().equals(Named.class)) continue;
            this.removeQualifierAnnotation(qualifier);
            return;
        }
    }

    @Override
    public synchronized void setName(String name) {
        super.setName(name);
        this.removeNamedQualifier();
        if (name == null) {
            return;
        }
        this.addQualifierAnnotation(new NamedImpl(name));
    }

    @Override
    public synchronized T getCache() {
        return this.cachedValue;
    }

    @Override
    public synchronized boolean isCacheSet() {
        return this.cacheSet;
    }

    @Override
    public synchronized void setCache(T cacheMe) {
        this.cachedValue = cacheMe;
        this.cacheSet = true;
    }

    @Override
    public synchronized void releaseCache() {
        this.cacheSet = false;
        this.cachedValue = null;
    }

    @Override
    public synchronized boolean isReified() {
        return this.isReified;
    }

    public void setReified(boolean reified) {
        this.isReified = reified;
    }

    @Override
    public synchronized Set<Type> getContractTypes() {
        return Collections.unmodifiableSet(this.advertisedContracts);
    }

    public synchronized void addContractType(Type addMe) {
        if (addMe == null) {
            return;
        }
        this.advertisedContracts.add(addMe);
        Class rawClass = ReflectionHelper.getRawClass((Type)addMe);
        if (rawClass == null) {
            return;
        }
        this.addAdvertisedContract(rawClass.getName());
    }

    public synchronized boolean removeContractType(Type removeMe) {
        if (removeMe == null) {
            return false;
        }
        boolean retVal = this.advertisedContracts.remove(removeMe);
        Class rawClass = ReflectionHelper.getRawClass((Type)removeMe);
        if (rawClass == null) {
            return retVal;
        }
        return this.removeAdvertisedContract(rawClass.getName());
    }

    @Override
    public synchronized Class<? extends Annotation> getScopeAnnotation() {
        return this.scope;
    }

    @Override
    public synchronized Set<Annotation> getQualifierAnnotations() {
        if (this.qualifiers == null) {
            return EMPTY_QUALIFIER_SET;
        }
        return Collections.unmodifiableSet(this.qualifiers);
    }

    public synchronized void addQualifierAnnotation(Annotation addMe) {
        if (addMe == null) {
            return;
        }
        if (this.qualifiers == null) {
            this.qualifiers = new LinkedHashSet<Annotation>();
        }
        this.qualifiers.add(addMe);
        this.addQualifier(addMe.annotationType().getName());
    }

    public synchronized boolean removeQualifierAnnotation(Annotation removeMe) {
        if (removeMe == null) {
            return false;
        }
        if (this.qualifiers == null) {
            return false;
        }
        boolean retVal = this.qualifiers.remove(removeMe);
        this.removeQualifier(removeMe.annotationType().getName());
        return retVal;
    }

    @Override
    public Long getFactoryServiceId() {
        return this.factoryServiceId;
    }

    @Override
    public Long getFactoryLocatorId() {
        return this.factoryLocatorId;
    }

    public void setFactoryId(Long locatorId, Long serviceId) {
        if (!this.getDescriptorType().equals((Object)DescriptorType.PROVIDE_METHOD)) {
            throw new IllegalStateException("The descriptor type must be PROVIDE_METHOD");
        }
        this.factoryServiceId = serviceId;
        this.factoryLocatorId = locatorId;
    }

    @Override
    public synchronized List<Injectee> getInjectees() {
        return Collections.emptyList();
    }

    @Override
    public synchronized void dispose(T instance) {
    }
}

