/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.io.IOException;
import java.util.Enumeration;
import org.glassfish.api.container.CompositeSniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.glassfish.weld.WeldSniffer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service(name="weldCompositeSniffer")
@Scoped(value=Singleton.class)
public class WeldCompositeSniffer
extends WeldSniffer
implements CompositeSniffer {
    public boolean handles(DeploymentContext context) {
        boolean isWeldApplication = false;
        ApplicationHolder holder = (ApplicationHolder)context.getModuleMetaData(ApplicationHolder.class);
        ReadableArchive appRoot = context.getSource();
        if (holder != null && holder.app != null) {
            isWeldApplication = this.scanLibDir(appRoot, holder.app.getLibraryDirectory(), context);
        }
        return isWeldApplication;
    }

    private boolean scanLibDir(ReadableArchive archive, String libLocation, DeploymentContext context) {
        boolean entryPresent = false;
        if (libLocation != null && !libLocation.isEmpty()) {
            Enumeration entries = archive.entries(libLocation);
            while (entries.hasMoreElements() && !entryPresent) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(".jar") || entryName.indexOf(47, libLocation.length() + 1) != -1) continue;
                try {
                    ReadableArchive jarInLib = archive.getSubArchive(entryName);
                    entryPresent = this.isEntryPresent(jarInLib, "META-INF/beans.xml");
                    jarInLib.close();
                    if (!entryPresent) continue;
                    break;
                }
                catch (IOException e) {
                }
            }
        }
        return entryPresent;
    }

    private boolean isEntryPresent(ReadableArchive archive, String entry) {
        boolean entryPresent = false;
        try {
            entryPresent = archive.exists(entry);
        }
        catch (IOException e) {
            // empty catch block
        }
        return entryPresent;
    }
}

