/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.io.IOException;
import java.util.Enumeration;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.deployment.GenericSniffer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service(name="weld")
@Scoped(value=Singleton.class)
public class WeldSniffer
extends GenericSniffer
implements Sniffer {
    private static final String[] containers = new String[]{"org.glassfish.weld.WeldContainer"};

    public WeldSniffer() {
        super("weld", null, null);
    }

    public boolean handles(ReadableArchive archive, ClassLoader loader) {
        boolean isWeldArchive = false;
        if (this.isEntryPresent(archive, "WEB-INF") && !(isWeldArchive = this.isEntryPresent(archive, "WEB-INF/beans.xml")) && this.isEntryPresent(archive, "WEB-INF/lib")) {
            isWeldArchive = this.scanLibDir(archive, "WEB-INF/lib");
        }
        String archiveName = archive.getName();
        if (!isWeldArchive && archiveName != null && archiveName.endsWith("_jar")) {
            isWeldArchive = this.isEntryPresent(archive, "META-INF/beans.xml");
        }
        if (!isWeldArchive && this.isEntryPresent(archive, "META-INF/beans.xml")) {
            isWeldArchive = true;
        }
        if (!isWeldArchive && archiveName != null && archiveName.endsWith("_rar")) {
            isWeldArchive = this.isEntryPresent(archive, "META-INF/beans.xml");
        }
        return isWeldArchive;
    }

    private boolean scanLibDir(ReadableArchive archive, String libLocation) {
        boolean entryPresent = false;
        if (libLocation != null && !libLocation.isEmpty()) {
            Enumeration entries = archive.entries(libLocation);
            while (entries.hasMoreElements() && !entryPresent) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(".jar") || entryName.indexOf(47, libLocation.length() + 1) != -1) continue;
                try {
                    ReadableArchive jarInLib = archive.getSubArchive(entryName);
                    entryPresent = this.isEntryPresent(jarInLib, "META-INF/beans.xml");
                    jarInLib.close();
                }
                catch (IOException e) {}
            }
        }
        return entryPresent;
    }

    private boolean isEntryPresent(ReadableArchive archive, String entry) {
        boolean entryPresent = false;
        try {
            entryPresent = archive.exists(entry);
        }
        catch (IOException e) {
            // empty catch block
        }
        return entryPresent;
    }

    public String[] getContainersNames() {
        return containers;
    }
}

