/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.slice;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.slice.PIntSlice;
import com.oracle.graal.python.builtins.objects.slice.PObjectSlice;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PSlice})
public final class SliceBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SliceBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PSlice self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory) {
            PTuple args = factory.createTuple(new Object[]{self.getStart(), self.getStop(), self.getStep()});
            return factory.createTuple(new Object[]{getClassNode.execute(inliningTarget, self), args});
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends PythonBuiltinNode {
        @Specialization
        public static long hash(PSlice self, @Cached PRaiseNode raise) {
            throw raise.raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNHASHABLE_TYPE_P, new Object[]{PythonBuiltinClassType.PSlice});
        }
    }

    @Builtin(name="indices", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class IndicesNode
    extends PythonBinaryBuiltinNode {
        IndicesNode() {
        }

        private static PTuple doPSlice(VirtualFrame frame, PSlice self, int length, SliceNodes.ComputeIndices compute, PythonObjectFactory factory) {
            PSlice.SliceInfo sliceInfo = compute.execute((Frame)frame, self, length);
            return factory.createTuple(new Object[]{sliceInfo.start, sliceInfo.stop, sliceInfo.step});
        }

        protected static boolean isSafeIntSlice(PSlice self, Object length) {
            return self instanceof PIntSlice && length instanceof Integer;
        }

        @Specialization
        static PTuple safeInt(VirtualFrame frame, PIntSlice self, int length, @Cached.Shared @Cached SliceNodes.ComputeIndices compute, @Cached.Shared @Cached PythonObjectFactory factory) {
            return IndicesNode.doPSlice(frame, self, length, compute, factory);
        }

        @Specialization(guards={"!isPNone(length)"}, rewriteOn={PException.class})
        static PTuple doSliceObject(VirtualFrame frame, PSlice self, Object length, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached SliceNodes.SliceExactCastToInt toInt, @Cached.Shared @Cached SliceNodes.ComputeIndices compute, @Cached.Shared @Cached PythonObjectFactory factory) {
            return IndicesNode.doPSlice(frame, self, (Integer)toInt.execute((Frame)frame, inliningTarget, length), compute, factory);
        }

        @Specialization(guards={"!isPNone(length)"}, replaces={"doSliceObject"})
        static PTuple doSliceObjectWithSlowPath(VirtualFrame frame, PSlice self, Object length, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached SliceNodes.SliceExactCastToInt toInt, @Cached.Shared @Cached SliceNodes.ComputeIndices compute, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profileError, @Cached SliceNodes.SliceCastToToBigInt castLengthNode, @Cached SliceNodes.CoerceToObjectSlice castNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            try {
                return IndicesNode.doPSlice(frame, self, (Integer)toInt.execute((Frame)frame, inliningTarget, length), compute, factory);
            }
            catch (PException pe) {
                if (!profileError.profileException(inliningTarget, pe, PythonBuiltinClassType.OverflowError)) {
                    throw pe;
                }
                Object lengthIn = castLengthNode.execute(inliningTarget, length);
                PObjectSlice.SliceObjectInfo sliceInfo = PObjectSlice.computeIndicesSlowPath(castNode.execute(self), lengthIn, factory);
                return factory.createTuple(new Object[]{sliceInfo.start, sliceInfo.stop, sliceInfo.step});
            }
        }

        @Specialization(guards={"isPNone(length)"})
        static PTuple lengthNone(PSlice self, Object length, @Cached PRaiseNode raise) {
            throw raise.raise(PythonErrorType.ValueError);
        }
    }

    @Builtin(name="step", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StepNode
    extends PythonUnaryBuiltinNode {
        StepNode() {
        }

        @Specialization
        protected static Object get(PIntSlice self) {
            return self.getStep();
        }

        @Specialization
        protected static Object get(PObjectSlice self) {
            return self.getStep();
        }
    }

    @Builtin(name="stop", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StopNode
    extends PythonUnaryBuiltinNode {
        StopNode() {
        }

        @Specialization
        protected static Object get(PIntSlice self) {
            return self.getStop();
        }

        @Specialization
        protected static Object get(PObjectSlice self) {
            return self.getStop();
        }
    }

    @Builtin(name="start", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class StartNode
    extends PythonUnaryBuiltinNode {
        StartNode() {
        }

        @Specialization
        protected static Object get(PIntSlice self) {
            return self.getStart();
        }

        @Specialization
        protected static Object get(PObjectSlice self) {
            return self.getStart();
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends PythonBuiltinNode {
        EqNode() {
        }

        @Specialization
        static boolean sliceCmp(PIntSlice left, PIntSlice right) {
            return left.equals(right);
        }

        @Specialization(guards={"!isPSlice(right)"})
        static boolean notEqual(PSlice left, Object right) {
            return false;
        }

        @Specialization
        static boolean sliceCmpWithLib(VirtualFrame frame, PSlice left, PSlice right, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            return eqNode.compare((Frame)frame, inliningTarget, left.getStart(), right.getStart()) && eqNode.compare((Frame)frame, inliningTarget, left.getStop(), right.getStop()) && eqNode.compare((Frame)frame, inliningTarget, left.getStep(), right.getStep());
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonBuiltinNode {
        ReprNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public static TruffleString repr(PSlice self) {
            return PythonUtils.toTruffleStringUncached(self.toString());
        }
    }
}

