/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public class DropIndex
extends SchemaCommand {
    private String indexName;
    private boolean ifExists;

    public DropIndex(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Index index = this.getSchema().findIndex(this.session, this.indexName);
        if (index == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(42112, this.indexName);
            }
        } else {
            Table table = index.getTable();
            this.session.getUser().checkRight(index.getTable(), 15);
            Constraint constraint = null;
            ObjectArray objectArray = table.getConstraints();
            for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
                Constraint constraint2 = (Constraint)objectArray.get(i);
                if (!constraint2.usesIndex(index)) continue;
                if ("PRIMARY KEY".equals(constraint2.getConstraintType())) {
                    constraint = constraint2;
                    continue;
                }
                throw Message.getSQLException(90085, this.indexName);
            }
            index.getTable().setModified();
            if (constraint != null) {
                database.removeSchemaObject(this.session, constraint);
            } else {
                database.removeSchemaObject(this.session, index);
            }
        }
        return 0;
    }
}

