/*
 * Decompiled with CFR 0.152.
 */
package org.h2.log;

import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.log.InDoubtTransaction;
import org.h2.log.LogFile;
import org.h2.log.LogRecord;
import org.h2.log.SessionState;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.DiskFile;
import org.h2.store.Record;
import org.h2.store.Storage;
import org.h2.util.FileUtils;
import org.h2.util.ObjectArray;
import org.h2.util.ObjectUtils;

public class LogSystem {
    public static final int LOG_WRITTEN = -1;
    private static final Comparator LOG_FILE_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((LogFile)object).getId() - ((LogFile)object2).getId();
        }
    };
    private Database database;
    private ObjectArray activeLogs;
    private LogFile currentLog;
    private String fileNamePrefix;
    private HashMap storages = new HashMap();
    private HashMap sessions = new HashMap();
    private DataPage rowBuff;
    private ObjectArray undo;
    private boolean deleteOldLogFilesAutomatically = true;
    private long maxLogSize = 0x2000000L;
    private boolean readOnly;
    private boolean flushOnEachCommit;
    private ObjectArray inDoubtTransactions;
    private boolean disabled;
    private int keepFiles;
    private boolean closed;
    private String accessMode;

    public LogSystem(Database database, String string, boolean bl, String string2) {
        this.database = database;
        this.readOnly = bl;
        this.accessMode = string2;
        this.closed = true;
        if (database == null) {
            return;
        }
        this.fileNamePrefix = string;
        this.rowBuff = DataPage.create((DataHandler)database, 512);
    }

    public void setMaxLogSize(long l) {
        this.maxLogSize = l;
    }

    public long getMaxLogSize() {
        return this.maxLogSize;
    }

    public boolean containsInDoubtTransactions() {
        return this.inDoubtTransactions != null && this.inDoubtTransactions.size() > 0;
    }

    private void flushAndCloseUnused() throws SQLException {
        Object object;
        int n;
        this.currentLog.flush();
        DiskFile diskFile = this.database.getDataFile();
        if (diskFile == null) {
            return;
        }
        diskFile.flush();
        if (this.database.getLogIndexChanges()) {
            diskFile = this.database.getIndexFile();
            diskFile.flush();
        }
        if (this.containsInDoubtTransactions()) {
            return;
        }
        Session[] sessionArray = this.database.getSessions(true);
        int n2 = this.currentLog.getId();
        int n3 = this.currentLog.getPos();
        for (n = 0; n < sessionArray.length; ++n) {
            object = sessionArray[n];
            int n4 = ((Session)object).getFirstUncommittedLog();
            int n5 = ((Session)object).getFirstUncommittedPos();
            if (n5 == -1 || n4 >= n2 && (n4 != n2 || n5 >= n3)) continue;
            n2 = n4;
            n3 = n5;
        }
        for (n = this.activeLogs.size() - 1; n >= 0; --n) {
            object = (LogFile)this.activeLogs.get(n);
            if (((LogFile)object).getId() < n2) {
                ((LogFile)object).setFirstUncommittedPos(-1);
                continue;
            }
            if (((LogFile)object).getId() != n2) continue;
            if (n3 == ((LogFile)object).getPos()) {
                ((LogFile)object).setFirstUncommittedPos(-1);
                continue;
            }
            ((LogFile)object).setFirstUncommittedPos(n3);
        }
        for (n = 0; n < this.activeLogs.size(); ++n) {
            object = (LogFile)this.activeLogs.get(n);
            if (((LogFile)object).getFirstUncommittedPos() != -1) continue;
            this.activeLogs.remove(n);
            --n;
            this.closeOldFile((LogFile)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.database == null) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.closed) {
                return;
            }
            if (this.readOnly) {
                for (int i = 0; i < this.activeLogs.size(); ++i) {
                    LogFile logFile = (LogFile)this.activeLogs.get(i);
                    logFile.close(false);
                }
                this.closed = true;
                return;
            }
            SQLException sQLException = null;
            try {
                this.flushAndCloseUnused();
                if (!this.containsInDoubtTransactions()) {
                    this.checkpoint();
                }
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            catch (Throwable throwable) {
                sQLException = Message.convert(throwable);
            }
            for (int i = 0; i < this.activeLogs.size(); ++i) {
                LogFile logFile = (LogFile)this.activeLogs.get(i);
                try {
                    if (logFile.getFirstUncommittedPos() == -1 && !this.containsInDoubtTransactions()) {
                        this.closeOldFile(logFile);
                        continue;
                    }
                    logFile.close(false);
                    continue;
                }
                catch (SQLException sQLException3) {
                    if (sQLException != null) continue;
                    sQLException = sQLException3;
                }
            }
            this.closed = true;
            if (sQLException != null) {
                throw sQLException;
            }
        }
    }

    void addUndoLogRecord(LogFile logFile, int n, int n2) {
        this.getOrAddSessionState(n2);
        LogRecord logRecord = new LogRecord(logFile, n, n2);
        this.undo.add(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws SQLException {
        if (this.database == null) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            Object object;
            int n;
            Object[] objectArray;
            int n2;
            if (this.closed) {
                return;
            }
            this.undo = new ObjectArray();
            for (n2 = 0; n2 < this.activeLogs.size(); ++n2) {
                objectArray = (Object[])this.activeLogs.get(n2);
                objectArray.redoAllGoEnd();
                this.database.getDataFile().flushRedoLog();
                this.database.getIndexFile().flushRedoLog();
            }
            n2 = this.currentLog.getPos();
            objectArray = this.sessions.values().toArray();
            this.inDoubtTransactions = new ObjectArray();
            for (n = 0; n < objectArray.length; ++n) {
                object = (SessionState)objectArray[n];
                if (((SessionState)object).inDoubtTransaction == null) continue;
                this.inDoubtTransactions.add(((SessionState)object).inDoubtTransaction);
            }
            for (n = this.undo.size() - 1; n >= 0 && this.sessions.size() > 0; --n) {
                this.database.setProgress(2, null, this.undo.size() - 1 - n, this.undo.size());
                object = (LogRecord)this.undo.get(n);
                if (this.sessions.get(ObjectUtils.getInteger(((LogRecord)object).sessionId)) == null) continue;
                ((LogRecord)object).log.undo(((LogRecord)object).logRecordId);
                this.database.getDataFile().flushRedoLog();
                this.database.getIndexFile().flushRedoLog();
            }
            this.currentLog.go(n2);
            n = this.undo.size() > 0 ? 1 : 0;
            this.undo = null;
            this.storages.clear();
            if (!this.readOnly && n != 0 && !this.containsInDoubtTransactions()) {
                this.checkpoint();
            }
            return;
        }
    }

    private void closeOldFile(LogFile logFile) throws SQLException {
        logFile.close(this.deleteOldLogFilesAutomatically && this.keepFiles == 0);
    }

    public void open() throws SQLException {
        String string = FileUtils.getParent(this.fileNamePrefix);
        String[] stringArray = FileUtils.listFiles(string);
        this.activeLogs = new ObjectArray();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            LogFile logFile = null;
            try {
                logFile = LogFile.openIfLogFile(this, this.fileNamePrefix, string2);
            }
            catch (SQLException sQLException) {
                this.database.getTrace("log").debug("Error opening log file, header corrupt: " + string2, sQLException);
                FileUtils.delete(string2 + ".corrupt");
                FileUtils.rename(string2, string2 + ".corrupt");
            }
            if (logFile == null) continue;
            if (logFile.getPos() == -1) {
                this.closeOldFile(logFile);
                continue;
            }
            this.activeLogs.add(logFile);
        }
        this.activeLogs.sort(LOG_FILE_COMPARATOR);
        if (this.activeLogs.size() == 0) {
            LogFile logFile = new LogFile(this, 0, this.fileNamePrefix);
            this.activeLogs.add(logFile);
        }
        this.currentLog = (LogFile)this.activeLogs.get(this.activeLogs.size() - 1);
        this.closed = false;
    }

    Storage getStorageForRecovery(int n) {
        boolean bl;
        if (n < 0) {
            bl = false;
            n = -n;
        } else {
            bl = true;
        }
        Integer n2 = ObjectUtils.getInteger(n);
        Storage storage = (Storage)this.storages.get(n2);
        if (storage == null) {
            storage = this.database.getStorage(null, n, bl);
            this.storages.put(n2, storage);
        }
        return storage;
    }

    boolean isSessionCommitted(int n, int n2, int n3) {
        Integer n4 = ObjectUtils.getInteger(n);
        SessionState sessionState = (SessionState)this.sessions.get(n4);
        if (sessionState == null) {
            return true;
        }
        return sessionState.isCommitted(n2, n3);
    }

    void setLastCommitForSession(int n, int n2, int n3) {
        SessionState sessionState = this.getOrAddSessionState(n);
        sessionState.lastCommitLog = n2;
        sessionState.lastCommitPos = n3;
        sessionState.inDoubtTransaction = null;
    }

    SessionState getOrAddSessionState(int n) {
        Integer n2 = ObjectUtils.getInteger(n);
        SessionState sessionState = (SessionState)this.sessions.get(n2);
        if (sessionState == null) {
            sessionState = new SessionState();
            this.sessions.put(n2, sessionState);
            sessionState.sessionId = n;
        }
        return sessionState;
    }

    void setPreparedCommitForSession(LogFile logFile, int n, int n2, String string, int n3) {
        SessionState sessionState = this.getOrAddSessionState(n);
        this.setLastCommitForSession(n, logFile.getId(), n2);
        sessionState.inDoubtTransaction = new InDoubtTransaction(logFile, n, n2, string, n3);
    }

    public ObjectArray getInDoubtTransactions() {
        return this.inDoubtTransactions;
    }

    void removeSession(int n) {
        this.sessions.remove(ObjectUtils.getInteger(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCommit(Session session, String string) throws SQLException {
        if (this.database == null || this.readOnly) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.closed) {
                return;
            }
            this.currentLog.prepareCommit(session, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Session session) throws SQLException {
        if (this.database == null || this.readOnly) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.closed) {
                return;
            }
            this.currentLog.commit(session);
            session.setAllCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws SQLException {
        if (this.database == null || this.readOnly) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.closed) {
                return;
            }
            this.currentLog.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTruncate(Session session, DiskFile diskFile, int n, int n2, int n3) throws SQLException {
        if (this.database == null) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.disabled || this.closed) {
                return;
            }
            this.database.checkWritingAllowed();
            if (!diskFile.isDataFile()) {
                n = -n;
            }
            this.currentLog.addTruncate(session, n, n2, n3);
            if (this.currentLog.getFileSize() > this.maxLogSize) {
                this.checkpoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session, DiskFile diskFile, Record record) throws SQLException {
        if (this.database == null) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.disabled || this.closed) {
                return;
            }
            this.database.checkWritingAllowed();
            int n = record.getStorageId();
            if (!diskFile.isDataFile()) {
                n = -n;
            }
            int n2 = this.currentLog.getId();
            int n3 = this.currentLog.getPos();
            session.addLogPos(n2, n3);
            record.setLastLog(n2, n3);
            this.currentLog.add(session, n, record);
            if (this.currentLog.getFileSize() > this.maxLogSize) {
                this.checkpoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint() throws SQLException {
        if (this.readOnly || this.database == null) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.closed || this.disabled) {
                return;
            }
            this.flushAndCloseUnused();
            this.currentLog = new LogFile(this, this.currentLog.getId() + 1, this.fileNamePrefix);
            this.activeLogs.add(this.currentLog);
            this.writeSummary();
            this.currentLog.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectArray getActiveLogFiles() {
        Database database = this.database;
        synchronized (database) {
            ObjectArray objectArray = new ObjectArray();
            objectArray.addAll(this.activeLogs);
            return objectArray;
        }
    }

    private void writeSummary() throws SQLException {
        DiskFile diskFile = this.database.getDataFile();
        if (diskFile == null) {
            return;
        }
        byte[] byArray = diskFile.getSummary();
        if (byArray != null) {
            this.currentLog.addSummary(true, byArray);
        }
        if (this.database.getLogIndexChanges() || this.database.getIndexSummaryValid()) {
            diskFile = this.database.getIndexFile();
            byArray = diskFile.getSummary();
            if (byArray != null) {
                this.currentLog.addSummary(false, byArray);
            }
        } else {
            this.currentLog.addSummary(false, null);
        }
    }

    Database getDatabase() {
        return this.database;
    }

    DataPage getRowBuffer() {
        return this.rowBuff;
    }

    public void setFlushOnEachCommit(boolean bl) {
        this.flushOnEachCommit = bl;
    }

    boolean getFlushOnEachCommit() {
        return this.flushOnEachCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws SQLException {
        if (this.database == null || this.readOnly) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.currentLog != null) {
                this.currentLog.flush();
                this.currentLog.sync();
            }
        }
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    void addRedoLog(Storage storage, int n, int n2, DataPage dataPage) throws SQLException {
        DiskFile diskFile = storage.getDiskFile();
        diskFile.addRedoLog(storage, n, n2, dataPage);
    }

    public void invalidateIndexSummary() throws SQLException {
        this.currentLog.addSummary(false, null);
    }

    public synchronized void updateKeepFiles(int n) {
        this.keepFiles += n;
    }

    String getAccessMode() {
        return this.accessMode;
    }
}

