/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch;

import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.ElasticsearchDistributionName;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchVersion {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)(?:\\.(\\d+)(?:\\.(\\d+)(?:-(\\w+))?)?)?");
    private static final Pattern DISTRIBUTION_AND_VERSION_PATTERN = Pattern.compile("(?:([^\\d]+):)?(" + VERSION_PATTERN.pattern() + ")");
    private final ElasticsearchDistributionName distribution;
    private final int major;
    private final Integer minor;
    private final Integer micro;
    private final String qualifier;

    public static ElasticsearchVersion of(String distributionAndVersionString) {
        String normalizedDistributionAndVersionString = distributionAndVersionString.trim().toLowerCase(Locale.ROOT);
        Matcher matcher = DISTRIBUTION_AND_VERSION_PATTERN.matcher(normalizedDistributionAndVersionString);
        if (!matcher.matches()) {
            throw log.invalidElasticsearchVersionWithOptionalDistribution(normalizedDistributionAndVersionString, ElasticsearchDistributionName.allowedExternalRepresentations(), ElasticsearchDistributionName.defaultValue().externalRepresentation(), null);
        }
        try {
            String distributionString = matcher.group(1);
            return ElasticsearchVersion.of(distributionString == null ? ElasticsearchDistributionName.defaultValue() : ElasticsearchDistributionName.of(distributionString), matcher.group(2));
        }
        catch (RuntimeException e) {
            throw log.invalidElasticsearchVersionWithOptionalDistribution(normalizedDistributionAndVersionString, ElasticsearchDistributionName.allowedExternalRepresentations(), ElasticsearchDistributionName.defaultValue().externalRepresentation(), e);
        }
    }

    public static ElasticsearchVersion of(ElasticsearchDistributionName distribution, String versionString) {
        String normalizedVersion = versionString.trim().toLowerCase(Locale.ROOT);
        Matcher matcher = VERSION_PATTERN.matcher(normalizedVersion);
        if (!matcher.matches()) {
            throw log.invalidElasticsearchVersionWithoutDistribution(normalizedVersion, null);
        }
        try {
            int major = ElasticsearchVersion.parseVersionComponent(matcher.group(1));
            Integer minor = ElasticsearchVersion.parseVersionComponent(matcher.group(2));
            Integer micro = ElasticsearchVersion.parseVersionComponent(matcher.group(3));
            String qualifier = matcher.group(4);
            return new ElasticsearchVersion(distribution, major, minor, micro, qualifier);
        }
        catch (RuntimeException e) {
            throw log.invalidElasticsearchVersionWithoutDistribution(normalizedVersion, e);
        }
    }

    private static Integer parseVersionComponent(String string) {
        return string == null ? null : Integer.valueOf(Integer.parseInt(string));
    }

    private ElasticsearchVersion(ElasticsearchDistributionName distribution, int major, Integer minor, Integer micro, String qualifier) {
        this.distribution = distribution;
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.distribution).append(':');
        builder.append(this.major);
        if (this.minor != null) {
            builder.append(".").append(this.minor);
        }
        if (this.micro != null) {
            builder.append(".").append(this.micro);
        }
        if (this.qualifier != null) {
            builder.append("-").append(this.qualifier);
        }
        return builder.toString();
    }

    public String versionString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major);
        if (this.minor != null) {
            builder.append(".").append(this.minor);
        }
        if (this.micro != null) {
            builder.append(".").append(this.micro);
        }
        if (this.qualifier != null) {
            builder.append("-").append(this.qualifier);
        }
        return builder.toString();
    }

    public ElasticsearchDistributionName distribution() {
        return this.distribution;
    }

    public int major() {
        return this.major;
    }

    public OptionalInt minor() {
        return this.minor == null ? OptionalInt.empty() : OptionalInt.of(this.minor);
    }

    public OptionalInt micro() {
        return this.micro == null ? OptionalInt.empty() : OptionalInt.of(this.micro);
    }

    public Optional<String> qualifier() {
        return Optional.ofNullable(this.qualifier);
    }

    public boolean matches(ElasticsearchVersion other) {
        return !(!this.distribution.equals((Object)other.distribution) || this.major != other.major || this.minor != null && !this.minor.equals(other.minor) || this.micro != null && !this.micro.equals(other.micro) || this.qualifier != null && !this.qualifier.equals(other.qualifier));
    }
}

