/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    protected static String getSystemProperty(String name) {
        return TCLAction.UTIL.getSystemProperty(name);
    }

    protected static ClassLoader getContextClassLoader() {
        return TCLAction.UTIL.getContextClassLoader();
    }

    private static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            @Override
            public String getSystemProperty(String name) {
                return System.getProperty(name);
            }

            @Override
            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){

            @Override
            public String getSystemProperty(final String name) {
                return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getProperty(name);
                    }
                });
            }

            @Override
            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
        };

        public String getSystemProperty(String var1);

        public ClassLoader getContextClassLoader();

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static String getSystemProperty(String name) {
                return UTIL.getTCLAction().getSystemProperty(name);
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }
        }
    }
}

