/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.SubsystemTransformer;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

public class TransformationTargetImpl
implements TransformationTarget {
    private static final Logger log = Logger.getLogger(TransformationTarget.class);
    private final int major;
    private final int minor;
    private final ExtensionRegistry extensionRegistry;
    private final TransformerRegistry transformerRegistry;
    private final Map<String, String> subsystemVersions = Collections.synchronizedMap(new HashMap());

    private TransformationTargetImpl(int majorManagementVersion, int minorManagementVersion, ModelNode subsystemVersions) {
        this.major = majorManagementVersion;
        this.minor = minorManagementVersion;
        this.transformerRegistry = TransformerRegistry.getInstance();
        this.extensionRegistry = this.transformerRegistry.getExtensionRegistry();
        for (Property p : subsystemVersions.asPropertyList()) {
            this.subsystemVersions.put(p.getName(), p.getValue().asString());
        }
    }

    public static TransformationTargetImpl create(int majorManagementVersion, int minorManagementVersion, ModelNode subsystemVersions) {
        return new TransformationTargetImpl(majorManagementVersion, minorManagementVersion, subsystemVersions);
    }

    @Override
    public String getManagementVersion() {
        return this.major + "." + this.minor;
    }

    @Override
    public int getMajorManagementVersion() {
        return this.major;
    }

    @Override
    public int getMinorManagementVersion() {
        return this.minor;
    }

    @Override
    public String getSubsystemVersion(String subsystemName) {
        return this.subsystemVersions.get(subsystemName);
    }

    @Override
    public SubsystemInformation getSubsystemInformation(String subsystemName) {
        return this.extensionRegistry.getSubsystemInfo(subsystemName);
    }

    @Override
    public OperationTransformer resolveTransformer(PathAddress address, String operationName) {
        return null;
    }

    @Override
    public SubsystemTransformer getSubsystemTransformer(String subsystemName) {
        if (!this.subsystemVersions.containsKey(subsystemName)) {
            return null;
        }
        SubsystemInformation info = this.getSubsystemInformation(subsystemName);
        String[] version = this.getSubsystemVersion(subsystemName).split("\\.");
        int major = Integer.parseInt(version[0]);
        int minor = Integer.parseInt(version[1]);
        if (info.getManagementInterfaceMajorVersion() == major && info.getManagementInterfaceMinorVersion() == minor) {
            return null;
        }
        SubsystemTransformer t = this.transformerRegistry.getSubsystemTransformer(subsystemName, major, minor);
        if (t == null) {
            log.warn((Object)("We have no transformer for subsystem: " + subsystemName + "-" + major + "." + minor + " model transfer can break!"));
        }
        return t;
    }

    @Override
    public boolean isTransformationNeeded() {
        return this.major != 1 || this.minor != 2;
    }

    @Override
    public void addSubsystemVersion(String subsystemName, int majorVersion, int minorVersion) {
        StringBuilder sb = new StringBuilder(String.valueOf(majorVersion)).append('.').append(minorVersion);
        this.subsystemVersions.put(subsystemName, sb.toString());
    }
}

