/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Streams {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File targetDir) {
        byte[] buff = new byte[1024];
        if (targetDir.exists()) {
            targetDir.delete();
        }
        ZipFile file = null;
        try {
            file = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File extractTarget = new File(targetDir.getAbsolutePath(), entry.getName());
                if (entry.isDirectory()) {
                    extractTarget.mkdirs();
                    continue;
                }
                File parent = new File(extractTarget.getParent());
                parent.mkdirs();
                BufferedInputStream in = new BufferedInputStream(file.getInputStream(entry));
                try {
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(extractTarget));
                    try {
                        int read = 0;
                        while ((read = in.read(buff)) != -1) {
                            out.write(buff, 0, read);
                        }
                    }
                    finally {
                        Streams.safeClose(out);
                    }
                }
                finally {
                    Streams.safeClose(in);
                }
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(String.format("Error extracting '%s'", file == null ? "null file" : file.getName()), e);
            }
            catch (Throwable throwable) {
                Streams.safeClose(file);
                throw throwable;
            }
        }
        Streams.safeClose(file);
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void safeClose(ZipFile file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

