/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import org.jboss.jdocbook.profile.Profiler;
import org.jboss.jdocbook.profile.ProfilingSource;
import org.jboss.jdocbook.render.FormatOptions;
import org.jboss.jdocbook.render.Renderer;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.RenderingSource;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.maven.plugins.jdocbook.AbstractDocBookMojo;
import org.jboss.maven.plugins.jdocbook.Matcher;

public class GenerationMojo
extends AbstractDocBookMojo {
    @Override
    protected void process() throws XSLTException, RenderingException {
        if (!this.sourceDirectory.exists()) {
            this.getLog().info((CharSequence)("sourceDirectory [" + this.sourceDirectory.getAbsolutePath() + "] did not exist"));
            return;
        }
        Profiler profiler = this.getComponentRegistry().getProfiler();
        Renderer renderer = this.getComponentRegistry().getRenderer();
        Matcher<String> matcher = new Matcher<String>(this.getRequestedFormat());
        for (AbstractDocBookMojo.PublishingSource publishingSource : this.resolvePublishingSources()) {
            if (this.profiling.isEnabled()) {
                profiler.profile((ProfilingSource)publishingSource);
            }
            for (FormatOptions formatOptions : this.getFormatOptionsList()) {
                if (!matcher.matches(formatOptions.getName())) continue;
                renderer.render((RenderingSource)publishingSource, formatOptions);
            }
        }
    }
}

