/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientWebTarget;

public class ResteasyClientImpl
implements ResteasyClient {
    protected volatile ClientHttpEngine httpEngine;
    protected volatile ExecutorService asyncInvocationExecutor;
    protected volatile ScheduledExecutorService scheduledExecutorService;
    protected ClientConfiguration configuration;
    protected boolean closed;
    protected boolean cleanupExecutor;

    protected ResteasyClientImpl(ClientHttpEngine httpEngine, ExecutorService asyncInvocationExecutor, boolean cleanupExecutor, ScheduledExecutorService scheduledExecutorService, ClientConfiguration configuration) {
        this.cleanupExecutor = cleanupExecutor;
        this.httpEngine = httpEngine;
        this.asyncInvocationExecutor = asyncInvocationExecutor;
        this.configuration = configuration;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    protected ResteasyClientImpl(ClientHttpEngine httpEngine, ExecutorService asyncInvocationExecutor, boolean cleanupExecutor, ClientConfiguration configuration) {
        this.cleanupExecutor = cleanupExecutor;
        this.httpEngine = httpEngine;
        this.asyncInvocationExecutor = asyncInvocationExecutor;
        this.configuration = configuration;
    }

    public ClientHttpEngine httpEngine() {
        this.abortIfClosed();
        return this.httpEngine;
    }

    public ExecutorService asyncInvocationExecutor() {
        return this.asyncInvocationExecutor;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutorService;
    }

    public void abortIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException(Messages.MESSAGES.clientIsClosed());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        try {
            this.httpEngine.close();
            if (this.cleanupExecutor) {
                if (System.getSecurityManager() == null) {
                    this.asyncInvocationExecutor.shutdown();
                } else {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            ResteasyClientImpl.this.asyncInvocationExecutor.shutdown();
                            return null;
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration getConfiguration() {
        this.abortIfClosed();
        return this.configuration;
    }

    public SSLContext getSslContext() {
        this.abortIfClosed();
        return this.httpEngine().getSslContext();
    }

    public HostnameVerifier getHostnameVerifier() {
        this.abortIfClosed();
        return this.httpEngine().getHostnameVerifier();
    }

    public ResteasyClientImpl property(String name, Object value) {
        this.abortIfClosed();
        this.configuration.property(name, value);
        return this;
    }

    public ResteasyClientImpl register(Class<?> componentClass) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass);
        return this;
    }

    public ResteasyClientImpl register(Class<?> componentClass, int priority) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, priority);
        return this;
    }

    public ResteasyClientImpl register(Class<?> componentClass, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, (Class[])contracts);
        return this;
    }

    public ResteasyClientImpl register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register((Class)componentClass, (Map)contracts);
        return this;
    }

    public ResteasyClientImpl register(Object component) {
        this.abortIfClosed();
        this.configuration.register(component);
        return this;
    }

    public ResteasyClientImpl register(Object component, int priority) {
        this.abortIfClosed();
        this.configuration.register(component, priority);
        return this;
    }

    public ResteasyClientImpl register(Object component, Class<?> ... contracts) {
        this.abortIfClosed();
        this.configuration.register(component, (Class[])contracts);
        return this;
    }

    public ResteasyClientImpl register(Object component, Map<Class<?>, Integer> contracts) {
        this.abortIfClosed();
        this.configuration.register(component, (Map)contracts);
        return this;
    }

    public ResteasyWebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        this.abortIfClosed();
        if (uri == null) {
            throw new NullPointerException(Messages.MESSAGES.uriWasNull());
        }
        return this.createClientWebTarget(this, uri, this.configuration);
    }

    public ResteasyWebTarget target(URI uri) throws NullPointerException {
        this.abortIfClosed();
        if (uri == null) {
            throw new NullPointerException(Messages.MESSAGES.uriWasNull());
        }
        return this.createClientWebTarget(this, uri, this.configuration);
    }

    public ResteasyWebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        this.abortIfClosed();
        if (uriBuilder == null) {
            throw new NullPointerException(Messages.MESSAGES.uriBuilderWasNull());
        }
        return this.createClientWebTarget(this, uriBuilder, this.configuration);
    }

    public ResteasyWebTarget target(Link link) throws NullPointerException {
        this.abortIfClosed();
        if (link == null) {
            throw new NullPointerException(Messages.MESSAGES.linkWasNull());
        }
        URI uri = link.getUri();
        return this.createClientWebTarget(this, uri, this.configuration);
    }

    public Invocation.Builder invocation(Link link) throws NullPointerException, IllegalArgumentException {
        this.abortIfClosed();
        if (link == null) {
            throw new NullPointerException(Messages.MESSAGES.linkWasNull());
        }
        ResteasyWebTarget target = this.target(link);
        if (link.getType() != null) {
            return target.request(new String[]{link.getType()});
        }
        return target.request();
    }

    protected ResteasyWebTarget createClientWebTarget(ResteasyClientImpl client, String uri, ClientConfiguration configuration) {
        return new ClientWebTarget((ResteasyClient)client, uri, configuration);
    }

    protected ResteasyWebTarget createClientWebTarget(ResteasyClientImpl client, URI uri, ClientConfiguration configuration) {
        return new ClientWebTarget((ResteasyClient)client, uri, configuration);
    }

    protected ResteasyWebTarget createClientWebTarget(ResteasyClientImpl client, UriBuilder uriBuilder, ClientConfiguration configuration) {
        return new ClientWebTarget((ResteasyClient)client, uriBuilder, configuration);
    }
}

