/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.PublisherRxInvoker;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.reactivestreams.Publisher;

public abstract class PublisherRxInvokerImpl
implements PublisherRxInvoker {
    private final ClientInvocationBuilder builder;

    public PublisherRxInvokerImpl(ClientInvocationBuilder builder) {
        this.builder = builder;
    }

    protected abstract <T> Publisher<T> toPublisher(CompletionStage<T> var1);

    private <T> Publisher<T> mkPublisher(String method, Entity<?> entity, Function<ClientInvocation, Publisher<T>> mkPublisher) {
        ClientInvocation invocation = this.builder.createClientInvocation(this.builder.invocation);
        invocation.setMethod(method);
        invocation.setEntity(entity);
        return mkPublisher.apply(invocation);
    }

    private Publisher<Response> mkPublisher(String method, Entity<?> entity) {
        return this.mkPublisher(method, entity, (ClientInvocation invocation) -> invocation.reactive().map(ClientInvocation.ReactiveInvocation::submit).orElseGet(() -> this.toPublisher(invocation.submitCF())));
    }

    private <T> Publisher<T> mkPublisher(String method, Entity<?> entity, Class<T> responseType) {
        return this.mkPublisher(method, entity, (ClientInvocation invocation) -> invocation.reactive().map(r -> r.submit(responseType)).orElseGet(() -> this.toPublisher(invocation.submitCF(responseType))));
    }

    private <T> Publisher<T> mkPublisher(String method, Entity<?> entity, GenericType<T> responseType) {
        return this.mkPublisher(method, entity, (ClientInvocation invocation) -> invocation.reactive().map(r -> r.submit(responseType)).orElseGet(() -> this.toPublisher(invocation.submitCF(responseType))));
    }

    public Publisher<Response> get() {
        return this.mkPublisher("GET", null);
    }

    public <T> Publisher<T> get(Class<T> responseType) {
        return this.mkPublisher("GET", null, responseType);
    }

    public <T> Publisher<T> get(GenericType<T> responseType) {
        return this.mkPublisher("GET", null, responseType);
    }

    public Publisher<Response> put(Entity<?> entity) {
        return this.mkPublisher("PUT", entity);
    }

    public <T> Publisher<T> put(Entity<?> entity, Class<T> clazz) {
        return this.mkPublisher("PUT", entity, clazz);
    }

    public <T> Publisher<T> put(Entity<?> entity, GenericType<T> type) {
        return this.mkPublisher("PUT", entity, type);
    }

    public Publisher<Response> post(Entity<?> entity) {
        return this.mkPublisher("POST", entity);
    }

    public <T> Publisher<T> post(Entity<?> entity, Class<T> clazz) {
        return this.mkPublisher("POST", entity, clazz);
    }

    public <T> Publisher<T> post(Entity<?> entity, GenericType<T> type) {
        return this.mkPublisher("POST", entity, type);
    }

    public Publisher<Response> delete() {
        return this.mkPublisher("DELETE", null);
    }

    public <T> Publisher<T> delete(Class<T> responseType) {
        return this.mkPublisher("DELETE", null, responseType);
    }

    public <T> Publisher<T> delete(GenericType<T> responseType) {
        return this.mkPublisher("DELETE", null, responseType);
    }

    public Publisher<Response> head() {
        return this.mkPublisher("HEAD", null);
    }

    public Publisher<Response> options() {
        return this.mkPublisher("OPTIONS", null);
    }

    public <T> Publisher<T> options(Class<T> responseType) {
        return this.mkPublisher("OPTIONS", null, responseType);
    }

    public <T> Publisher<T> options(GenericType<T> responseType) {
        return this.mkPublisher("OPTIONS", null, responseType);
    }

    public Publisher<Response> trace() {
        return this.method("TRACE");
    }

    public <T> Publisher<T> trace(Class<T> responseType) {
        return this.method("TRACE", responseType);
    }

    public <T> Publisher<T> trace(GenericType<T> responseType) {
        return this.method("TRACE", responseType);
    }

    public Publisher<Response> method(String name) {
        return this.mkPublisher(name, null);
    }

    public <T> Publisher<T> method(String name, Class<T> responseType) {
        return this.mkPublisher(name, null, responseType);
    }

    public <T> Publisher<T> method(String name, GenericType<T> responseType) {
        return this.mkPublisher(name, null, responseType);
    }

    public Publisher<Response> method(String name, Entity<?> entity) {
        return this.mkPublisher(name, entity);
    }

    public <T> Publisher<T> method(String name, Entity<?> entity, Class<T> responseType) {
        return this.mkPublisher(name, entity, responseType);
    }

    public <T> Publisher<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        return this.mkPublisher(name, entity, responseType);
    }
}

