/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.newt.Display;
import com.jogamp.newt.ScreenMode;
import com.jogamp.newt.event.ScreenModeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeWindowException;
import jogamp.newt.Debug;

public abstract class Screen {
    public static final int SCREEN_MODE_CHANGE_TIMEOUT = 10000;
    public static final boolean DEBUG = Debug.debug("Screen");
    protected static ArrayList<Screen> screenList = new ArrayList();
    protected static int screensActive = 0;

    public abstract int hashCode();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Screen) {
            Screen screen = (Screen)object;
            return screen.getFQName().equals(this.getFQName());
        }
        return false;
    }

    public abstract void createNative() throws NativeWindowException;

    public abstract void destroy();

    public abstract boolean isNativeValid();

    public abstract int getReferenceCount();

    public abstract int addReference() throws NativeWindowException;

    public abstract int removeReference();

    public abstract AbstractGraphicsScreen getGraphicsScreen();

    public abstract int getIndex();

    public abstract int getX();

    public abstract int getY();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract Display getDisplay();

    public abstract String getFQName();

    public abstract void addScreenModeListener(ScreenModeListener var1);

    public abstract void removeScreenModeListener(ScreenModeListener var1);

    public abstract List<ScreenMode> getScreenModes();

    public abstract ScreenMode getOriginalScreenMode();

    public abstract ScreenMode getCurrentScreenMode();

    public abstract boolean setCurrentScreenMode(ScreenMode var1);

    public static Screen getFirstScreenOf(Display display, int n, int n2) {
        return Screen.getScreenOfImpl(display, n, n2, 1);
    }

    public static Screen getLastScreenOf(Display display, int n, int n2) {
        return Screen.getScreenOfImpl(display, n, n2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Screen getScreenOfImpl(Display display, int n, int n2, int n3) {
        ArrayList<Screen> arrayList = screenList;
        synchronized (arrayList) {
            int n4;
            int n5 = n4 = n2 >= 0 ? n2 : screenList.size() - 1;
            while (n3 > 0 ? n4 < screenList.size() : n4 >= 0) {
                Screen screen = screenList.get(n4);
                if (screen.getDisplay().equals(display) && screen.getIndex() == n) {
                    return screen;
                }
                n4 += n3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Screen> getAllScreens() {
        ArrayList arrayList;
        ArrayList<Screen> arrayList2 = screenList;
        synchronized (arrayList2) {
            arrayList = (ArrayList)screenList.clone();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getActiveScreenNumber() {
        ArrayList<Screen> arrayList = screenList;
        synchronized (arrayList) {
            return screensActive;
        }
    }
}

