/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunkBKGD;
import jogamp.opengl.util.pngj.chunks.PngChunkCHRM;
import jogamp.opengl.util.pngj.chunks.PngChunkGAMA;
import jogamp.opengl.util.pngj.chunks.PngChunkHIST;
import jogamp.opengl.util.pngj.chunks.PngChunkICCP;
import jogamp.opengl.util.pngj.chunks.PngChunkIDAT;
import jogamp.opengl.util.pngj.chunks.PngChunkIEND;
import jogamp.opengl.util.pngj.chunks.PngChunkIHDR;
import jogamp.opengl.util.pngj.chunks.PngChunkITXT;
import jogamp.opengl.util.pngj.chunks.PngChunkPHYS;
import jogamp.opengl.util.pngj.chunks.PngChunkPLTE;
import jogamp.opengl.util.pngj.chunks.PngChunkSBIT;
import jogamp.opengl.util.pngj.chunks.PngChunkSPLT;
import jogamp.opengl.util.pngj.chunks.PngChunkSRGB;
import jogamp.opengl.util.pngj.chunks.PngChunkTEXT;
import jogamp.opengl.util.pngj.chunks.PngChunkTIME;
import jogamp.opengl.util.pngj.chunks.PngChunkTRNS;
import jogamp.opengl.util.pngj.chunks.PngChunkUNKNOWN;
import jogamp.opengl.util.pngj.chunks.PngChunkZTXT;

public abstract class PngChunk {
    public final String id;
    public final boolean crit;
    public final boolean pub;
    public final boolean safe;
    private int lenori = -1;
    private boolean writePriority = false;
    protected final ImageInfo imgInfo;
    private int chunkGroup = -1;
    public static final Map<String, Class<? extends PngChunk>> factoryMap = new HashMap<String, Class<? extends PngChunk>>();

    protected PngChunk(String string, ImageInfo imageInfo) {
        this.id = string;
        this.imgInfo = imageInfo;
        this.crit = ChunkHelper.isCritical(string);
        this.pub = ChunkHelper.isPublic(string);
        this.safe = ChunkHelper.isSafeToCopy(string);
    }

    public abstract ChunkRaw createChunk();

    public abstract void parseFromChunk(ChunkRaw var1);

    public abstract void cloneDataFromRead(PngChunk var1);

    public static <T extends PngChunk> T cloneChunk(T t, ImageInfo imageInfo) {
        PngChunk pngChunk = PngChunk.factoryFromId(t.id, imageInfo);
        if (pngChunk.getClass() != t.getClass()) {
            throw new PngjException("bad class cloning chunk: " + pngChunk.getClass() + " " + t.getClass());
        }
        pngChunk.cloneDataFromRead(t);
        return (T)pngChunk;
    }

    public static PngChunk factory(ChunkRaw chunkRaw, ImageInfo imageInfo) {
        PngChunk pngChunk = PngChunk.factoryFromId(ChunkHelper.toString(chunkRaw.idbytes), imageInfo);
        pngChunk.lenori = chunkRaw.len;
        pngChunk.parseFromChunk(chunkRaw);
        return pngChunk;
    }

    public static PngChunk factoryFromId(String string, ImageInfo imageInfo) {
        PngChunk pngChunk = null;
        try {
            Class<? extends PngChunk> clazz = factoryMap.get(string);
            if (clazz != null) {
                Constructor<? extends PngChunk> constructor = clazz.getConstructor(ImageInfo.class);
                pngChunk = constructor.newInstance(imageInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pngChunk == null) {
            pngChunk = new PngChunkUNKNOWN(string, imageInfo);
        }
        return pngChunk;
    }

    protected ChunkRaw createEmptyChunk(int n, boolean bl) {
        ChunkRaw chunkRaw = new ChunkRaw(n, ChunkHelper.toBytes(this.id), bl);
        return chunkRaw;
    }

    public String toString() {
        return "chunk id= " + this.id + " (" + this.lenori + ") c=" + this.getClass().getSimpleName();
    }

    void setPriority(boolean bl) {
        this.writePriority = bl;
    }

    void write(OutputStream outputStream) {
        ChunkRaw chunkRaw = this.createChunk();
        if (chunkRaw == null) {
            throw new PngjException("null chunk ! creation failed for " + this);
        }
        chunkRaw.writeChunk(outputStream);
    }

    public boolean isWritePriority() {
        return this.writePriority;
    }

    public boolean allowsMultiple() {
        return false;
    }

    public boolean mustGoBeforeIDAT() {
        return false;
    }

    public boolean mustGoBeforePLTE() {
        return false;
    }

    public boolean mustGoAfterPLTE() {
        return false;
    }

    static boolean isKnown(String string) {
        return factoryMap.containsKey(string);
    }

    public int getChunkGroup() {
        return this.chunkGroup;
    }

    public void setChunkGroup(int n) {
        this.chunkGroup = n;
    }

    static {
        factoryMap.put("IDAT", PngChunkIDAT.class);
        factoryMap.put("IHDR", PngChunkIHDR.class);
        factoryMap.put("PLTE", PngChunkPLTE.class);
        factoryMap.put("IEND", PngChunkIEND.class);
        factoryMap.put("tEXt", PngChunkTEXT.class);
        factoryMap.put("iTXt", PngChunkITXT.class);
        factoryMap.put("zTXt", PngChunkZTXT.class);
        factoryMap.put("bKGD", PngChunkBKGD.class);
        factoryMap.put("gAMA", PngChunkGAMA.class);
        factoryMap.put("pHYs", PngChunkPHYS.class);
        factoryMap.put("iCCP", PngChunkICCP.class);
        factoryMap.put("tIME", PngChunkTIME.class);
        factoryMap.put("tRNS", PngChunkTRNS.class);
        factoryMap.put("cHRM", PngChunkCHRM.class);
        factoryMap.put("sBIT", PngChunkSBIT.class);
        factoryMap.put("sRGB", PngChunkSRGB.class);
        factoryMap.put("hIST", PngChunkHIST.class);
        factoryMap.put("sPLT", PngChunkSPLT.class);
    }
}

