/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkList;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkITXT;
import jogamp.opengl.util.pngj.chunks.PngChunkPHYS;
import jogamp.opengl.util.pngj.chunks.PngChunkTEXT;
import jogamp.opengl.util.pngj.chunks.PngChunkTIME;
import jogamp.opengl.util.pngj.chunks.PngChunkTextVar;
import jogamp.opengl.util.pngj.chunks.PngChunkZTXT;

public class PngMetadata {
    private final ChunkList chunkList;
    private final boolean readonly;

    public PngMetadata(ChunkList chunkList, boolean bl) {
        this.chunkList = chunkList;
        this.readonly = bl;
    }

    public boolean setChunk(PngChunk pngChunk, boolean bl) {
        if (this.readonly) {
            throw new PngjException("cannot set chunk : readonly metadata");
        }
        return this.chunkList.setChunk(pngChunk, bl);
    }

    public PngChunk getChunk1(String string, String string2, boolean bl) {
        return this.chunkList.getChunk1(string, string2, bl);
    }

    public PngChunk getChunk1(String string) {
        return this.chunkList.getChunk1(string);
    }

    public double[] getDpi() {
        PngChunk pngChunk = this.getChunk1("pHYs", null, true);
        if (pngChunk == null) {
            return new double[]{-1.0, -1.0};
        }
        return ((PngChunkPHYS)pngChunk).getAsDpi2();
    }

    public void setDpi(double d) {
        this.setDpi(d, d);
    }

    public void setDpi(double d, double d2) {
        PngChunkPHYS pngChunkPHYS = new PngChunkPHYS(this.chunkList.imageInfo);
        pngChunkPHYS.setAsDpi2(d, d2);
        this.setChunk(pngChunkPHYS, true);
    }

    public void setTimeNow(int n) {
        PngChunkTIME pngChunkTIME = new PngChunkTIME(this.chunkList.imageInfo);
        pngChunkTIME.setNow(n);
        this.setChunk(pngChunkTIME, true);
    }

    public void setTimeYMDHMS(int n, int n2, int n3, int n4, int n5, int n6) {
        PngChunkTIME pngChunkTIME = new PngChunkTIME(this.chunkList.imageInfo);
        pngChunkTIME.setYMDHMS(n, n2, n3, n4, n5, n6);
        this.setChunk(pngChunkTIME, true);
    }

    public String getTimeAsString() {
        PngChunk pngChunk = this.getChunk1("tIME", null, true);
        return pngChunk != null ? ((PngChunkTIME)pngChunk).getAsString() : "";
    }

    public void setText(String string, String string2, boolean bl, boolean bl2) {
        PngChunkTextVar pngChunkTextVar;
        if (bl2 && !bl) {
            throw new PngjException("cannot compress non latin text");
        }
        if (bl) {
            pngChunkTextVar = bl2 ? new PngChunkZTXT(this.chunkList.imageInfo) : new PngChunkTEXT(this.chunkList.imageInfo);
        } else {
            pngChunkTextVar = new PngChunkITXT(this.chunkList.imageInfo);
            ((PngChunkITXT)pngChunkTextVar).setLangtag(string);
        }
        pngChunkTextVar.setKeyVal(string, string2);
        this.setChunk(pngChunkTextVar, true);
    }

    public void setText(String string, String string2) {
        this.setText(string, string2, false, string2.length() > 400);
    }

    public String getTxtForKey(String string) {
        PngChunk pngChunk = this.getChunk1("tEXt", string, true);
        if (pngChunk == null) {
            pngChunk = this.getChunk1("zTXt", string, true);
        }
        if (pngChunk == null) {
            pngChunk = this.getChunk1("iTXt", string, true);
        }
        return pngChunk != null ? ((PngChunkTextVar)pngChunk).getVal() : null;
    }
}

