/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.luaj.vm2.ast.Chunk;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.luaj.vm2.lua2java.JavaCodeGen;
import org.luaj.vm2.parser.LuaParser;

public class lua2java {
    private static final String version = "Luaj-jse 2.0.2Copyright (C) 2010 luaj.org";
    private static final String usage = "usage: java -cp luaj-jse.jar lua2java [options] fileordir [, fileordir ...]\nAvailable options are:\n  -\t\tprocess stdin\n  -s src\tsource directory\n  -d dir\tdestination directory\n  -p pkg\tpackage prefix to apply to all classes\n  -e enc\toverride default character encoding\n  -r\t\trecursively compile all\n  -v   \tverbose\n";
    private String srcdir = null;
    private String destdir = null;
    private String pkgprefix = null;
    private String encoding = "ISO8859-1";
    private boolean recurse = false;
    private boolean verbose = false;
    private List files = new ArrayList();

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] stringArray) throws IOException {
        new lua2java(stringArray);
    }

    private lua2java(String[] stringArray) throws IOException {
        try {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            block10: for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].startsWith("-")) {
                    arrayList.add(stringArray[n]);
                    continue;
                }
                switch (stringArray[n].charAt(1)) {
                    case 's': {
                        if (++n >= stringArray.length) {
                            lua2java.usageExit();
                        }
                        this.srcdir = stringArray[n];
                        continue block10;
                    }
                    case 'd': {
                        if (++n >= stringArray.length) {
                            lua2java.usageExit();
                        }
                        this.destdir = stringArray[n];
                        continue block10;
                    }
                    case 'p': {
                        if (++n >= stringArray.length) {
                            lua2java.usageExit();
                        }
                        this.pkgprefix = stringArray[n];
                        continue block10;
                    }
                    case 'e': {
                        if (++n >= stringArray.length) {
                            lua2java.usageExit();
                        }
                        this.encoding = stringArray[n];
                        continue block10;
                    }
                    case 'r': {
                        this.recurse = true;
                        continue block10;
                    }
                    case 'v': {
                        this.verbose = true;
                        continue block10;
                    }
                    default: {
                        lua2java.usageExit();
                    }
                }
            }
            if (this.verbose) {
                System.out.println(version);
                System.out.println("srcdir: " + this.srcdir);
                System.out.println("destdir: " + this.destdir);
                System.out.println("files: " + arrayList);
                System.out.println("encoding: " + this.encoding);
                System.out.println("recurse: " + this.recurse);
            }
            if (arrayList.size() <= 0) {
                System.err.println(usage);
                System.exit(-1);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.collectFiles(this.srcdir + "/" + arrayList.get(n));
            }
            if (this.files.size() <= 0) {
                System.err.println("no files found in " + arrayList);
                System.exit(-1);
            }
            JsePlatform.standardGlobals();
            int n2 = this.files.size();
            for (n = 0; n < n2; ++n) {
                this.processFile((InputFile)this.files.get(n));
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(-2);
        }
    }

    private void collectFiles(String string) {
        File file;
        File file2 = new File(string);
        if (file2.isDirectory() && this.recurse) {
            this.scandir(file2, this.pkgprefix);
        } else if (file2.isFile() && (file = file2.getAbsoluteFile().getParentFile()) != null) {
            this.scanfile(file, file2, this.pkgprefix);
        }
    }

    private void scandir(File file, String string) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.scanfile(file, fileArray[i], string);
        }
    }

    private void scanfile(File file, File file2, String string) {
        if (file2.exists()) {
            if (file2.isDirectory() && this.recurse) {
                this.scandir(file2, string != null ? string + "." + file2.getName() : file2.getName());
            } else if (file2.isFile() && file2.getName().endsWith(".lua")) {
                this.files.add(new InputFile(file, file2, string));
            }
        }
    }

    private void processFile(InputFile inputFile) {
        inputFile.outdir.mkdirs();
        try {
            if (this.verbose) {
                System.out.println("pkg=" + inputFile.javapackage + " file=" + inputFile.javaclassname + ".java dest=" + inputFile.outfile + " src=" + inputFile.infile);
            }
            FileInputStream fileInputStream = new FileInputStream(inputFile.infile);
            FileOutputStream fileOutputStream = new FileOutputStream(inputFile.outfile);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            LuaParser luaParser = new LuaParser(fileInputStream, this.encoding);
            Chunk chunk = luaParser.Chunk();
            new JavaCodeGen(chunk, printWriter, inputFile.javapackage, inputFile.javaclassname);
            printWriter.close();
            fileOutputStream.close();
            fileInputStream.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }

    class InputFile {
        public File infile;
        public File outdir;
        public File outfile;
        public String javapackage;
        public String javaclassname;

        public InputFile(File file, File file2, String string) {
            String string2 = string != null ? lua2java.this.destdir + "/" + string.replace('.', '/') : lua2java.this.destdir;
            this.javaclassname = file2.getName().substring(0, file2.getName().lastIndexOf(46));
            this.javapackage = string;
            this.infile = file2;
            this.outdir = new File(string2);
            this.outfile = new File(string2 + "/" + this.javaclassname + ".java");
        }
    }
}

