/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.DebugLib;

public class LuaThread
extends LuaValue
implements Runnable {
    public static LuaValue s_metatable;
    private static final int STATUS_SUSPENDED = 0;
    private static final int STATUS_RUNNING = 1;
    private static final int STATUS_NORMAL = 2;
    private static final int STATUS_DEAD = 3;
    private static final int STATUS_ERROR = 4;
    private static final String[] STATUS_NAMES;
    private int status = 0;
    private Thread thread;
    private LuaValue env;
    private LuaValue func;
    private Varargs args;
    public LuaValue err;
    public static final int MAX_CALLSTACK = 256;
    public final LuaFunction[] callstack = new LuaFunction[256];
    public int calls = 0;
    private static final LuaThread mainthread;
    private static LuaThread running_thread;
    public Object debugState;

    LuaThread() {
    }

    public LuaThread(LuaValue luaValue, LuaValue luaValue2) {
        this.env = luaValue2;
        this.func = luaValue;
    }

    public int type() {
        return 8;
    }

    public String typename() {
        return "thread";
    }

    public boolean isthread() {
        return true;
    }

    public LuaThread optthread(LuaThread luaThread) {
        return this;
    }

    public LuaThread checkthread() {
        return this;
    }

    public LuaValue getmetatable() {
        return s_metatable;
    }

    public LuaValue getfenv() {
        return this.env;
    }

    public void setfenv(LuaValue luaValue) {
        this.env = luaValue;
    }

    public String getStatus() {
        return STATUS_NAMES[this.status];
    }

    public static LuaThread getRunning() {
        return running_thread;
    }

    public static boolean isMainThread(LuaThread luaThread) {
        return luaThread == mainthread;
    }

    public static void setGlobals(LuaValue luaValue) {
        LuaThread.running_thread.env = luaValue;
    }

    public static LuaValue getGlobals() {
        LuaValue luaValue = LuaThread.running_thread.env;
        return luaValue != null ? luaValue : LuaValue.error("LuaThread.setGlobals() not initialized");
    }

    public static final void onCall(LuaFunction luaFunction) {
        LuaThread.running_thread.callstack[LuaThread.running_thread.calls++] = luaFunction;
        if (DebugLib.DEBUG_ENABLED) {
            DebugLib.debugOnCall(running_thread, LuaThread.running_thread.calls, luaFunction);
        }
    }

    public static final void onReturn() {
        LuaThread.running_thread.callstack[--LuaThread.running_thread.calls] = null;
        if (DebugLib.DEBUG_ENABLED) {
            DebugLib.debugOnReturn(running_thread, LuaThread.running_thread.calls);
        }
    }

    public static int getCallstackDepth() {
        return LuaThread.running_thread.calls;
    }

    public static final LuaFunction getCallstackFunction(int n) {
        return n > 0 && n <= LuaThread.running_thread.calls ? LuaThread.running_thread.callstack[LuaThread.running_thread.calls - n] : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LuaThread luaThread = this;
        synchronized (luaThread) {
            try {
                this.args = this.func.invoke(this.args);
                this.status = 3;
            }
            catch (Throwable throwable) {
                String string = throwable.getMessage();
                this.args = LuaThread.valueOf(string != null ? string : throwable.toString());
                this.status = 4;
            }
            finally {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Varargs yield(Varargs varargs) {
        LuaThread luaThread = this;
        synchronized (luaThread) {
            if (this.status != 1) {
                LuaThread.error(this + " not running");
            }
            this.status = 0;
            this.args = varargs;
            this.notify();
            try {
                this.wait();
                this.status = 1;
                return this.args;
            }
            catch (InterruptedException interruptedException) {
                this.status = 3;
                LuaThread.error("thread interrupted");
                return NONE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Varargs resume(Varargs varargs) {
        LuaThread luaThread = this;
        synchronized (luaThread) {
            Varargs varargs2;
            LuaThread luaThread2;
            block14: {
                if (this.status == 3) {
                    return LuaThread.varargsOf(FALSE, (Varargs)LuaThread.valueOf("cannot resume dead coroutine"));
                }
                luaThread2 = running_thread;
                luaThread2.status = 2;
                running_thread = this;
                this.status = 1;
                this.args = varargs;
                if (this.thread == null) {
                    this.thread = new Thread(this);
                    this.thread.start();
                }
                this.notify();
                this.wait();
                if (this.status != 4) break block14;
                this.status = 3;
                Varargs varargs3 = LuaThread.varargsOf(FALSE, this.args);
                running_thread = luaThread2;
                luaThread2.status = 1;
                return varargs3;
            }
            try {
                varargs2 = LuaThread.varargsOf(TRUE, this.args);
                running_thread = luaThread2;
                luaThread2.status = 1;
            }
            catch (Throwable throwable) {
                try {
                    Varargs varargs4;
                    this.status = 3;
                    try {
                        varargs4 = LuaThread.varargsOf(FALSE, (Varargs)LuaThread.valueOf("thread: " + throwable));
                        this.notify();
                    }
                    catch (Throwable throwable2) {
                        this.notify();
                        throw throwable2;
                    }
                    return varargs4;
                }
                finally {
                    running_thread = luaThread2;
                    luaThread2.status = 1;
                }
            }
            return varargs2;
        }
    }

    static {
        STATUS_NAMES = new String[]{"suspended", "running", "normal", "dead"};
        running_thread = mainthread = new LuaThread();
    }
}

