/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import java.util.Hashtable;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.InstructionPtr;
import org.luaj.vm2.compiler.IntPtr;
import org.luaj.vm2.compiler.LexState;
import org.luaj.vm2.compiler.LuaC;

public class FuncState
extends LuaC {
    Prototype f;
    Hashtable htable;
    FuncState prev;
    LexState ls;
    LuaC L;
    BlockCnt bl;
    int pc;
    int lasttarget;
    IntPtr jpc;
    int freereg;
    int nk;
    int np;
    short nlocvars;
    short nactvar;
    upvaldesc[] upvalues = new upvaldesc[60];
    short[] actvar = new short[200];

    FuncState() {
    }

    InstructionPtr getcodePtr(LexState.expdesc expdesc2) {
        return new InstructionPtr(this.f.code, expdesc2.u.s.info);
    }

    int getcode(LexState.expdesc expdesc2) {
        return this.f.code[expdesc2.u.s.info];
    }

    int codeAsBx(int n, int n2, int n3) {
        return this.codeABx(n, n2, n3 + 131071);
    }

    void setmultret(LexState.expdesc expdesc2) {
        this.setreturns(expdesc2, -1);
    }

    LocVars getlocvar(int n) {
        return this.f.locvars[this.actvar[n]];
    }

    void checklimit(int n, int n2, String string) {
        if (n > n2) {
            this.errorlimit(n2, string);
        }
    }

    void errorlimit(int n, String string) {
        String string2 = this.f.linedefined == 0 ? this.L.pushfstring("main function has more than " + n + " " + string) : this.L.pushfstring("function at line " + this.f.linedefined + " has more than " + n + " " + string);
        this.ls.lexerror(string2, 0);
    }

    int indexupvalue(LuaString luaString, LexState.expdesc expdesc2) {
        for (int i = 0; i < this.f.nups; ++i) {
            if (this.upvalues[i].k != expdesc2.k || this.upvalues[i].info != expdesc2.u.s.info) continue;
            FuncState._assert(this.f.upvalues[i] == luaString);
            return i;
        }
        this.checklimit(this.f.nups + 1, 60, "upvalues");
        if (this.f.upvalues == null || this.f.nups + 1 > this.f.upvalues.length) {
            this.f.upvalues = FuncState.realloc(this.f.upvalues, this.f.nups * 2 + 1);
        }
        this.f.upvalues[this.f.nups] = luaString;
        FuncState._assert(expdesc2.k == 6 || expdesc2.k == 7);
        this.upvalues[this.f.nups] = new upvaldesc();
        this.upvalues[this.f.nups].k = (short)expdesc2.k;
        this.upvalues[this.f.nups].info = (short)expdesc2.u.s.info;
        return this.f.nups++;
    }

    int searchvar(LuaString luaString) {
        for (int i = this.nactvar - 1; i >= 0; --i) {
            if (luaString != this.getlocvar((int)i).varname) continue;
            return i;
        }
        return -1;
    }

    void markupval(int n) {
        BlockCnt blockCnt = this.bl;
        while (blockCnt != null && blockCnt.nactvar > n) {
            blockCnt = blockCnt.previous;
        }
        if (blockCnt != null) {
            blockCnt.upval = true;
        }
    }

    int singlevaraux(LuaString luaString, LexState.expdesc expdesc2, int n) {
        int n2 = this.searchvar(luaString);
        if (n2 >= 0) {
            expdesc2.init(6, n2);
            if (n == 0) {
                this.markupval(n2);
            }
            return 6;
        }
        if (this.prev == null) {
            expdesc2.init(8, 255);
            return 8;
        }
        if (this.prev.singlevaraux(luaString, expdesc2, 0) == 8) {
            return 8;
        }
        expdesc2.u.s.info = this.indexupvalue(luaString, expdesc2);
        expdesc2.k = 7;
        return 7;
    }

    void enterblock(BlockCnt blockCnt, boolean bl) {
        blockCnt.breaklist.i = -1;
        blockCnt.isbreakable = bl;
        blockCnt.nactvar = this.nactvar;
        blockCnt.upval = false;
        blockCnt.previous = this.bl;
        this.bl = blockCnt;
        FuncState._assert(this.freereg == this.nactvar);
    }

    void leaveblock() {
        BlockCnt blockCnt = this.bl;
        this.bl = blockCnt.previous;
        this.ls.removevars(blockCnt.nactvar);
        if (blockCnt.upval) {
            this.codeABC(35, blockCnt.nactvar, 0, 0);
        }
        FuncState._assert(!blockCnt.isbreakable || !blockCnt.upval);
        FuncState._assert(blockCnt.nactvar == this.nactvar);
        this.freereg = this.nactvar;
        this.patchtohere(blockCnt.breaklist.i);
    }

    void closelistfield(LexState.ConsControl consControl) {
        if (consControl.v.k == 0) {
            return;
        }
        this.exp2nextreg(consControl.v);
        consControl.v.k = 0;
        if (consControl.tostore == 50) {
            this.setlist(consControl.t.u.s.info, consControl.na, consControl.tostore);
            consControl.tostore = 0;
        }
    }

    boolean hasmultret(int n) {
        return n == 13 || n == 14;
    }

    void lastlistfield(LexState.ConsControl consControl) {
        if (consControl.tostore == 0) {
            return;
        }
        if (this.hasmultret(consControl.v.k)) {
            this.setmultret(consControl.v);
            this.setlist(consControl.t.u.s.info, consControl.na, -1);
            --consControl.na;
        } else {
            if (consControl.v.k != 0) {
                this.exp2nextreg(consControl.v);
            }
            this.setlist(consControl.t.u.s.info, consControl.na, consControl.tostore);
        }
    }

    void nil(int n, int n2) {
        if (this.pc > this.lasttarget) {
            if (this.pc == 0) {
                if (n >= this.nactvar) {
                    return;
                }
            } else {
                InstructionPtr instructionPtr = new InstructionPtr(this.f.code, this.pc - 1);
                if (FuncState.GET_OPCODE(instructionPtr.get()) == 3) {
                    int n3 = FuncState.GETARG_A(instructionPtr.get());
                    int n4 = FuncState.GETARG_B(instructionPtr.get());
                    if (n3 <= n && n <= n4 + 1) {
                        if (n + n2 - 1 > n4) {
                            FuncState.SETARG_B(instructionPtr, n + n2 - 1);
                        }
                        return;
                    }
                }
            }
        }
        this.codeABC(3, n, n + n2 - 1, 0);
    }

    int jump() {
        int n = this.jpc.i;
        this.jpc.i = -1;
        IntPtr intPtr = new IntPtr(this.codeAsBx(22, 0, -1));
        this.concat(intPtr, n);
        return intPtr.i;
    }

    void ret(int n, int n2) {
        this.codeABC(30, n, n2 + 1, 0);
    }

    int condjump(int n, int n2, int n3, int n4) {
        this.codeABC(n, n2, n3, n4);
        return this.jump();
    }

    void fixjump(int n, int n2) {
        InstructionPtr instructionPtr = new InstructionPtr(this.f.code, n);
        int n3 = n2 - (n + 1);
        FuncState._assert(n2 != -1);
        if (Math.abs(n3) > 131071) {
            this.ls.syntaxerror("control structure too long");
        }
        FuncState.SETARG_sBx(instructionPtr, n3);
    }

    int getlabel() {
        this.lasttarget = this.pc;
        return this.pc;
    }

    int getjump(int n) {
        int n2 = FuncState.GETARG_sBx(this.f.code[n]);
        if (n2 == -1) {
            return -1;
        }
        return n + 1 + n2;
    }

    InstructionPtr getjumpcontrol(int n) {
        InstructionPtr instructionPtr = new InstructionPtr(this.f.code, n);
        if (n >= 1 && FuncState.testTMode(FuncState.GET_OPCODE(instructionPtr.code[instructionPtr.idx - 1]))) {
            return new InstructionPtr(instructionPtr.code, instructionPtr.idx - 1);
        }
        return instructionPtr;
    }

    boolean need_value(int n) {
        while (n != -1) {
            int n2 = this.getjumpcontrol(n).get();
            if (FuncState.GET_OPCODE(n2) != 27) {
                return true;
            }
            n = this.getjump(n);
        }
        return false;
    }

    boolean patchtestreg(int n, int n2) {
        InstructionPtr instructionPtr = this.getjumpcontrol(n);
        if (FuncState.GET_OPCODE(instructionPtr.get()) != 27) {
            return false;
        }
        if (n2 != 255 && n2 != FuncState.GETARG_B(instructionPtr.get())) {
            FuncState.SETARG_A(instructionPtr, n2);
        } else {
            instructionPtr.set(FuncState.CREATE_ABC(26, FuncState.GETARG_B(instructionPtr.get()), 0, Lua.GETARG_C(instructionPtr.get())));
        }
        return true;
    }

    void removevalues(int n) {
        while (n != -1) {
            this.patchtestreg(n, 255);
            n = this.getjump(n);
        }
    }

    void patchlistaux(int n, int n2, int n3, int n4) {
        while (n != -1) {
            int n5 = this.getjump(n);
            if (this.patchtestreg(n, n3)) {
                this.fixjump(n, n2);
            } else {
                this.fixjump(n, n4);
            }
            n = n5;
        }
    }

    void dischargejpc() {
        this.patchlistaux(this.jpc.i, this.pc, 255, this.pc);
        this.jpc.i = -1;
    }

    void patchlist(int n, int n2) {
        if (n2 == this.pc) {
            this.patchtohere(n);
        } else {
            FuncState._assert(n2 < this.pc);
            this.patchlistaux(n, n2, 255, n2);
        }
    }

    void patchtohere(int n) {
        this.getlabel();
        this.concat(this.jpc, n);
    }

    void concat(IntPtr intPtr, int n) {
        if (n == -1) {
            return;
        }
        if (intPtr.i == -1) {
            intPtr.i = n;
        } else {
            int n2;
            int n3 = intPtr.i;
            while ((n2 = this.getjump(n3)) != -1) {
                n3 = n2;
            }
            this.fixjump(n3, n);
        }
    }

    void checkstack(int n) {
        int n2 = this.freereg + n;
        if (n2 > this.f.maxstacksize) {
            if (n2 >= 250) {
                this.ls.syntaxerror("function or expression too complex");
            }
            this.f.maxstacksize = n2;
        }
    }

    void reserveregs(int n) {
        this.checkstack(n);
        this.freereg += n;
    }

    void freereg(int n) {
        if (!FuncState.ISK(n) && n >= this.nactvar) {
            --this.freereg;
            FuncState._assert(n == this.freereg);
        }
    }

    void freeexp(LexState.expdesc expdesc2) {
        if (expdesc2.k == 12) {
            this.freereg(expdesc2.u.s.info);
        }
    }

    int addk(LuaValue luaValue) {
        int n;
        if (this.htable.containsKey(luaValue)) {
            n = (Integer)this.htable.get(luaValue);
        } else {
            n = this.nk;
            this.htable.put(luaValue, new Integer(n));
            Prototype prototype = this.f;
            if (prototype.k == null || this.nk + 1 >= prototype.k.length) {
                prototype.k = FuncState.realloc(prototype.k, this.nk * 2 + 1);
            }
            prototype.k[this.nk++] = luaValue;
        }
        return n;
    }

    int stringK(LuaString luaString) {
        return this.addk(luaString);
    }

    int numberK(LuaValue luaValue) {
        int n;
        double d;
        if (luaValue instanceof LuaDouble && (d = luaValue.todouble()) == (double)(n = (int)d)) {
            luaValue = LuaInteger.valueOf(n);
        }
        return this.addk(luaValue);
    }

    int boolK(boolean bl) {
        return this.addk(bl ? LuaValue.TRUE : LuaValue.FALSE);
    }

    int nilK() {
        return this.addk(LuaValue.NIL);
    }

    void setreturns(LexState.expdesc expdesc2, int n) {
        if (expdesc2.k == 13) {
            FuncState.SETARG_C(this.getcodePtr(expdesc2), n + 1);
        } else if (expdesc2.k == 14) {
            FuncState.SETARG_B(this.getcodePtr(expdesc2), n + 1);
            FuncState.SETARG_A(this.getcodePtr(expdesc2), this.freereg);
            this.reserveregs(1);
        }
    }

    void setoneret(LexState.expdesc expdesc2) {
        if (expdesc2.k == 13) {
            expdesc2.k = 12;
            expdesc2.u.s.info = FuncState.GETARG_A(this.getcode(expdesc2));
        } else if (expdesc2.k == 14) {
            FuncState.SETARG_B(this.getcodePtr(expdesc2), 2);
            expdesc2.k = 11;
        }
    }

    void dischargevars(LexState.expdesc expdesc2) {
        switch (expdesc2.k) {
            case 6: {
                expdesc2.k = 12;
                break;
            }
            case 7: {
                expdesc2.u.s.info = this.codeABC(4, 0, expdesc2.u.s.info, 0);
                expdesc2.k = 11;
                break;
            }
            case 8: {
                expdesc2.u.s.info = this.codeABx(5, 0, expdesc2.u.s.info);
                expdesc2.k = 11;
                break;
            }
            case 9: {
                this.freereg(expdesc2.u.s.aux);
                this.freereg(expdesc2.u.s.info);
                expdesc2.u.s.info = this.codeABC(6, 0, expdesc2.u.s.info, expdesc2.u.s.aux);
                expdesc2.k = 11;
                break;
            }
            case 13: 
            case 14: {
                this.setoneret(expdesc2);
                break;
            }
        }
    }

    int code_label(int n, int n2, int n3) {
        this.getlabel();
        return this.codeABC(2, n, n2, n3);
    }

    void discharge2reg(LexState.expdesc expdesc2, int n) {
        this.dischargevars(expdesc2);
        switch (expdesc2.k) {
            case 1: {
                this.nil(n, 1);
                break;
            }
            case 2: 
            case 3: {
                this.codeABC(2, n, expdesc2.k == 2 ? 1 : 0, 0);
                break;
            }
            case 4: {
                this.codeABx(1, n, expdesc2.u.s.info);
                break;
            }
            case 5: {
                this.codeABx(1, n, this.numberK(expdesc2.u.nval()));
                break;
            }
            case 11: {
                InstructionPtr instructionPtr = this.getcodePtr(expdesc2);
                FuncState.SETARG_A(instructionPtr, n);
                break;
            }
            case 12: {
                if (n == expdesc2.u.s.info) break;
                this.codeABC(0, n, expdesc2.u.s.info, 0);
                break;
            }
            default: {
                FuncState._assert(expdesc2.k == 0 || expdesc2.k == 10);
                return;
            }
        }
        expdesc2.u.s.info = n;
        expdesc2.k = 12;
    }

    void discharge2anyreg(LexState.expdesc expdesc2) {
        if (expdesc2.k != 12) {
            this.reserveregs(1);
            this.discharge2reg(expdesc2, this.freereg - 1);
        }
    }

    void exp2reg(LexState.expdesc expdesc2, int n) {
        this.discharge2reg(expdesc2, n);
        if (expdesc2.k == 10) {
            this.concat(expdesc2.t, expdesc2.u.s.info);
        }
        if (expdesc2.hasjumps()) {
            int n2 = -1;
            int n3 = -1;
            if (this.need_value(expdesc2.t.i) || this.need_value(expdesc2.f.i)) {
                int n4 = expdesc2.k == 10 ? -1 : this.jump();
                n2 = this.code_label(n, 0, 1);
                n3 = this.code_label(n, 1, 0);
                this.patchtohere(n4);
            }
            int n5 = this.getlabel();
            this.patchlistaux(expdesc2.f.i, n5, n, n2);
            this.patchlistaux(expdesc2.t.i, n5, n, n3);
        }
        expdesc2.t.i = -1;
        expdesc2.f.i = -1;
        expdesc2.u.s.info = n;
        expdesc2.k = 12;
    }

    void exp2nextreg(LexState.expdesc expdesc2) {
        this.dischargevars(expdesc2);
        this.freeexp(expdesc2);
        this.reserveregs(1);
        this.exp2reg(expdesc2, this.freereg - 1);
    }

    int exp2anyreg(LexState.expdesc expdesc2) {
        this.dischargevars(expdesc2);
        if (expdesc2.k == 12) {
            if (!expdesc2.hasjumps()) {
                return expdesc2.u.s.info;
            }
            if (expdesc2.u.s.info >= this.nactvar) {
                this.exp2reg(expdesc2, expdesc2.u.s.info);
                return expdesc2.u.s.info;
            }
        }
        this.exp2nextreg(expdesc2);
        return expdesc2.u.s.info;
    }

    void exp2val(LexState.expdesc expdesc2) {
        if (expdesc2.hasjumps()) {
            this.exp2anyreg(expdesc2);
        } else {
            this.dischargevars(expdesc2);
        }
    }

    int exp2RK(LexState.expdesc expdesc2) {
        this.exp2val(expdesc2);
        switch (expdesc2.k) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                if (this.nk > 255) break;
                expdesc2.u.s.info = expdesc2.k == 1 ? this.nilK() : (expdesc2.k == 5 ? this.numberK(expdesc2.u.nval()) : this.boolK(expdesc2.k == 2));
                expdesc2.k = 4;
                return FuncState.RKASK(expdesc2.u.s.info);
            }
            case 4: {
                if (expdesc2.u.s.info > 255) break;
                return FuncState.RKASK(expdesc2.u.s.info);
            }
        }
        return this.exp2anyreg(expdesc2);
    }

    void storevar(LexState.expdesc expdesc2, LexState.expdesc expdesc3) {
        switch (expdesc2.k) {
            case 6: {
                this.freeexp(expdesc3);
                this.exp2reg(expdesc3, expdesc2.u.s.info);
                return;
            }
            case 7: {
                int n = this.exp2anyreg(expdesc3);
                this.codeABC(8, n, expdesc2.u.s.info, 0);
                break;
            }
            case 8: {
                int n = this.exp2anyreg(expdesc3);
                this.codeABx(7, n, expdesc2.u.s.info);
                break;
            }
            case 9: {
                int n = this.exp2RK(expdesc3);
                this.codeABC(9, expdesc2.u.s.info, expdesc2.u.s.aux, n);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
        this.freeexp(expdesc3);
    }

    void self(LexState.expdesc expdesc2, LexState.expdesc expdesc3) {
        this.exp2anyreg(expdesc2);
        this.freeexp(expdesc2);
        int n = this.freereg;
        this.reserveregs(2);
        this.codeABC(11, n, expdesc2.u.s.info, this.exp2RK(expdesc3));
        this.freeexp(expdesc3);
        expdesc2.u.s.info = n;
        expdesc2.k = 12;
    }

    void invertjump(LexState.expdesc expdesc2) {
        InstructionPtr instructionPtr = this.getjumpcontrol(expdesc2.u.s.info);
        FuncState._assert(FuncState.testTMode(FuncState.GET_OPCODE(instructionPtr.get())) && FuncState.GET_OPCODE(instructionPtr.get()) != 27 && Lua.GET_OPCODE(instructionPtr.get()) != 26);
        int n = FuncState.GETARG_A(instructionPtr.get());
        int n2 = n != 0 ? 0 : 1;
        FuncState.SETARG_A(instructionPtr, n2);
    }

    int jumponcond(LexState.expdesc expdesc2, int n) {
        int n2;
        if (expdesc2.k == 11 && FuncState.GET_OPCODE(n2 = this.getcode(expdesc2)) == 19) {
            --this.pc;
            return this.condjump(26, FuncState.GETARG_B(n2), 0, n != 0 ? 0 : 1);
        }
        this.discharge2anyreg(expdesc2);
        this.freeexp(expdesc2);
        return this.condjump(27, 255, expdesc2.u.s.info, n);
    }

    void goiftrue(LexState.expdesc expdesc2) {
        int n;
        this.dischargevars(expdesc2);
        switch (expdesc2.k) {
            case 2: 
            case 4: 
            case 5: {
                n = -1;
                break;
            }
            case 3: {
                n = this.jump();
                break;
            }
            case 10: {
                this.invertjump(expdesc2);
                n = expdesc2.u.s.info;
                break;
            }
            default: {
                n = this.jumponcond(expdesc2, 0);
            }
        }
        this.concat(expdesc2.f, n);
        this.patchtohere(expdesc2.t.i);
        expdesc2.t.i = -1;
    }

    void goiffalse(LexState.expdesc expdesc2) {
        int n;
        this.dischargevars(expdesc2);
        switch (expdesc2.k) {
            case 1: 
            case 3: {
                n = -1;
                break;
            }
            case 2: {
                n = this.jump();
                break;
            }
            case 10: {
                n = expdesc2.u.s.info;
                break;
            }
            default: {
                n = this.jumponcond(expdesc2, 1);
            }
        }
        this.concat(expdesc2.t, n);
        this.patchtohere(expdesc2.f.i);
        expdesc2.f.i = -1;
    }

    void codenot(LexState.expdesc expdesc2) {
        this.dischargevars(expdesc2);
        switch (expdesc2.k) {
            case 1: 
            case 3: {
                expdesc2.k = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                expdesc2.k = 3;
                break;
            }
            case 10: {
                this.invertjump(expdesc2);
                break;
            }
            case 11: 
            case 12: {
                this.discharge2anyreg(expdesc2);
                this.freeexp(expdesc2);
                expdesc2.u.s.info = this.codeABC(19, 0, expdesc2.u.s.info, 0);
                expdesc2.k = 11;
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
        int n = expdesc2.f.i;
        expdesc2.f.i = expdesc2.t.i;
        expdesc2.t.i = n;
        this.removevalues(expdesc2.f.i);
        this.removevalues(expdesc2.t.i);
    }

    void indexed(LexState.expdesc expdesc2, LexState.expdesc expdesc3) {
        expdesc2.u.s.aux = this.exp2RK(expdesc3);
        expdesc2.k = 9;
    }

    boolean constfolding(int n, LexState.expdesc expdesc2, LexState.expdesc expdesc3) {
        LuaValue luaValue;
        if (!expdesc2.isnumeral() || !expdesc3.isnumeral()) {
            return false;
        }
        LuaValue luaValue2 = expdesc2.u.nval();
        LuaValue luaValue3 = expdesc3.u.nval();
        switch (n) {
            case 12: {
                luaValue = luaValue2.add(luaValue3);
                break;
            }
            case 13: {
                luaValue = luaValue2.sub(luaValue3);
                break;
            }
            case 14: {
                luaValue = luaValue2.mul(luaValue3);
                break;
            }
            case 15: {
                luaValue = luaValue2.div(luaValue3);
                break;
            }
            case 16: {
                luaValue = luaValue2.mod(luaValue3);
                break;
            }
            case 17: {
                luaValue = luaValue2.pow(luaValue3);
                break;
            }
            case 18: {
                luaValue = luaValue2.neg();
                break;
            }
            case 20: {
                return false;
            }
            default: {
                FuncState._assert(false);
                luaValue = null;
            }
        }
        if (Double.isNaN(luaValue.todouble())) {
            return false;
        }
        expdesc2.u.setNval(luaValue);
        return true;
    }

    void codearith(int n, LexState.expdesc expdesc2, LexState.expdesc expdesc3) {
        if (this.constfolding(n, expdesc2, expdesc3)) {
            return;
        }
        int n2 = n != 18 && n != 20 ? this.exp2RK(expdesc3) : 0;
        int n3 = this.exp2RK(expdesc2);
        if (n3 > n2) {
            this.freeexp(expdesc2);
            this.freeexp(expdesc3);
        } else {
            this.freeexp(expdesc3);
            this.freeexp(expdesc2);
        }
        expdesc2.u.s.info = this.codeABC(n, 0, n3, n2);
        expdesc2.k = 11;
    }

    void codecomp(int n, int n2, LexState.expdesc expdesc2, LexState.expdesc expdesc3) {
        int n3 = this.exp2RK(expdesc2);
        int n4 = this.exp2RK(expdesc3);
        this.freeexp(expdesc3);
        this.freeexp(expdesc2);
        if (n2 == 0 && n != 23) {
            int n5 = n3;
            n3 = n4;
            n4 = n5;
            n2 = 1;
        }
        expdesc2.u.s.info = this.condjump(n, n2, n3, n4);
        expdesc2.k = 10;
    }

    void prefix(int n, LexState.expdesc expdesc2) {
        LexState.expdesc expdesc3 = new LexState.expdesc();
        expdesc3.init(5, 0);
        switch (n) {
            case 0: {
                if (expdesc2.k == 4) {
                    this.exp2anyreg(expdesc2);
                }
                this.codearith(18, expdesc2, expdesc3);
                break;
            }
            case 1: {
                this.codenot(expdesc2);
                break;
            }
            case 2: {
                this.exp2anyreg(expdesc2);
                this.codearith(20, expdesc2, expdesc3);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
    }

    void infix(int n, LexState.expdesc expdesc2) {
        switch (n) {
            case 13: {
                this.goiftrue(expdesc2);
                break;
            }
            case 14: {
                this.goiffalse(expdesc2);
                break;
            }
            case 6: {
                this.exp2nextreg(expdesc2);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (expdesc2.isnumeral()) break;
                this.exp2RK(expdesc2);
                break;
            }
            default: {
                this.exp2RK(expdesc2);
            }
        }
    }

    void posfix(int n, LexState.expdesc expdesc2, LexState.expdesc expdesc3) {
        switch (n) {
            case 13: {
                FuncState._assert(expdesc2.t.i == -1);
                this.dischargevars(expdesc3);
                this.concat(expdesc3.f, expdesc2.f.i);
                expdesc2.setvalue(expdesc3);
                break;
            }
            case 14: {
                FuncState._assert(expdesc2.f.i == -1);
                this.dischargevars(expdesc3);
                this.concat(expdesc3.t, expdesc2.t.i);
                expdesc2.setvalue(expdesc3);
                break;
            }
            case 6: {
                this.exp2val(expdesc3);
                if (expdesc3.k == 11 && FuncState.GET_OPCODE(this.getcode(expdesc3)) == 21) {
                    FuncState._assert(expdesc2.u.s.info == FuncState.GETARG_B(this.getcode(expdesc3)) - 1);
                    this.freeexp(expdesc2);
                    FuncState.SETARG_B(this.getcodePtr(expdesc3), expdesc2.u.s.info);
                    expdesc2.k = 11;
                    expdesc2.u.s.info = expdesc3.u.s.info;
                    break;
                }
                this.exp2nextreg(expdesc3);
                this.codearith(21, expdesc2, expdesc3);
                break;
            }
            case 0: {
                this.codearith(12, expdesc2, expdesc3);
                break;
            }
            case 1: {
                this.codearith(13, expdesc2, expdesc3);
                break;
            }
            case 2: {
                this.codearith(14, expdesc2, expdesc3);
                break;
            }
            case 3: {
                this.codearith(15, expdesc2, expdesc3);
                break;
            }
            case 4: {
                this.codearith(16, expdesc2, expdesc3);
                break;
            }
            case 5: {
                this.codearith(17, expdesc2, expdesc3);
                break;
            }
            case 8: {
                this.codecomp(23, 1, expdesc2, expdesc3);
                break;
            }
            case 7: {
                this.codecomp(23, 0, expdesc2, expdesc3);
                break;
            }
            case 9: {
                this.codecomp(24, 1, expdesc2, expdesc3);
                break;
            }
            case 10: {
                this.codecomp(25, 1, expdesc2, expdesc3);
                break;
            }
            case 11: {
                this.codecomp(24, 0, expdesc2, expdesc3);
                break;
            }
            case 12: {
                this.codecomp(25, 0, expdesc2, expdesc3);
                break;
            }
            default: {
                FuncState._assert(false);
            }
        }
    }

    void fixline(int n) {
        this.f.lineinfo[this.pc - 1] = n;
    }

    int code(int n, int n2) {
        Prototype prototype = this.f;
        this.dischargejpc();
        if (prototype.code == null || this.pc + 1 > prototype.code.length) {
            prototype.code = LuaC.realloc(prototype.code, this.pc * 2 + 1);
        }
        prototype.code[this.pc] = n;
        if (prototype.lineinfo == null || this.pc + 1 > prototype.lineinfo.length) {
            prototype.lineinfo = LuaC.realloc(prototype.lineinfo, this.pc * 2 + 1);
        }
        prototype.lineinfo[this.pc] = n2;
        return this.pc++;
    }

    int codeABC(int n, int n2, int n3, int n4) {
        FuncState._assert(FuncState.getOpMode(n) == 0);
        FuncState._assert(FuncState.getBMode(n) != 0 || n3 == 0);
        FuncState._assert(FuncState.getCMode(n) != 0 || n4 == 0);
        return this.code(FuncState.CREATE_ABC(n, n2, n3, n4), this.ls.lastline);
    }

    int codeABx(int n, int n2, int n3) {
        FuncState._assert(FuncState.getOpMode(n) == 1 || FuncState.getOpMode(n) == 2);
        FuncState._assert(FuncState.getCMode(n) == 0);
        return this.code(FuncState.CREATE_ABx(n, n2, n3), this.ls.lastline);
    }

    void setlist(int n, int n2, int n3) {
        int n4 = (n2 - 1) / 50 + 1;
        int n5 = n3 == -1 ? 0 : n3;
        FuncState._assert(n3 != 0);
        if (n4 <= 511) {
            this.codeABC(34, n, n5, n4);
        } else {
            this.codeABC(34, n, n5, 0);
            this.code(n4, this.ls.lastline);
        }
        this.freereg = n + 1;
    }

    static class BlockCnt {
        BlockCnt previous;
        IntPtr breaklist = new IntPtr();
        short nactvar;
        boolean upval;
        boolean isbreakable;

        BlockCnt() {
        }
    }

    class upvaldesc {
        short k;
        short info;

        upvaldesc() {
        }
    }
}

