/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ResourceFinder;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class BaseLib
extends OneArgFunction
implements ResourceFinder {
    public static BaseLib instance;
    public InputStream STDIN = null;
    public PrintStream STDOUT = System.out;
    public PrintStream STDERR = System.err;
    public static ResourceFinder FINDER;
    private LuaValue next;
    private LuaValue inext;
    private static final String[] LIB2_KEYS;
    private static final String[] LIBV_KEYS;
    static /* synthetic */ Class class$org$luaj$vm2$lib$BaseLib$BaseLib2;
    static /* synthetic */ Class class$org$luaj$vm2$lib$BaseLib$BaseLibV;

    public BaseLib() {
        instance = this;
    }

    public LuaValue call(LuaValue luaValue) {
        this.env.set("_G", this.env);
        this.env.set("_VERSION", "Luaj-jse 2.0.2");
        this.bind(this.env, class$org$luaj$vm2$lib$BaseLib$BaseLib2 == null ? (class$org$luaj$vm2$lib$BaseLib$BaseLib2 = BaseLib.class$("org.luaj.vm2.lib.BaseLib$BaseLib2")) : class$org$luaj$vm2$lib$BaseLib$BaseLib2, LIB2_KEYS);
        this.bind(this.env, class$org$luaj$vm2$lib$BaseLib$BaseLibV == null ? (class$org$luaj$vm2$lib$BaseLib$BaseLibV = BaseLib.class$("org.luaj.vm2.lib.BaseLib$BaseLibV")) : class$org$luaj$vm2$lib$BaseLib$BaseLibV, LIBV_KEYS);
        this.next = this.env.get("next");
        this.inext = this.env.get("__inext");
        for (int i = 0; i < LIBV_KEYS.length; ++i) {
            ((BaseLibV)this.env.get((String)BaseLib.LIBV_KEYS[i])).baselib = this;
        }
        if (FINDER == null) {
            FINDER = this;
        }
        return this.env;
    }

    public InputStream findResource(String string) {
        Class<?> clazz = this.getClass();
        return clazz.getResourceAsStream(string.startsWith("/") ? string : "/" + string);
    }

    private static LuaValue getfenvobj(LuaValue luaValue) {
        if (luaValue.isfunction()) {
            return luaValue;
        }
        int n = luaValue.optint(1);
        luaValue.argcheck(n >= 0, 1, "level must be non-negative");
        if (n == 0) {
            return LuaThread.getRunning();
        }
        LuaFunction luaFunction = LuaThread.getCallstackFunction(n);
        luaValue.argcheck(luaFunction != null, 1, "invalid level");
        return luaFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Varargs pcall(LuaValue luaValue, Varargs varargs, LuaValue luaValue2) {
        LuaThread luaThread = LuaThread.getRunning();
        Object object = luaThread.err;
        try {
            luaThread.err = luaValue2;
            Varargs varargs2 = BaseLib.varargsOf(LuaValue.TRUE, luaValue.invoke(varargs));
            luaThread.err = object;
            return varargs2;
        }
        catch (Throwable throwable) {
            try {
                luaThread.err = object;
                throw throwable;
            }
            catch (LuaError luaError) {
                object = luaError.getMessage();
                return BaseLib.varargsOf(FALSE, (Varargs)(object != null ? BaseLib.valueOf((String)object) : NIL));
            }
            catch (Exception exception) {
                object = exception.getMessage();
                return BaseLib.varargsOf(FALSE, (Varargs)BaseLib.valueOf((String)(object != null ? object : exception.toString())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Varargs loadFile(String string) {
        InputStream inputStream = FINDER.findResource(string);
        if (inputStream == null) {
            return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf("cannot open " + string + ": No such file or directory"));
        }
        try {
            Varargs varargs = BaseLib.loadStream(inputStream, "@" + string);
            return varargs;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static Varargs loadStream(InputStream inputStream, String string) {
        try {
            if (inputStream == null) {
                return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf("not found: " + string));
            }
            return LoadState.load(inputStream, string, LuaThread.getGlobals());
        }
        catch (Exception exception) {
            return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf(exception.getMessage()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LIB2_KEYS = new String[]{"collectgarbage", "error", "setfenv"};
        LIBV_KEYS = new String[]{"assert", "dofile", "getfenv", "getmetatable", "load", "loadfile", "loadstring", "pcall", "xpcall", "print", "select", "unpack", "type", "rawequal", "rawget", "rawset", "setmetatable", "tostring", "tonumber", "pairs", "ipairs", "next", "__inext"};
    }

    private static class StringInputStream
    extends InputStream {
        LuaValue func;
        byte[] bytes;
        int offset;

        StringInputStream(LuaValue luaValue) {
            this.func = luaValue;
        }

        public int read() throws IOException {
            if (this.func == null) {
                return -1;
            }
            if (this.bytes == null) {
                LuaValue luaValue = this.func.call();
                if (luaValue.isnil()) {
                    this.func = null;
                    this.bytes = null;
                    return -1;
                }
                this.bytes = luaValue.tojstring().getBytes();
                this.offset = 0;
            }
            if (this.offset >= this.bytes.length) {
                return -1;
            }
            return this.bytes[this.offset++];
        }
    }

    static final class BaseLibV
    extends VarArgFunction {
        public BaseLib baselib;

        BaseLibV() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Varargs invoke(Varargs varargs) {
            switch (this.opcode) {
                case 0: {
                    if (!varargs.arg1().toboolean()) {
                        BaseLibV.error(varargs.narg() > 1 ? varargs.optjstring(2, "assertion failed!") : "assertion failed!");
                    }
                    return varargs;
                }
                case 1: {
                    Varargs varargs2 = varargs.isnil(1) ? BaseLib.loadStream(this.baselib.STDIN, "=stdin") : BaseLib.loadFile(varargs.checkjstring(1));
                    return varargs2.isnil(1) ? BaseLibV.error(varargs2.tojstring(2)) : varargs2.arg1().invoke();
                }
                case 2: {
                    LuaValue luaValue = BaseLib.getfenvobj(varargs.arg1());
                    LuaValue luaValue2 = luaValue.getfenv();
                    return luaValue2 != null ? luaValue2 : NIL;
                }
                case 3: {
                    LuaValue luaValue = varargs.checkvalue(1).getmetatable();
                    return luaValue != null ? luaValue.rawget(METATABLE).optvalue(luaValue) : NIL;
                }
                case 4: {
                    LuaValue luaValue = varargs.checkfunction(1);
                    String string = varargs.optjstring(2, "function");
                    return BaseLib.loadStream(new StringInputStream(luaValue), string);
                }
                case 5: {
                    return varargs.isnil(1) ? BaseLib.loadStream(this.baselib.STDIN, "stdin") : BaseLib.loadFile(varargs.checkjstring(1));
                }
                case 6: {
                    LuaString luaString = varargs.checkstring(1);
                    String string = varargs.optjstring(2, "string");
                    return BaseLib.loadStream(luaString.toInputStream(), string);
                }
                case 7: {
                    LuaValue luaValue = varargs.checkvalue(1);
                    LuaThread.onCall(this);
                    try {
                        Varargs varargs3 = BaseLib.pcall(luaValue, varargs.subargs(2), null);
                        return varargs3;
                    }
                    finally {
                        LuaThread.onReturn();
                    }
                }
                case 8: {
                    LuaThread.onCall(this);
                    try {
                        Varargs varargs4 = BaseLib.pcall(varargs.arg1(), NONE, varargs.checkvalue(2));
                        return varargs4;
                    }
                    finally {
                        LuaThread.onReturn();
                    }
                }
                case 9: {
                    LuaValue luaValue = LuaThread.getGlobals().get("tostring");
                    int n = varargs.narg();
                    for (int i = 1; i <= n; ++i) {
                        if (i > 1) {
                            this.baselib.STDOUT.write(9);
                        }
                        LuaString luaString = luaValue.call(varargs.arg(i)).strvalue();
                        int n2 = luaString.indexOf((byte)0, 0);
                        this.baselib.STDOUT.write(luaString.m_bytes, luaString.m_offset, n2 >= 0 ? n2 : luaString.m_length);
                    }
                    this.baselib.STDOUT.println();
                    return NONE;
                }
                case 10: {
                    int n = varargs.narg() - 1;
                    if (varargs.arg1().equals(BaseLibV.valueOf("#"))) {
                        return BaseLibV.valueOf(n);
                    }
                    int n3 = varargs.checkint(1);
                    if (n3 == 0 || n3 < -n) {
                        BaseLibV.argerror(1, "index out of range");
                    }
                    return varargs.subargs(n3 < 0 ? n + n3 + 2 : n3 + 1);
                }
                case 11: {
                    int n = varargs.narg();
                    LuaTable luaTable = varargs.checktable(1);
                    int n4 = luaTable.length();
                    int n5 = n >= 2 ? varargs.checkint(2) : 1;
                    int n6 = n >= 3 ? varargs.checkint(3) : n4;
                    n4 = n6 - n5 + 1;
                    if (n4 < 0) {
                        return NONE;
                    }
                    if (n4 == 1) {
                        return luaTable.get(n5);
                    }
                    if (n4 == 2) {
                        return BaseLibV.varargsOf(luaTable.get(n5), (Varargs)luaTable.get(n6));
                    }
                    LuaValue[] luaValueArray = new LuaValue[n4];
                    for (int i = 0; i < n4; ++i) {
                        luaValueArray[i] = luaTable.get(n5 + i);
                    }
                    return BaseLibV.varargsOf(luaValueArray);
                }
                case 12: {
                    return BaseLibV.valueOf(varargs.checkvalue(1).typename());
                }
                case 13: {
                    return BaseLibV.valueOf(varargs.checkvalue(1) == varargs.checkvalue(2));
                }
                case 14: {
                    return varargs.checktable(1).rawget(varargs.checkvalue(2));
                }
                case 15: {
                    LuaTable luaTable = varargs.checktable(1);
                    luaTable.rawset(varargs.checknotnil(2), varargs.checkvalue(3));
                    return luaTable;
                }
                case 16: {
                    LuaValue luaValue;
                    LuaValue luaValue3 = varargs.arg1();
                    LuaValue luaValue4 = luaValue3.getmetatable();
                    if (luaValue4 != null && !luaValue4.rawget(METATABLE).isnil()) {
                        BaseLibV.error("cannot change a protected metatable");
                    }
                    return luaValue3.setmetatable((luaValue = varargs.checkvalue(2)).isnil() ? null : luaValue.checktable());
                }
                case 17: {
                    LuaValue luaValue = varargs.checkvalue(1);
                    LuaValue luaValue5 = luaValue.metatag(TOSTRING);
                    if (!luaValue5.isnil()) {
                        return luaValue5.call(luaValue);
                    }
                    LuaValue luaValue6 = luaValue.tostring();
                    if (!luaValue6.isnil()) {
                        return luaValue6;
                    }
                    return BaseLibV.valueOf(luaValue.tojstring());
                }
                case 18: {
                    LuaValue luaValue = varargs.checkvalue(1);
                    int n = varargs.optint(2, 10);
                    if (n == 10) {
                        return luaValue.tonumber();
                    }
                    if (n < 2 || n > 36) {
                        BaseLibV.argerror(2, "base out of range");
                    }
                    return luaValue.checkstring().tonumber(n);
                }
                case 19: {
                    return BaseLibV.varargsOf(this.baselib.next, varargs.checktable(1), NIL);
                }
                case 20: {
                    return BaseLibV.varargsOf(this.baselib.inext, varargs.checktable(1), ZERO);
                }
                case 21: {
                    return varargs.checktable(1).next(varargs.arg(2));
                }
                case 22: {
                    return varargs.checktable(1).inext(varargs.arg(2));
                }
            }
            return NONE;
        }
    }

    static final class BaseLib2
    extends TwoArgFunction {
        BaseLib2() {
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            switch (this.opcode) {
                case 0: {
                    String string = luaValue.checkjstring();
                    boolean bl = false;
                    if ("collect".equals(string)) {
                        System.gc();
                        return ZERO;
                    }
                    if ("count".equals(string)) {
                        Runtime runtime = Runtime.getRuntime();
                        long l = runtime.totalMemory() - runtime.freeMemory();
                        return BaseLib2.valueOf((double)l / 1024.0);
                    }
                    if ("step".equals(string)) {
                        System.gc();
                        return LuaValue.TRUE;
                    }
                    BaseLib2.argerror(1, "gc op");
                    return NIL;
                }
                case 1: {
                    throw new LuaError(luaValue.isnil() ? null : luaValue.tojstring(), luaValue2.optint(1));
                }
                case 2: {
                    LuaTable luaTable = luaValue2.checktable();
                    LuaValue luaValue3 = BaseLib.getfenvobj(luaValue);
                    if (!luaValue3.isfunction() && !luaValue3.isclosure()) {
                        BaseLib2.error("'setfenv' cannot change environment of given object");
                    }
                    luaValue3.setfenv(luaTable);
                    return luaValue3.isthread() ? NONE : luaValue3;
                }
            }
            return NIL;
        }
    }
}

