/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lua2java;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.ast.Chunk;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.lua2java.JavaCodeGen;
import org.luaj.vm2.parser.LuaParser;

public class Lua2Java
implements LoadState.LuaCompiler {
    public static final Lua2Java instance = new Lua2Java();

    public static final void install() {
        LoadState.compiler = instance;
    }

    private Lua2Java() {
    }

    public LuaFunction load(InputStream inputStream, String string, LuaValue luaValue) throws IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(1);
        int n = inputStream.read();
        inputStream.reset();
        if (n != 27) {
            String string2;
            int n2;
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            if (javaCompiler == null) {
                LuaValue.error("no java compiler");
            }
            if (string.endsWith(".lua")) {
                string = string.substring(0, string.length() - 4);
            }
            String string3 = (n2 = (string2 = string.replace('\\', '/').replace('/', '.').replaceAll("[^\\w]", "_")).lastIndexOf(46)) >= 0 ? string2.substring(0, n2) : null;
            final String string4 = Lua2Java.toClassname(string2.substring(n2 + 1));
            String string5 = string3 != null ? string3.replace('.', '/') : "";
            String string6 = "lua2java/src/" + string5;
            final String string7 = "lua2java/classes/" + string5;
            String string8 = string6 + "/" + string4 + ".java";
            new File(string6).mkdirs();
            new File(string7).mkdirs();
            try {
                LuaParser luaParser = new LuaParser(inputStream, "ISO8859-1");
                Chunk chunk = luaParser.Chunk();
                File file = new File(string8);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
                new JavaCodeGen(chunk, outputStreamWriter, string3, string4);
                ((Writer)outputStreamWriter).close();
                StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
                standardJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, Arrays.asList(new File("lua2java/classes")));
                JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, standardJavaFileManager, null, null, null, standardJavaFileManager.getJavaFileObjects(file));
                boolean bl = compilationTask.call();
                if (bl) {
                    ClassLoader classLoader = new ClassLoader(){

                        public Class findClass(String string) throws ClassNotFoundException {
                            if (string.startsWith(string4)) {
                                File file = new File(string7 + "/" + string + ".class");
                                long l = file.length();
                                byte[] byArray = new byte[(int)l];
                                try {
                                    DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                                    dataInputStream.readFully(byArray);
                                }
                                catch (Exception exception) {
                                    throw new RuntimeException("failed to read class bytes: " + exception);
                                }
                                return this.defineClass(string, byArray, 0, byArray.length);
                            }
                            return super.findClass(string);
                        }
                    };
                    Class<?> clazz = classLoader.loadClass(string4);
                    Object obj = clazz.newInstance();
                    LuaFunction luaFunction = (LuaFunction)obj;
                    luaFunction.setfenv(luaValue);
                    return luaFunction;
                }
            }
            catch (Exception exception) {
                LuaValue.error("compile task failed: " + exception);
            }
            LuaValue.error("compile task failed:");
            return null;
        }
        return LuaC.instance.load(inputStream, string, luaValue);
    }

    public static final String toClassname(String string) {
        int n;
        int n2 = n = string.length();
        if (string.endsWith(".lua")) {
            n2 -= 4;
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = string.charAt(i);
            if (Lua2Java.isClassnamePart((char)n3) && n3 != 47 && n3 != 92) continue;
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int j = 0; j < n2; ++j) {
                n3 = string.charAt(j);
                stringBuffer.append((char)(Lua2Java.isClassnamePart((char)n3) ? n3 : (n3 == 47 || n3 == 92 ? 46 : 95)));
            }
            return stringBuffer.toString();
        }
        return n == n2 ? string : string.substring(0, n2);
    }

    private static final boolean isClassnamePart(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case '$': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return false;
    }
}

