/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.luaj.vm2.Lua;
import org.luaj.vm2.Print;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.luajc.BasicBlock;
import org.luaj.vm2.luajc.UpvalInfo;
import org.luaj.vm2.luajc.VarInfo;

public class ProtoInfo {
    public final String name;
    public final Prototype prototype;
    public final ProtoInfo[] subprotos;
    public final BasicBlock[] blocks;
    public final BasicBlock[] blocklist;
    public final VarInfo[] params;
    public final VarInfo[][] vars;
    public final UpvalInfo[] upvals;
    public final UpvalInfo[][] openups;

    public ProtoInfo(Prototype prototype, String string) {
        this(prototype, string, null);
    }

    private ProtoInfo(Prototype prototype, String string, UpvalInfo[] upvalInfoArray) {
        this.name = string;
        this.prototype = prototype;
        this.upvals = upvalInfoArray;
        this.subprotos = prototype.p != null && prototype.p.length > 0 ? new ProtoInfo[prototype.p.length] : null;
        this.blocks = BasicBlock.findBasicBlocks(prototype);
        this.blocklist = BasicBlock.findLiveBlocks(this.blocks);
        this.params = new VarInfo[prototype.maxstacksize];
        for (int i = 0; i < prototype.maxstacksize; ++i) {
            VarInfo varInfo;
            this.params[i] = varInfo = VarInfo.PARAM(i);
        }
        this.vars = this.findVariables();
        this.replaceTrivialPhiVariables();
        this.openups = new UpvalInfo[prototype.maxstacksize][];
        this.findUpvalues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("proto '" + this.name + "'\n");
        int n3 = n2 = this.upvals != null ? this.upvals.length : 0;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(" up[" + n + "]: " + this.upvals[n] + "\n");
        }
        for (n = 0; n < this.blocklist.length; ++n) {
            BasicBlock basicBlock = this.blocklist[n];
            int n4 = basicBlock.pc0;
            stringBuffer.append("  block " + basicBlock.toString());
            this.appendOpenUps(stringBuffer, -1);
            for (int i = n4; i <= basicBlock.pc1; ++i) {
                Object object;
                this.appendOpenUps(stringBuffer, i);
                stringBuffer.append("     ");
                for (int j = 0; j < this.prototype.maxstacksize; ++j) {
                    object = this.vars[j][i];
                    String string = object == null ? "" : (((VarInfo)object).upvalue != null ? (!((VarInfo)object).upvalue.rw ? "[C] " : (((VarInfo)object).allocupvalue && ((VarInfo)object).pc == i ? "[*] " : "[]  ")) : "    ");
                    String string2 = object == null ? "null   " : String.valueOf(object);
                    stringBuffer.append(string2 + string);
                }
                stringBuffer.append("  ");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                object = Print.ps;
                Print.ps = new PrintStream(byteArrayOutputStream);
                try {
                    Print.printOpCode(this.prototype, i);
                }
                finally {
                    Print.ps.close();
                    Print.ps = object;
                }
                stringBuffer.append(byteArrayOutputStream.toString());
                stringBuffer.append("\n");
            }
        }
        int n5 = n2 = this.subprotos != null ? this.subprotos.length : 0;
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(this.subprotos[n].toString());
        }
        return stringBuffer.toString();
    }

    private void appendOpenUps(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < this.prototype.maxstacksize; ++i) {
            VarInfo varInfo;
            VarInfo varInfo2 = varInfo = n < 0 ? this.params[i] : this.vars[i][n];
            if (varInfo == null || varInfo.pc != n || !varInfo.allocupvalue) continue;
            stringBuffer.append("    open: " + varInfo.upvalue + "\n");
        }
    }

    private VarInfo[][] findVariables() {
        int n;
        int n2 = this.prototype.code.length;
        int n3 = this.prototype.maxstacksize;
        VarInfo[][] varInfoArray = new VarInfo[n3][];
        for (n = 0; n < varInfoArray.length; ++n) {
            varInfoArray[n] = new VarInfo[n2];
        }
        for (n = 0; n < this.blocklist.length; ++n) {
            int n4;
            int n5;
            BasicBlock basicBlock = this.blocklist[n];
            int n6 = basicBlock.prev != null ? basicBlock.prev.length : 0;
            for (n5 = 0; n5 < n3; ++n5) {
                VarInfo varInfo = null;
                if (n6 == 0) {
                    varInfo = this.params[n5];
                } else if (n6 == 1) {
                    varInfo = varInfoArray[n5][basicBlock.prev[0].pc1];
                } else {
                    for (n4 = 0; n4 < n6; ++n4) {
                        BasicBlock basicBlock2 = basicBlock.prev[n4];
                        if (varInfoArray[n5][basicBlock2.pc1] != VarInfo.INVALID) continue;
                        varInfo = VarInfo.INVALID;
                    }
                }
                if (varInfo == null) {
                    varInfo = VarInfo.PHI(this, n5, basicBlock.pc0);
                }
                varInfoArray[n5][basicBlock.pc0] = varInfo;
            }
            block27: for (n5 = basicBlock.pc0; n5 <= basicBlock.pc1; ++n5) {
                if (n5 > basicBlock.pc0) {
                    ProtoInfo.propogateVars(varInfoArray, n5 - 1, n5);
                }
                int n7 = this.prototype.code[n5];
                int n8 = Lua.GET_OPCODE(n7);
                switch (n8) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 10: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block27;
                    }
                    case 0: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 27: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        varInfoArray[n4][n5].isreferenced = true;
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block27;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        if (!Lua.ISK(n4)) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        if (!Lua.ISK(n10)) {
                            varInfoArray[n10][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block27;
                    }
                    case 9: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        if (!Lua.ISK(n4)) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        if (Lua.ISK(n10)) continue block27;
                        varInfoArray[n10][n5].isreferenced = true;
                        continue block27;
                    }
                    case 21: {
                        int n9 = Lua.GETARG_A(n7);
                        int n10 = Lua.GETARG_C(n7);
                        for (n4 = Lua.GETARG_B(n7); n4 <= n10; ++n4) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block27;
                    }
                    case 32: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9 + 2][n5].isreferenced = true;
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block27;
                    }
                    case 6: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n4][n5].isreferenced = true;
                        if (!Lua.ISK(n10)) {
                            varInfoArray[n10][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        continue block27;
                    }
                    case 11: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n4][n5].isreferenced = true;
                        if (!Lua.ISK(n10)) {
                            varInfoArray[n10][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        varInfoArray[n9 + 1][n5] = new VarInfo(n9 + 1, n5);
                        continue block27;
                    }
                    case 31: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        varInfoArray[n9 + 2][n5].isreferenced = true;
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        varInfoArray[n9][n5].isreferenced = true;
                        varInfoArray[n9 + 1][n5].isreferenced = true;
                        varInfoArray[n9 + 3][n5] = new VarInfo(n9 + 3, n5);
                        continue block27;
                    }
                    case 3: {
                        int n9;
                        n4 = Lua.GETARG_B(n7);
                        for (n9 = Lua.GETARG_A(n7); n9 <= n4; ++n9) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        }
                        continue block27;
                    }
                    case 37: {
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n11 = 1;
                        while (n11 < n4) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                            ++n11;
                            ++n9;
                        }
                        if (n4 != 0) continue block27;
                        while (n9 < n3) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                            ++n9;
                        }
                        continue block27;
                    }
                    case 28: {
                        int n11;
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        varInfoArray[n9][n5].isreferenced = true;
                        for (n11 = 1; n11 <= n4 - 1; ++n11) {
                            varInfoArray[n9 + n11][n5].isreferenced = true;
                        }
                        n11 = 0;
                        while (n11 <= n10 - 2) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                            ++n11;
                            ++n9;
                        }
                        while (n9 < n3) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                            ++n9;
                        }
                        continue block27;
                    }
                    case 29: {
                        int n11;
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        for (n11 = 1; n11 <= n4 - 1; ++n11) {
                            varInfoArray[n9 + n11][n5].isreferenced = true;
                        }
                        continue block27;
                    }
                    case 30: {
                        int n11;
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        for (n11 = 0; n11 <= n4 - 2; ++n11) {
                            varInfoArray[n9 + n11][n5].isreferenced = true;
                        }
                        continue block27;
                    }
                    case 33: {
                        int n9 = Lua.GETARG_A(n7);
                        int n10 = Lua.GETARG_C(n7);
                        varInfoArray[n9++][n5].isreferenced = true;
                        varInfoArray[n9++][n5].isreferenced = true;
                        varInfoArray[n9++][n5].isreferenced = true;
                        int n11 = 0;
                        while (n11 < n10) {
                            varInfoArray[n9][n5] = new VarInfo(n9, n5);
                            ++n11;
                            ++n9;
                        }
                        while (n9 < n3) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                            ++n9;
                        }
                        continue block27;
                    }
                    case 36: {
                        int n11;
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_Bx(n7);
                        int n12 = this.prototype.p[n4].nups;
                        for (n11 = 1; n11 <= n12; ++n11) {
                            int n13 = this.prototype.code[n5 + n11];
                            if ((n13 & 4) != 0) continue;
                            n4 = Lua.GETARG_B(n13);
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        varInfoArray[n9][n5] = new VarInfo(n9, n5);
                        for (n11 = 1; n11 <= n12; ++n11) {
                            ProtoInfo.propogateVars(varInfoArray, n5, n5 + n11);
                        }
                        n5 += n12;
                        continue block27;
                    }
                    case 35: {
                        int n9;
                        for (n9 = Lua.GETARG_A(n7); n9 < n3; ++n9) {
                            varInfoArray[n9][n5] = VarInfo.INVALID;
                        }
                        continue block27;
                    }
                    case 34: {
                        int n11;
                        int n9 = Lua.GETARG_A(n7);
                        n4 = Lua.GETARG_B(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        for (n11 = 1; n11 <= n4; ++n11) {
                            varInfoArray[n9 + n11][n5].isreferenced = true;
                        }
                        continue block27;
                    }
                    case 7: 
                    case 8: 
                    case 26: {
                        int n9 = Lua.GETARG_A(n7);
                        varInfoArray[n9][n5].isreferenced = true;
                        continue block27;
                    }
                    case 23: 
                    case 24: 
                    case 25: {
                        n4 = Lua.GETARG_B(n7);
                        int n10 = Lua.GETARG_C(n7);
                        if (!Lua.ISK(n4)) {
                            varInfoArray[n4][n5].isreferenced = true;
                        }
                        if (Lua.ISK(n10)) continue block27;
                        varInfoArray[n10][n5].isreferenced = true;
                        continue block27;
                    }
                    case 22: {
                        continue block27;
                    }
                    default: {
                        throw new IllegalStateException("unhandled opcode: " + n7);
                    }
                }
            }
        }
        return varInfoArray;
    }

    private static void propogateVars(VarInfo[][] varInfoArray, int n, int n2) {
        int n3 = varInfoArray.length;
        for (int i = 0; i < n3; ++i) {
            varInfoArray[i][n2] = varInfoArray[i][n];
        }
    }

    private void replaceTrivialPhiVariables() {
        for (int i = 0; i < this.blocklist.length; ++i) {
            BasicBlock basicBlock = this.blocklist[i];
            for (int j = 0; j < this.prototype.maxstacksize; ++j) {
                VarInfo varInfo = this.vars[j][basicBlock.pc0];
                VarInfo varInfo2 = varInfo.resolvePhiVariableValues();
                if (varInfo2 == null) continue;
                this.substituteVariable(j, varInfo, varInfo2);
            }
        }
    }

    private void substituteVariable(int n, VarInfo varInfo, VarInfo varInfo2) {
        int n2 = this.prototype.code.length;
        for (int i = 0; i < n2; ++i) {
            this.replaceAll(this.vars[n], this.vars[n].length, varInfo, varInfo2);
        }
    }

    private void replaceAll(VarInfo[] varInfoArray, int n, VarInfo varInfo, VarInfo varInfo2) {
        for (int i = 0; i < n; ++i) {
            if (varInfoArray[i] != varInfo) continue;
            varInfoArray[i] = varInfo2;
        }
    }

    private void findUpvalues() {
        int n;
        int[] nArray = this.prototype.code;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            if (Lua.GET_OPCODE(nArray[n]) != 36) continue;
            int n3 = Lua.GETARG_Bx(nArray[n]);
            Prototype prototype = this.prototype.p[n3];
            UpvalInfo[] upvalInfoArray = prototype.nups > 0 ? new UpvalInfo[prototype.nups] : null;
            String string = this.name + "$" + n3;
            for (int i = 0; i < prototype.nups; ++i) {
                int n4 = nArray[++n];
                int n5 = Lua.GETARG_B(n4);
                upvalInfoArray[i] = (n4 & 4) != 0 ? this.upvals[n5] : this.findOpenUp(n, n5);
            }
            this.subprotos[n3] = new ProtoInfo(prototype, string, upvalInfoArray);
        }
        for (n = 0; n < n2; ++n) {
            if (Lua.GET_OPCODE(nArray[n]) != 8) continue;
            this.upvals[Lua.GETARG_B((int)nArray[n])].rw = true;
        }
    }

    private UpvalInfo findOpenUp(int n, int n2) {
        if (this.openups[n2] == null) {
            this.openups[n2] = new UpvalInfo[this.prototype.code.length];
        }
        if (this.openups[n2][n] != null) {
            return this.openups[n2][n];
        }
        UpvalInfo upvalInfo = new UpvalInfo(this, n, n2);
        int n3 = this.prototype.code.length;
        for (int i = 0; i < n3; ++i) {
            if (this.vars[n2][i] == null || this.vars[n2][i].upvalue != upvalInfo) continue;
            this.openups[n2][i] = upvalInfo;
        }
        return upvalInfo;
    }

    public boolean isUpvalueAssign(int n, int n2) {
        VarInfo varInfo = n < 0 ? this.params[n2] : this.vars[n2][n];
        return varInfo != null && varInfo.upvalue != null && varInfo.upvalue.rw;
    }

    public boolean isUpvalueCreate(int n, int n2) {
        VarInfo varInfo = n < 0 ? this.params[n2] : this.vars[n2][n];
        return varInfo != null && varInfo.upvalue != null && varInfo.upvalue.rw && varInfo.allocupvalue && n == varInfo.pc;
    }

    public boolean isUpvalueRefer(int n, int n2) {
        if (n > 0 && this.vars[n2][n] != null && this.vars[n2][n].pc == n && this.vars[n2][n - 1] != null) {
            --n;
        }
        VarInfo varInfo = n < 0 ? this.params[n2] : this.vars[n2][n];
        return varInfo != null && varInfo.upvalue != null && varInfo.upvalue.rw;
    }

    public boolean isInitialValueUsed(int n) {
        VarInfo varInfo = this.params[n];
        return varInfo.isreferenced;
    }

    public boolean isReadWriteUpvalue(UpvalInfo upvalInfo) {
        return upvalInfo.rw;
    }
}

