/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import java.util.Date;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class OsLib
extends TwoArgFunction {
    public static String TMP_PREFIX = ".luaj";
    public static String TMP_SUFFIX = "tmp";
    private static final int CLOCK = 0;
    private static final int DATE = 1;
    private static final int DIFFTIME = 2;
    private static final int EXECUTE = 3;
    private static final int EXIT = 4;
    private static final int GETENV = 5;
    private static final int REMOVE = 6;
    private static final int RENAME = 7;
    private static final int SETLOCALE = 8;
    private static final int TIME = 9;
    private static final int TMPNAME = 10;
    private static final String[] NAMES = new String[]{"clock", "date", "difftime", "execute", "exit", "getenv", "remove", "rename", "setlocale", "time", "tmpname"};
    private static final long t0;
    private static long tmpnames;
    protected Globals globals;
    static /* synthetic */ Class class$org$luaj$vm2$lib$OsLib;

    public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
        this.globals = luaValue2.checkglobals();
        LuaTable luaTable = new LuaTable();
        for (int i = 0; i < NAMES.length; ++i) {
            luaTable.set(NAMES[i], (LuaValue)new OsLibFunc(i, NAMES[i]));
        }
        luaValue2.set("os", (LuaValue)luaTable);
        luaValue2.get("package").get("loaded").set("os", (LuaValue)luaTable);
        return luaTable;
    }

    protected double clock() {
        return (double)(System.currentTimeMillis() - t0) / 1000.0;
    }

    protected double difftime(double d, double d2) {
        return d - d2;
    }

    protected String date(String string, double d) {
        return new Date((long)(d * 1000.0)).toString();
    }

    protected Varargs execute(String string) {
        return OsLib.varargsOf(NIL, OsLib.valueOf("exit"), ONE);
    }

    protected void exit(int n) {
        System.exit(n);
    }

    protected String getenv(String string) {
        return System.getProperty(string);
    }

    protected void remove(String string) throws IOException {
        throw new IOException("not implemented");
    }

    protected void rename(String string, String string2) throws IOException {
        throw new IOException("not implemented");
    }

    protected String setlocale(String string, String string2) {
        return "C";
    }

    protected long time(LuaTable luaTable) {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String tmpname() {
        Class clazz = class$org$luaj$vm2$lib$OsLib == null ? (class$org$luaj$vm2$lib$OsLib = OsLib.class$("org.luaj.vm2.lib.OsLib")) : class$org$luaj$vm2$lib$OsLib;
        synchronized (clazz) {
            return TMP_PREFIX + tmpnames++ + TMP_SUFFIX;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        tmpnames = t0 = System.currentTimeMillis();
    }

    class OsLibFunc
    extends VarArgFunction {
        public OsLibFunc(int n, String string) {
            this.opcode = n;
            this.name = string;
        }

        public Varargs invoke(Varargs varargs) {
            try {
                switch (this.opcode) {
                    case 0: {
                        return OsLibFunc.valueOf(OsLib.this.clock());
                    }
                    case 1: {
                        String string = varargs.optjstring(1, null);
                        double d = varargs.optdouble(2, -1.0);
                        return OsLibFunc.valueOf(OsLib.this.date(string, d == -1.0 ? (double)System.currentTimeMillis() / 1000.0 : d));
                    }
                    case 2: {
                        return OsLibFunc.valueOf(OsLib.this.difftime(varargs.checkdouble(1), varargs.checkdouble(2)));
                    }
                    case 3: {
                        return OsLib.this.execute(varargs.optjstring(1, null));
                    }
                    case 4: {
                        OsLib.this.exit(varargs.optint(1, 0));
                        return NONE;
                    }
                    case 5: {
                        String string = OsLib.this.getenv(varargs.checkjstring(1));
                        return string != null ? OsLibFunc.valueOf(string) : NIL;
                    }
                    case 6: {
                        OsLib.this.remove(varargs.checkjstring(1));
                        return LuaValue.TRUE;
                    }
                    case 7: {
                        OsLib.this.rename(varargs.checkjstring(1), varargs.checkjstring(2));
                        return LuaValue.TRUE;
                    }
                    case 8: {
                        String string = OsLib.this.setlocale(varargs.optjstring(1, null), varargs.optjstring(2, "all"));
                        return string != null ? OsLibFunc.valueOf(string) : NIL;
                    }
                    case 9: {
                        return OsLibFunc.valueOf(OsLib.this.time(varargs.arg1().isnil() ? null : varargs.checktable(1)));
                    }
                    case 10: {
                        return OsLibFunc.valueOf(OsLib.this.tmpname());
                    }
                }
                return NONE;
            }
            catch (IOException iOException) {
                return OsLibFunc.varargsOf(NIL, (Varargs)OsLibFunc.valueOf(iOException.getMessage()));
            }
        }
    }
}

