/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.tomcat.util.descriptor.LocalResolver;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;

public class DigesterFactory {
    public static final Map<String, String> SERVLET_API_PUBLIC_IDS;
    public static final Map<String, String> SERVLET_API_SYSTEM_IDS;

    private static void addSelf(Map<String, String> ids, String id) {
        String systemId = DigesterFactory.idFor(id);
        ids.put(systemId, systemId);
    }

    private static void addSelfJSP(Map<String, String> ids, String id) {
        String systemId = DigesterFactory.idForJSP(id);
        ids.put(systemId, systemId);
    }

    private static String idFor(String url) {
        return ServletContext.class.getResource("resources/" + url).toExternalForm();
    }

    private static String idForJSP(String url) {
        URL resource = ServletContext.class.getResource("resources/" + url);
        if (resource == null) {
            resource = ServletContext.class.getResource("jsp/resources/" + url);
        }
        return resource.toExternalForm();
    }

    public static Digester newDigester(boolean xmlValidation, boolean xmlNamespaceAware, RuleSet rule, boolean blockExternal) {
        Digester digester = new Digester();
        digester.setNamespaceAware(xmlNamespaceAware);
        digester.setValidating(xmlValidation);
        digester.setUseContextClassLoader(true);
        LocalResolver resolver = new LocalResolver(SERVLET_API_PUBLIC_IDS, SERVLET_API_SYSTEM_IDS, blockExternal);
        digester.setEntityResolver(resolver);
        if (rule != null) {
            digester.addRuleSet(rule);
        }
        return digester;
    }

    static {
        HashMap<String, String> publicIds = new HashMap<String, String>();
        HashMap<String, String> systemIds = new HashMap<String, String>();
        publicIds.put("-//W3C//DTD XMLSCHEMA 200102//EN", DigesterFactory.idFor("XMLSchema.dtd"));
        publicIds.put("datatypes", DigesterFactory.idFor("datatypes.dtd"));
        systemIds.put("http://www.w3.org/2001/xml.xsd", DigesterFactory.idFor("xml.xsd"));
        publicIds.put("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", DigesterFactory.idFor("web-app_2_2.dtd"));
        publicIds.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", DigesterFactory.idForJSP("web-jsptaglibrary_1_1.dtd"));
        publicIds.put("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", DigesterFactory.idFor("web-app_2_3.dtd"));
        publicIds.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", DigesterFactory.idForJSP("web-jsptaglibrary_1_2.dtd"));
        systemIds.put("http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", DigesterFactory.idFor("j2ee_web_services_1_1.xsd"));
        systemIds.put("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", DigesterFactory.idFor("j2ee_web_services_client_1_1.xsd"));
        systemIds.put("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", DigesterFactory.idFor("web-app_2_4.xsd"));
        systemIds.put("http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd", DigesterFactory.idForJSP("web-jsptaglibrary_2_0.xsd"));
        DigesterFactory.addSelf(systemIds, "j2ee_1_4.xsd");
        DigesterFactory.addSelfJSP(systemIds, "jsp_2_0.xsd");
        systemIds.put("http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", DigesterFactory.idFor("web-app_2_5.xsd"));
        systemIds.put("http://java.sun.com/xml/ns/javaee/web-jsptaglibrary_2_1.xsd", DigesterFactory.idForJSP("web-jsptaglibrary_2_1.xsd"));
        DigesterFactory.addSelf(systemIds, "javaee_5.xsd");
        DigesterFactory.addSelfJSP(systemIds, "jsp_2_1.xsd");
        DigesterFactory.addSelf(systemIds, "javaee_web_services_1_2.xsd");
        DigesterFactory.addSelf(systemIds, "javaee_web_services_client_1_2.xsd");
        systemIds.put("http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", DigesterFactory.idFor("web-app_3_0.xsd"));
        systemIds.put("http://java.sun.com/xml/ns/javaee/web-fragment_3_0.xsd", DigesterFactory.idFor("web-fragment_3_0.xsd"));
        DigesterFactory.addSelf(systemIds, "web-common_3_0.xsd");
        DigesterFactory.addSelf(systemIds, "javaee_6.xsd");
        DigesterFactory.addSelfJSP(systemIds, "jsp_2_2.xsd");
        DigesterFactory.addSelf(systemIds, "javaee_web_services_1_3.xsd");
        DigesterFactory.addSelf(systemIds, "javaee_web_services_client_1_3.xsd");
        systemIds.put("http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd", DigesterFactory.idFor("web-app_3_1.xsd"));
        systemIds.put("http://xmlns.jcp.org/xml/ns/javaee/web-fragment_3_1.xsd", DigesterFactory.idFor("web-fragment_3_1.xsd"));
        DigesterFactory.addSelf(systemIds, "web-common_3_1.xsd");
        DigesterFactory.addSelf(systemIds, "javaee_7.xsd");
        DigesterFactory.addSelfJSP(systemIds, "jsp_2_3.xsd");
        DigesterFactory.addSelf(systemIds, "javaee_web_services_1_4.xsd");
        DigesterFactory.addSelf(systemIds, "javaee_web_services_client_1_4.xsd");
        SERVLET_API_PUBLIC_IDS = Collections.unmodifiableMap(publicIds);
        SERVLET_API_SYSTEM_IDS = Collections.unmodifiableMap(systemIds);
    }
}

