/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.editors;

import java.beans.PropertyEditor;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transport.Connector;
import org.mule.config.spring.editors.ConnectorPropertyEditor;
import org.mule.config.spring.editors.DatePropertyEditor;
import org.mule.config.spring.editors.MessageExchangePatternPropertyEditor;
import org.mule.config.spring.editors.SimpleServiceTypePropertyEditor;
import org.mule.config.spring.editors.URIBuilderPropertyEditor;
import org.mule.construct.SimpleService;
import org.mule.endpoint.URIBuilder;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;

public class MulePropertyEditorRegistrar
implements PropertyEditorRegistrar,
MuleContextAware {
    private MuleContext muleContext;
    private Map<Class<?>, Class<PropertyEditor>> customPropertyEditorsCache;
    private static final String CUSTOM_PROPERTY_EDITOR_RESOURCE_NAME = "META-INF/mule.custom-property-editors";

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        registry.registerCustomEditor(Connector.class, (PropertyEditor)new ConnectorPropertyEditor(this.muleContext));
        registry.registerCustomEditor(URIBuilder.class, (PropertyEditor)new URIBuilderPropertyEditor(this.muleContext));
        registry.registerCustomEditor(MessageExchangePattern.class, (PropertyEditor)new MessageExchangePatternPropertyEditor());
        registry.registerCustomEditor(SimpleService.Type.class, (PropertyEditor)new SimpleServiceTypePropertyEditor());
        registry.registerCustomEditor(Date.class, (PropertyEditor)new DatePropertyEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd hh:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"), true));
        if (this.customPropertyEditorsCache == null) {
            this.discoverCustomPropertyEditor();
        }
        for (Map.Entry<Class<?>, Class<PropertyEditor>> entry : this.customPropertyEditorsCache.entrySet()) {
            try {
                registry.registerCustomEditor(entry.getKey(), (PropertyEditor)ClassUtils.instanciateClass(entry.getValue(), (Object[])new Object[0]));
            }
            catch (Exception e) {
                throw new IllegalStateException("Error loading custom property editors", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverCustomPropertyEditor() {
        this.customPropertyEditorsCache = new HashMap();
        try {
            Enumeration urls = ClassUtils.getResources((String)CUSTOM_PROPERTY_EDITOR_RESOURCE_NAME, this.getClass());
            while (urls.hasMoreElements()) {
                URL url = (URL)urls.nextElement();
                Properties props = new Properties();
                InputStream stream = url.openStream();
                try {
                    props.load(stream);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String target = (String)entry.getKey();
                        String editor = (String)entry.getValue();
                        Class requiredType = ClassUtils.loadClass((String)target, this.getClass());
                        Class propertyEditorClass = ClassUtils.loadClass((String)editor, this.getClass());
                        this.customPropertyEditorsCache.put(requiredType, propertyEditorClass);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading custom property editors", e);
        }
    }
}

