/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.velocity;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTStringLiteral;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.util.introspection.Info;
import org.mybatis.scripting.velocity.ParameterMappingCollector;
import org.mybatis.scripting.velocity.RepeatDirective;

public class InDirective
extends RepeatDirective {
    private String var;
    private String open = "(";
    private String close = ")";
    private String separator = ", ";
    private String column = "";

    @Override
    public String getName() {
        return "in";
    }

    @Override
    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        int n = node.jjtGetNumChildren() - 1;
        for (int i = 1; i < n; ++i) {
            Node child = node.jjtGetChild(i);
            if (i == 1) {
                if (child.getType() == 18) {
                    this.var = ((ASTReference)child).getRootString();
                    continue;
                }
                throw new TemplateInitException("Syntax error", this.getTemplateName(), this.getLine(), this.getColumn());
            }
            if (child.getType() == 8) {
                String value = (String)((ASTStringLiteral)child).value(context);
                switch (i) {
                    case 2: {
                        this.column = value;
                    }
                }
                continue;
            }
            throw new TemplateInitException("Syntax error", this.getTemplateName(), this.getLine(), this.getColumn());
        }
        this.uberInfo = new Info(this.getTemplateName(), this.getLine(), this.getColumn());
    }

    @Override
    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Object listObject = node.jjtGetChild(0).value(context);
        if (listObject == null) {
            return false;
        }
        Iterator iterator = null;
        try {
            iterator = this.rsvc.getUberspect().getIterator(listObject, this.uberInfo);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ee) {
            String msg = "Error getting iterator for #in at " + this.uberInfo;
            this.rsvc.getLog().error((Object)msg, (Throwable)ee);
            throw new VelocityException(msg, (Throwable)ee);
        }
        if (iterator == null) {
            throw new VelocityException("Invalid collection");
        }
        int counter = 0;
        Object o = context.get(this.var);
        ParameterMappingCollector collector = (ParameterMappingCollector)context.get("_pmc");
        String savedItemKey = collector.getItemKey();
        collector.setItemKey(this.var);
        RepeatDirective.RepeatScope foreach = new RepeatDirective.RepeatScope((Object)this, context.get(this.getName()), this.var);
        context.put(this.getName(), (Object)foreach);
        RepeatDirective.NullHolderContext nullHolderContext = null;
        Object value = null;
        writer.append(this.open);
        while (iterator.hasNext()) {
            if (counter % 1000 == 0) {
                writer.append(this.open);
                writer.append(this.column);
                writer.append(" IN ");
                writer.append(this.open);
            }
            value = iterator.next();
            this.put(context, this.var, value);
            ++foreach.index;
            foreach.hasNext = iterator.hasNext();
            try {
                if (value == null) {
                    if (nullHolderContext == null) {
                        nullHolderContext = new RepeatDirective.NullHolderContext(this.var, context);
                    }
                    node.jjtGetChild(node.jjtGetNumChildren() - 1).render((InternalContextAdapter)nullHolderContext, writer);
                } else {
                    node.jjtGetChild(node.jjtGetNumChildren() - 1).render(context, writer);
                }
            }
            catch (StopCommand stop) {
                if (stop.isFor((Object)this)) break;
                this.clean(context, o, collector, savedItemKey);
                throw stop;
            }
            if (++counter > 0 && counter % 1000 == 0 || !iterator.hasNext()) {
                writer.append(this.close);
                writer.append(this.close);
                if (!iterator.hasNext()) continue;
                writer.append(" OR ");
                continue;
            }
            if (!iterator.hasNext()) continue;
            writer.append(this.separator);
        }
        writer.append(this.close);
        this.clean(context, o, collector, savedItemKey);
        return true;
    }

    @Override
    public int getType() {
        return 1;
    }
}

