/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.tools.tck.api;

import gherkin.AstBuilder;
import gherkin.Parser;
import gherkin.TokenMatcher;
import gherkin.ast.GherkinDocument;
import gherkin.pickles.Compiler;
import gherkin.pickles.Pickle;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.opencypher.tools.tck.NamedGraphs$;
import org.opencypher.tools.tck.SideEffectOps;
import org.opencypher.tools.tck.api.CypherValueRecords;
import org.opencypher.tools.tck.api.CypherValueRecords$;
import org.opencypher.tools.tck.api.Dummy;
import org.opencypher.tools.tck.api.ExecQuery$;
import org.opencypher.tools.tck.api.Execute;
import org.opencypher.tools.tck.api.ExpectError;
import org.opencypher.tools.tck.api.ExpectResult;
import org.opencypher.tools.tck.api.ExpectResult$;
import org.opencypher.tools.tck.api.Feature;
import org.opencypher.tools.tck.api.InitQuery$;
import org.opencypher.tools.tck.api.InvalidFeatureFormatException;
import org.opencypher.tools.tck.api.Measure;
import org.opencypher.tools.tck.api.Parameters;
import org.opencypher.tools.tck.api.RegisterProcedure;
import org.opencypher.tools.tck.api.Scenario;
import org.opencypher.tools.tck.api.SideEffects;
import org.opencypher.tools.tck.api.SideEffects$;
import org.opencypher.tools.tck.api.Step;
import org.opencypher.tools.tck.api.events.TCKEvents;
import org.opencypher.tools.tck.api.events.TCKEvents$;
import org.opencypher.tools.tck.constants.TCKStepDefinitions$;
import org.opencypher.tools.tck.values.CypherValue;
import org.opencypher.tools.tck.values.CypherValue$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class CypherTCK$ {
    public static CypherTCK$ MODULE$;
    private Parser<GherkinDocument> parser;
    private TokenMatcher matcher;
    private final String featuresPath;
    private final String featureSuffix;
    private volatile byte bitmap$0;

    static {
        new CypherTCK$();
    }

    public String featuresPath() {
        return this.featuresPath;
    }

    public String featureSuffix() {
        return this.featureSuffix;
    }

    private Parser<GherkinDocument> parser$lzycompute() {
        CypherTCK$ cypherTCK$ = this;
        synchronized (cypherTCK$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.parser = new Parser((Parser.Builder)new AstBuilder());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.parser;
    }

    private Parser<GherkinDocument> parser() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.parser$lzycompute() : this.parser;
    }

    private TokenMatcher matcher$lzycompute() {
        CypherTCK$ cypherTCK$ = this;
        synchronized (cypherTCK$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.matcher = new TokenMatcher();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.matcher;
    }

    private TokenMatcher matcher() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.matcher$lzycompute() : this.matcher;
    }

    public Seq<Scenario> allTckScenarios() {
        return (Seq)this.parseClasspathFeatures(this.featuresPath()).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.scenarios(), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Scenario> allTckScenariosFromFilesystem() {
        return (Seq)this.parseFilesystemFeatures(new File(this.getClass().getResource(this.featuresPath()).toURI())).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.scenarios(), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Feature> parseClasspathFeatures(String path2) {
        Seq seq;
        URI resource = this.getClass().getResource(path2).toURI();
        try (FileSystem fs = FileSystems.newFileSystem(resource, new HashMap());){
            Path directoryPath = Paths.get(resource);
            Seq paths = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(Files.newDirectoryStream(directoryPath)).asScala()).toSeq();
            Seq featurePathStrings = (Seq)((TraversableLike)paths.map((Function1 & Serializable & scala.Serializable)path -> ((Object)path).toString(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.endsWith(CypherTCK$.MODULE$.featureSuffix())));
            Seq featureUrls = (Seq)featurePathStrings.map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.getClass().getResource((String)x$4), Seq$.MODULE$.canBuildFrom());
            seq = (Seq)featureUrls.map((Function1 & Serializable & scala.Serializable)pathUrl -> MODULE$.parseClasspathFeature((URL)pathUrl), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    private <T> T withSource(Source s, Function1<Source, T> f) {
        Object object;
        try {
            object = f.apply((Object)s);
        }
        finally {
            s.close();
        }
        return (T)object;
    }

    public Seq<Feature> parseFilesystemFeatures(File directory) {
        Predef$.MODULE$.require(directory.isDirectory());
        File[] featureFileNames = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])directory.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CypherTCK$.$anonfun$parseFilesystemFeatures$1(x$5)));
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureFileNames)).map((Function1 & Serializable & scala.Serializable)file -> MODULE$.parseFilesystemFeature((File)file), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Feature parseFilesystemFeature(File file) {
        String featureString = (String)this.withSource((Source)Source$.MODULE$.fromFile(file, Codec$.MODULE$.UTF8()), (Function1 & Serializable & scala.Serializable)x$6 -> x$6.mkString());
        return this.parseFeature(file.getAbsolutePath(), featureString);
    }

    public Feature parseClasspathFeature(URL pathUrl) {
        String featureString = (String)this.withSource((Source)Source$.MODULE$.fromURL(pathUrl, Codec$.MODULE$.UTF8()), (Function1 & Serializable & scala.Serializable)x$7 -> x$7.mkString());
        return this.parseFeature(pathUrl.toString(), featureString);
    }

    public Feature parseFeature(String source, String featureString) {
        GherkinDocument doc;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (GherkinDocument)MODULE$.parser().parse(featureString, (Parser.ITokenMatcher)MODULE$.matcher()));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable error = failure.exception();
                throw new InvalidFeatureFormatException(new StringBuilder(31).append("Could not parse feature from ").append(source).append(": ").append(error.getMessage()).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        GherkinDocument gherkinDocument = doc = (GherkinDocument)success.value();
        GherkinDocument gherkinDocument2 = gherkinDocument;
        Compiler compiler = new Compiler();
        Buffer pickles = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(compiler.compile(gherkinDocument2)).asScala();
        Buffer included = (Buffer)pickles.filterNot((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CypherTCK$.$anonfun$parseFeature$2(x$8)));
        String featureName = gherkinDocument2.getFeature().getName();
        Buffer scenarios = (Buffer)included.map((Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.toScenario(featureName, (Pickle)x$9), Buffer$.MODULE$.canBuildFrom());
        TCKEvents$.MODULE$.setFeature(new TCKEvents.FeatureRead(featureName, source, featureString));
        return new Feature((Seq<Scenario>)scenarios);
    }

    private Scenario toScenario(String featureName, Pickle pickle) {
        Set<String> tags = this.tagNames(pickle);
        boolean shouldValidate = !tags.contains((Object)"@allowCustomErrors");
        List steps = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pickle.getSteps()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)step -> {
            .colon.colon colon2;
            String string = step.getText();
            Option option = TCKStepDefinitions$.MODULE$.emptyGraphR().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                colon2 = new .colon.colon((Object)new Dummy((PickleStep)step), (List)Nil$.MODULE$);
            } else {
                Option option2 = TCKStepDefinitions$.MODULE$.namedGraphR().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                    String name = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    colon2 = new .colon.colon((Object)new Execute((String)NamedGraphs$.MODULE$.graphs().apply((Object)name), InitQuery$.MODULE$, (PickleStep)step), (List)Nil$.MODULE$);
                } else {
                    Option option3 = TCKStepDefinitions$.MODULE$.anyGraphR().unapplySeq((CharSequence)string);
                    if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(0) == 0) {
                        colon2 = new .colon.colon((Object)new Execute((String)NamedGraphs$.MODULE$.graphs().values().head(), InitQuery$.MODULE$, (PickleStep)step), (List)Nil$.MODULE$);
                    } else {
                        Option option4 = TCKStepDefinitions$.MODULE$.initQueryR().unapplySeq((CharSequence)string);
                        if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(0) == 0) {
                            colon2 = new .colon.colon((Object)new Execute(CypherTCK$.queryFromStep$1(step), InitQuery$.MODULE$, (PickleStep)step), (List)Nil$.MODULE$);
                        } else {
                            Option option5 = TCKStepDefinitions$.MODULE$.parametersR().unapplySeq((CharSequence)string);
                            if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(0) == 0) {
                                colon2 = new .colon.colon((Object)new Parameters((Map<String, CypherValue>)CypherTCK$.parseParameters$1(step), (PickleStep)step), (List)Nil$.MODULE$);
                            } else {
                                Option option6 = TCKStepDefinitions$.MODULE$.installedProcedureR().unapplySeq((CharSequence)string);
                                if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(1) == 0) {
                                    String signature = (String)((LinearSeqOptimized)option6.get()).apply(0);
                                    colon2 = new .colon.colon((Object)new RegisterProcedure(signature, CypherTCK$.parseTable$1(CypherTCK$.parseTable$default$1$1(), step), (PickleStep)step), (List)Nil$.MODULE$);
                                } else {
                                    Option option7 = TCKStepDefinitions$.MODULE$.executingQueryR().unapplySeq((CharSequence)string);
                                    if (!option7.isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(0) == 0) {
                                        colon2 = new .colon.colon((Object)new Measure((PickleStep)step), (List)new .colon.colon((Object)new Execute(CypherTCK$.queryFromStep$1(step), ExecQuery$.MODULE$, (PickleStep)step), (List)Nil$.MODULE$));
                                    } else {
                                        Option option8 = TCKStepDefinitions$.MODULE$.executingControlQueryR().unapplySeq((CharSequence)string);
                                        if (!option8.isEmpty() && option8.get() != null && ((LinearSeqOptimized)option8.get()).lengthCompare(0) == 0) {
                                            colon2 = new .colon.colon((Object)new Execute(CypherTCK$.queryFromStep$1(step), ExecQuery$.MODULE$, (PickleStep)step), (List)Nil$.MODULE$);
                                        } else {
                                            Option option9 = TCKStepDefinitions$.MODULE$.expectEmptyResultR().unapplySeq((CharSequence)string);
                                            if (!option9.isEmpty() && option9.get() != null && ((LinearSeqOptimized)option9.get()).lengthCompare(0) == 0) {
                                                colon2 = new .colon.colon((Object)new ExpectResult(CypherValueRecords$.MODULE$.empty(), (PickleStep)step, ExpectResult$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
                                            } else {
                                                Option option10 = TCKStepDefinitions$.MODULE$.expectResultR().unapplySeq((CharSequence)string);
                                                if (!option10.isEmpty() && option10.get() != null && ((LinearSeqOptimized)option10.get()).lengthCompare(0) == 0) {
                                                    colon2 = new .colon.colon((Object)new ExpectResult(CypherTCK$.parseTable$1(CypherTCK$.parseTable$default$1$1(), step), (PickleStep)step, ExpectResult$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
                                                } else {
                                                    Option option11 = TCKStepDefinitions$.MODULE$.expectSortedResultR().unapplySeq((CharSequence)string);
                                                    if (!option11.isEmpty() && option11.get() != null && ((LinearSeqOptimized)option11.get()).lengthCompare(0) == 0) {
                                                        colon2 = new .colon.colon((Object)new ExpectResult(CypherTCK$.parseTable$1(CypherTCK$.parseTable$default$1$1(), step), (PickleStep)step, true), (List)Nil$.MODULE$);
                                                    } else {
                                                        Option option12 = TCKStepDefinitions$.MODULE$.expectResultUnorderedListsR().unapplySeq((CharSequence)string);
                                                        if (!option12.isEmpty() && option12.get() != null && ((LinearSeqOptimized)option12.get()).lengthCompare(0) == 0) {
                                                            colon2 = new .colon.colon((Object)new ExpectResult(CypherTCK$.parseTable$1(false, step), (PickleStep)step, ExpectResult$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
                                                        } else {
                                                            Option option13 = TCKStepDefinitions$.MODULE$.expectErrorR().unapplySeq((CharSequence)string);
                                                            if (!option13.isEmpty() && option13.get() != null && ((LinearSeqOptimized)option13.get()).lengthCompare(3) == 0) {
                                                                String errorType = (String)((LinearSeqOptimized)option13.get()).apply(0);
                                                                String time = (String)((LinearSeqOptimized)option13.get()).apply(1);
                                                                String detail = (String)((LinearSeqOptimized)option13.get()).apply(2);
                                                                ExpectError expectedError = new ExpectError(errorType, time, detail, (PickleStep)step);
                                                                if (shouldValidate) {
                                                                    Option<String> option14 = expectedError.validate();
                                                                    if (None$.MODULE$.equals(option14)) {
                                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                                    } else {
                                                                        if (option14 instanceof Some) {
                                                                            Some some = (Some)option14;
                                                                            String errorMessage = (String)some.value();
                                                                            throw new InvalidFeatureFormatException(new StringBuilder(179).append("Invalid error format in scenario \"").append(pickle.getName()).append("\" from feature \"").append(featureName).append("\":\n                    ").append(errorMessage).append("\n                    If this is a custom error, then disable this validation with tag \"@allowCustomErrors\"").toString());
                                                                        }
                                                                        throw new MatchError(option14);
                                                                    }
                                                                }
                                                                PickleStep x$14 = step;
                                                                SideEffectOps.Diff x$15 = SideEffects$.MODULE$.apply$default$1();
                                                                colon2 = new .colon.colon((Object)expectedError, (List)new .colon.colon((Object)new SideEffects(x$15, x$14).fillInZeros(), (List)Nil$.MODULE$));
                                                            } else {
                                                                Option option15 = TCKStepDefinitions$.MODULE$.noSideEffectsR().unapplySeq((CharSequence)string);
                                                                if (!option15.isEmpty() && option15.get() != null && ((LinearSeqOptimized)option15.get()).lengthCompare(0) == 0) {
                                                                    PickleStep x$16 = step;
                                                                    SideEffectOps.Diff x$17 = SideEffects$.MODULE$.apply$default$1();
                                                                    colon2 = new .colon.colon((Object)new SideEffects(x$17, x$16).fillInZeros(), (List)Nil$.MODULE$);
                                                                } else {
                                                                    Option option16 = TCKStepDefinitions$.MODULE$.sideEffectsR().unapplySeq((CharSequence)string);
                                                                    if (!option16.isEmpty() && option16.get() != null && ((LinearSeqOptimized)option16.get()).lengthCompare(0) == 0) {
                                                                        colon2 = new .colon.colon((Object)new SideEffects(CypherTCK$.parseSideEffectsTable$1(step), (PickleStep)step).fillInZeros(), (List)Nil$.MODULE$);
                                                                    } else {
                                                                        throw new InvalidFeatureFormatException(new StringBuilder(49).append("Unsupported step: ").append(string).append(" in scenario \"").append(pickle.getName()).append("\" from feature \"").append(featureName).append("\"").toString());
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            .colon.colon scenarioSteps = colon2;
            return scenarioSteps;
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        return new Scenario(featureName, pickle.getName(), tags, (List<Step>)steps, pickle);
    }

    private Set<String> tagNames(Pickle pickle) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pickle.getTags()).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.getName(), Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$parseFilesystemFeatures$1(File x$5) {
        return x$5.getName().endsWith(MODULE$.featureSuffix());
    }

    public static final /* synthetic */ boolean $anonfun$parseFeature$2(Pickle x$8) {
        return MODULE$.tagNames(x$8).contains((Object)"@ignore");
    }

    private static final Buffer stepArguments$1(PickleStep step$1) {
        return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(step$1.getArgument()).asScala();
    }

    private static final String queryFromStep$1(PickleStep step$1) {
        Predef$.MODULE$.require(CypherTCK$.stepArguments$1(step$1).size() == 1);
        return ((PickleString)CypherTCK$.stepArguments$1(step$1).head()).getContent();
    }

    private static final CypherValueRecords parseTable$1(boolean orderedLists, PickleStep step$1) {
        Predef$.MODULE$.require(step$1.getArgument().size() == 1);
        Buffer rows = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((PickleTable)CypherTCK$.stepArguments$1(step$1).head()).getRows()).asScala();
        List header = CypherTCK$.cellValues$1((PickleRow)rows.head());
        Buffer values = (Buffer)rows.tail();
        List expectedRows = ((TraversableOnce)values.map((Function1 & Serializable & scala.Serializable)row -> ((TraversableOnce)header.zip((GenIterable)CypherTCK$.cellValues$1(row), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), Buffer$.MODULE$.canBuildFrom())).toList();
        return CypherValueRecords$.MODULE$.fromRows((List<String>)header, (List<Map<String, String>>)expectedRows, orderedLists);
    }

    private static final boolean parseTable$default$1$1() {
        return true;
    }

    private static final List cellValues$1(PickleRow row) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(row.getCells()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getValue(), Buffer$.MODULE$.canBuildFrom())).toList();
    }

    public static final /* synthetic */ int $anonfun$toScenario$4(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toInt();
    }

    private static final SideEffectOps.Diff parseSideEffectsTable$1(PickleStep step$1) {
        return new SideEffectOps.Diff((Map<String, Object>)CypherTCK$.parseMap$1((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)CypherTCK$.$anonfun$toScenario$4(x$11)), step$1));
    }

    private static final Map parseParameters$1(PickleStep step$1) {
        return CypherTCK$.parseMap$1((Function1 & Serializable & scala.Serializable)x$12 -> CypherValue$.MODULE$.apply((String)x$12, CypherValue$.MODULE$.apply$default$2()), step$1);
    }

    private static final Map parseMap$1(Function1 parseValue, PickleStep step$1) {
        Predef$.MODULE$.require(step$1.getArgument().size() == 1);
        Buffer rows = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((PickleTable)CypherTCK$.stepArguments$1(step$1).head()).getRows()).asScala();
        return ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> {
            List sideEffect = CypherTCK$.cellValues$1(row);
            Predef$.MODULE$.require(sideEffect.length() == 2);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(sideEffect.head()), parseValue.apply(((IterableLike)sideEffect.tail()).head()));
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private CypherTCK$() {
        MODULE$ = this;
        this.featuresPath = "/features";
        this.featureSuffix = ".feature";
    }
}

