/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.quarkus;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.annotations.Recorder;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.quarkus.config.OptaPlannerBenchmarkRuntimeConfig;
import org.optaplanner.core.config.localsearch.LocalSearchPhaseConfig;
import org.optaplanner.core.config.phase.PhaseConfig;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.termination.TerminationConfig;

@Recorder
public class OptaPlannerBenchmarkRecorder {
    public Supplier<PlannerBenchmarkConfig> benchmarkConfigSupplier(PlannerBenchmarkConfig benchmarkConfig) {
        return () -> {
            OptaPlannerBenchmarkRuntimeConfig optaPlannerRuntimeConfig = (OptaPlannerBenchmarkRuntimeConfig)Arc.container().instance(OptaPlannerBenchmarkRuntimeConfig.class, new Annotation[0]).get();
            SolverConfig solverConfig = (SolverConfig)Arc.container().instance(SolverConfig.class, new Annotation[0]).get();
            return this.updateBenchmarkConfigWithRuntimeProperties(benchmarkConfig, optaPlannerRuntimeConfig, solverConfig);
        };
    }

    private PlannerBenchmarkConfig updateBenchmarkConfigWithRuntimeProperties(PlannerBenchmarkConfig plannerBenchmarkConfig, OptaPlannerBenchmarkRuntimeConfig benchmarkRuntimeConfig, SolverConfig solverConfig) {
        TerminationConfig inheritedTerminationConfig;
        if (plannerBenchmarkConfig == null) {
            plannerBenchmarkConfig = PlannerBenchmarkConfig.createFromSolverConfig((SolverConfig)solverConfig);
        }
        plannerBenchmarkConfig.setBenchmarkDirectory(new File(benchmarkRuntimeConfig.resultDirectory));
        SolverBenchmarkConfig inheritedBenchmarkConfig = plannerBenchmarkConfig.getInheritedSolverBenchmarkConfig();
        if (plannerBenchmarkConfig.getSolverBenchmarkBluePrintConfigList() != null) {
            if (inheritedBenchmarkConfig == null) {
                inheritedBenchmarkConfig = new SolverBenchmarkConfig();
                plannerBenchmarkConfig.setInheritedSolverBenchmarkConfig(inheritedBenchmarkConfig);
                inheritedBenchmarkConfig.setSolverConfig(solverConfig.copyConfig());
            }
            if (inheritedBenchmarkConfig.getSolverConfig().getTerminationConfig() != null) {
                inheritedTerminationConfig = inheritedBenchmarkConfig.getSolverConfig().getTerminationConfig();
            } else {
                inheritedTerminationConfig = new TerminationConfig();
                inheritedBenchmarkConfig.getSolverConfig().setTerminationConfig(inheritedTerminationConfig);
            }
            benchmarkRuntimeConfig.termination.spentLimit.ifPresent(arg_0 -> ((TerminationConfig)inheritedTerminationConfig).setSpentLimit(arg_0));
            benchmarkRuntimeConfig.termination.unimprovedSpentLimit.ifPresent(arg_0 -> ((TerminationConfig)inheritedTerminationConfig).setUnimprovedSpentLimit(arg_0));
            benchmarkRuntimeConfig.termination.bestScoreLimit.ifPresent(arg_0 -> ((TerminationConfig)inheritedTerminationConfig).setBestScoreLimit(arg_0));
        }
        inheritedTerminationConfig = null;
        if (inheritedBenchmarkConfig != null && inheritedBenchmarkConfig.getSolverConfig() != null && inheritedBenchmarkConfig.getSolverConfig().getTerminationConfig() != null) {
            inheritedTerminationConfig = inheritedBenchmarkConfig.getSolverConfig().getTerminationConfig();
        }
        if (inheritedTerminationConfig == null || !inheritedTerminationConfig.isConfigured()) {
            List solverBenchmarkConfigList = plannerBenchmarkConfig.getSolverBenchmarkConfigList();
            ArrayList<String> unconfiguredTerminationSolverBenchmarkList = new ArrayList<String>();
            if (solverBenchmarkConfigList == null) {
                throw new IllegalStateException("At least one of the properties quarkus.optaplanner.benchmark.solver.termination.spent-limit, quarkus.optaplanner.benchmark.solver.termination.best-score-limit, quarkus.optaplanner.benchmark.solver.termination.unimproved-spent-limit is required if termination is not configured in the inherited solver benchmark config and solverBenchmarkBluePrint is used.");
            }
            for (int i = 0; i < solverBenchmarkConfigList.size(); ++i) {
                boolean isTerminationConfiguredForAllLocalSearchPhases;
                TerminationConfig terminationConfig;
                SolverBenchmarkConfig solverBenchmarkConfig = (SolverBenchmarkConfig)solverBenchmarkConfigList.get(i);
                if (solverBenchmarkConfig.getSolverConfig() == null) {
                    solverBenchmarkConfig.setSolverConfig(new SolverConfig());
                }
                if ((terminationConfig = solverBenchmarkConfig.getSolverConfig().getTerminationConfig()) == null) {
                    terminationConfig = new TerminationConfig();
                    solverBenchmarkConfig.getSolverConfig().setTerminationConfig(terminationConfig);
                } else if (terminationConfig.isConfigured()) continue;
                benchmarkRuntimeConfig.termination.spentLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setSpentLimit(arg_0));
                benchmarkRuntimeConfig.termination.unimprovedSpentLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setUnimprovedSpentLimit(arg_0));
                benchmarkRuntimeConfig.termination.bestScoreLimit.ifPresent(arg_0 -> ((TerminationConfig)terminationConfig).setBestScoreLimit(arg_0));
                if (terminationConfig.isConfigured()) continue;
                List phaseConfigList = solverBenchmarkConfig.getSolverConfig().getPhaseConfigList();
                boolean bl = isTerminationConfiguredForAllLocalSearchPhases = phaseConfigList != null && !phaseConfigList.isEmpty();
                if (isTerminationConfiguredForAllLocalSearchPhases) {
                    for (PhaseConfig phaseConfig : phaseConfigList) {
                        if (!(phaseConfig instanceof LocalSearchPhaseConfig) || phaseConfig.getTerminationConfig() != null && phaseConfig.getTerminationConfig().isConfigured()) continue;
                        isTerminationConfiguredForAllLocalSearchPhases = false;
                        break;
                    }
                }
                if (isTerminationConfiguredForAllLocalSearchPhases) continue;
                Object benchmarkConfigName = solverBenchmarkConfig.getName();
                if (benchmarkConfigName == null) {
                    benchmarkConfigName = "SolverBenchmarkConfig " + i;
                }
                unconfiguredTerminationSolverBenchmarkList.add((String)benchmarkConfigName);
            }
            if (!unconfiguredTerminationSolverBenchmarkList.isEmpty()) {
                throw new IllegalStateException("The following " + SolverBenchmarkConfig.class.getSimpleName() + " do not have termination configured: " + unconfiguredTerminationSolverBenchmarkList.stream().collect(Collectors.joining(", ", "[", "]")) + ". At least one of the properties quarkus.optaplanner.benchmark.solver.termination.spent-limit, quarkus.optaplanner.benchmark.solver.termination.best-score-limit, quarkus.optaplanner.benchmark.solver.termination.unimproved-spent-limit is required if termination is not configured in a solver benchmark and the inherited solver benchmark config.");
            }
        }
        if (plannerBenchmarkConfig.getSolverBenchmarkConfigList() != null) {
            for (SolverBenchmarkConfig childBenchmarkConfig : plannerBenchmarkConfig.getSolverBenchmarkConfigList()) {
                if (childBenchmarkConfig.getSolverConfig() == null) {
                    childBenchmarkConfig.setSolverConfig(new SolverConfig());
                }
                this.inheritPropertiesFromSolverConfig(childBenchmarkConfig, inheritedBenchmarkConfig, solverConfig);
            }
        }
        if (plannerBenchmarkConfig.getSolverBenchmarkConfigList() == null && plannerBenchmarkConfig.getSolverBenchmarkBluePrintConfigList() == null) {
            plannerBenchmarkConfig.setSolverBenchmarkConfigList(Collections.singletonList(new SolverBenchmarkConfig()));
        }
        return plannerBenchmarkConfig;
    }

    private void inheritPropertiesFromSolverConfig(SolverBenchmarkConfig childBenchmarkConfig, SolverBenchmarkConfig inheritedBenchmarkConfig, SolverConfig solverConfig) {
        this.inheritProperty(childBenchmarkConfig, inheritedBenchmarkConfig, solverConfig, SolverConfig::getSolutionClass, SolverConfig::setSolutionClass);
        this.inheritProperty(childBenchmarkConfig, inheritedBenchmarkConfig, solverConfig, SolverConfig::getEntityClassList, SolverConfig::setEntityClassList);
        this.inheritScoreCalculation(childBenchmarkConfig, inheritedBenchmarkConfig, solverConfig);
    }

    private <T> void inheritProperty(SolverBenchmarkConfig childBenchmarkConfig, SolverBenchmarkConfig inheritedBenchmarkConfig, SolverConfig solverConfig, Function<SolverConfig, T> getter, BiConsumer<SolverConfig, T> setter) {
        if (getter.apply(childBenchmarkConfig.getSolverConfig()) != null) {
            return;
        }
        if (inheritedBenchmarkConfig != null && inheritedBenchmarkConfig.getSolverConfig() != null && getter.apply(inheritedBenchmarkConfig.getSolverConfig()) != null) {
            return;
        }
        setter.accept(childBenchmarkConfig.getSolverConfig(), (SolverConfig)getter.apply(solverConfig));
    }

    private void inheritScoreCalculation(SolverBenchmarkConfig childBenchmarkConfig, SolverBenchmarkConfig inheritedBenchmarkConfig, SolverConfig solverConfig) {
        if (this.isScoreCalculationDefined(childBenchmarkConfig.getSolverConfig())) {
            return;
        }
        if (inheritedBenchmarkConfig != null && inheritedBenchmarkConfig.getSolverConfig() != null && this.isScoreCalculationDefined(inheritedBenchmarkConfig.getSolverConfig())) {
            return;
        }
        ScoreDirectorFactoryConfig childScoreDirectorFactoryConfig = childBenchmarkConfig.getSolverConfig().getScoreDirectorFactoryConfig();
        ScoreDirectorFactoryConfig inheritedScoreDirectorFactoryConfig = solverConfig.getScoreDirectorFactoryConfig();
        if (childScoreDirectorFactoryConfig == null) {
            childScoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
            childBenchmarkConfig.getSolverConfig().setScoreDirectorFactoryConfig(childScoreDirectorFactoryConfig);
        }
        childScoreDirectorFactoryConfig.inherit(inheritedScoreDirectorFactoryConfig);
    }

    private boolean isScoreCalculationDefined(SolverConfig solverConfig) {
        if (solverConfig == null) {
            return false;
        }
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = solverConfig.getScoreDirectorFactoryConfig();
        if (scoreDirectorFactoryConfig == null) {
            return false;
        }
        return scoreDirectorFactoryConfig.getEasyScoreCalculatorClass() != null || scoreDirectorFactoryConfig.getIncrementalScoreCalculatorClass() != null || scoreDirectorFactoryConfig.getScoreDrlList() != null || scoreDirectorFactoryConfig.getScoreDrlFileList() != null || scoreDirectorFactoryConfig.getConstraintProviderClass() != null;
    }
}

