/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.repackaged;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.MethodProxy;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.DelegatingMethod;
import org.mockito.internal.creation.util.MockitoMethodProxy;
import org.mockito.internal.invocation.InvocationImpl;
import org.mockito.internal.invocation.MockitoMethod;
import org.mockito.internal.invocation.SerializableMethod;
import org.mockito.internal.invocation.realmethod.CleanTraceRealMethod;
import org.mockito.internal.invocation.realmethod.RealMethod;
import org.mockito.internal.progress.SequenceNumber;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.powermock.api.mockito.repackaged.AcrossJVMSerializationFeature;
import org.powermock.api.mockito.repackaged.CGLIBHacker;
import org.powermock.api.mockito.repackaged.DelegatingMockitoMethodProxy;
import org.powermock.api.mockito.repackaged.SerializableMockitoMethodProxy;

public class MethodInterceptorFilter
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 6182795666612683784L;
    private final InternalMockHandler handler;
    final ObjectMethodsGuru objectMethodsGuru = new ObjectMethodsGuru();
    private final MockCreationSettings mockSettings;
    private final AcrossJVMSerializationFeature acrossJVMSerializationFeature = new AcrossJVMSerializationFeature();

    public MethodInterceptorFilter(InternalMockHandler handler, MockCreationSettings mockSettings) {
        this.handler = handler;
        this.mockSettings = mockSettings;
    }

    public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (this.objectMethodsGuru.isEqualsMethod(method)) {
            return proxy == args[0];
        }
        if (this.objectMethodsGuru.isHashCodeMethod(method)) {
            return this.hashCodeForMock(proxy);
        }
        if (this.acrossJVMSerializationFeature.isWriteReplace(method)) {
            return this.acrossJVMSerializationFeature.writeReplace(proxy);
        }
        MockitoMethodProxy mockitoMethodProxy = this.createMockitoMethodProxy(methodProxy);
        new CGLIBHacker().setMockitoNamingPolicy(methodProxy);
        MockitoMethod mockitoMethod = this.createMockitoMethod(method);
        CleanTraceRealMethod realMethod = new CleanTraceRealMethod(mockitoMethodProxy);
        InvocationImpl invocation = new InvocationImpl(proxy, mockitoMethod, args, SequenceNumber.next(), (RealMethod)realMethod);
        return this.handler.handle((Invocation)invocation);
    }

    public MockHandler getHandler() {
        return this.handler;
    }

    private int hashCodeForMock(Object mock) {
        return System.identityHashCode(mock);
    }

    public MockitoMethodProxy createMockitoMethodProxy(MethodProxy methodProxy) {
        if (this.mockSettings.isSerializable()) {
            return new SerializableMockitoMethodProxy(methodProxy);
        }
        return new DelegatingMockitoMethodProxy(methodProxy);
    }

    public MockitoMethod createMockitoMethod(Method method) {
        if (this.mockSettings.isSerializable()) {
            return new SerializableMethod(method);
        }
        return new DelegatingMethod(method);
    }
}

