/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.driver.AbstractButtonTextQuery;
import org.fest.util.Objects;
import org.fest.util.Strings;

public class JMenuItemMatcher
implements ComponentMatcher {
    private static final String SEPARATOR = "|";
    private final String label;

    public JMenuItemMatcher(String ... path) {
        this.label = Strings.join(path).with(SEPARATOR);
    }

    @RunsInCurrentThread
    public boolean matches(Component c) {
        if (!(c instanceof JMenuItem)) {
            return false;
        }
        JMenuItem menuItem = (JMenuItem)c;
        String text = menuItem.getText();
        return Objects.areEqual(this.label, text) || Objects.areEqual(this.label, this.pathOf(menuItem));
    }

    @RunsInCurrentThread
    private String pathOf(JMenuItem menuItem) {
        Component parent = this.parentOrInvokerOf(menuItem);
        if (parent instanceof JMenuItem) {
            return Strings.concat(this.pathOf((JMenuItem)parent), SEPARATOR, AbstractButtonTextQuery.textOf(menuItem));
        }
        return AbstractButtonTextQuery.textOf(menuItem);
    }

    @RunsInCurrentThread
    private Component parentOrInvokerOf(JMenuItem menuItem) {
        Component parent = menuItem.getParent();
        if (parent instanceof JPopupMenu) {
            parent = ((JPopupMenu)parent).getInvoker();
        }
        return parent;
    }

    public String toString() {
        return Strings.concat(this.getClass().getName(), "[", "label=", Strings.quote(this.label), "]");
    }
}

