/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JToolBar;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.util.Arrays;
import org.fest.util.Strings;

public final class JToolBarLocation {
    private static String[] VALID_CONSTRAINTS = new String[]{"North", "East", "South", "West"};

    @RunsInCurrentThread
    public Point pointToGrab(JToolBar toolBar) {
        Insets insets = toolBar.getInsets();
        int width = toolBar.getWidth();
        int height = toolBar.getHeight();
        if (Math.max(Math.max(Math.max(insets.left, insets.top), insets.right), insets.bottom) == insets.left) {
            return new Point(insets.left / 2, height / 2);
        }
        if (Math.max(Math.max(insets.top, insets.right), insets.bottom) == insets.top) {
            return new Point(width / 2, insets.top / 2);
        }
        if (Math.max(insets.right, insets.bottom) == insets.right) {
            return new Point(width - insets.right / 2, height / 2);
        }
        return new Point(width / 2, height - insets.bottom / 2);
    }

    @RunsInCurrentThread
    public Point dockLocation(JToolBar toolBar, Container dock, String constraint) {
        this.validate(constraint);
        Insets insets = dock.getInsets();
        int offset = this.isHorizontal(toolBar) ? toolBar.getHeight() : toolBar.getWidth();
        Dimension dockSize = dock.getSize();
        if ("North".equals(constraint)) {
            return new Point(dockSize.width / 2, insets.top);
        }
        if ("East".equals(constraint)) {
            return new Point(dockSize.width - insets.right - 1, this.verticalDockingYCoordinate(dockSize.height, insets, offset));
        }
        if ("West".equals(constraint)) {
            return new Point(insets.left, this.verticalDockingYCoordinate(dockSize.height, insets, offset));
        }
        int x = dockSize.width / 2;
        if (x < insets.left + offset) {
            x = insets.left + offset;
        } else if (x > dockSize.width - insets.right - offset - 1) {
            x = dockSize.width - insets.right - offset - 1;
        }
        return new Point(x, dockSize.height - insets.bottom - 1);
    }

    @RunsInCurrentThread
    private boolean isHorizontal(JToolBar toolBar) {
        return toolBar.getOrientation() == 0;
    }

    private void validate(String constraint) {
        for (String validConstraint : VALID_CONSTRAINTS) {
            if (!validConstraint.equals(constraint)) continue;
            return;
        }
        throw this.invalidConstraint(constraint);
    }

    private IllegalArgumentException invalidConstraint(String constraint) {
        throw new IllegalArgumentException(Strings.concat(Strings.quote(constraint), " is not a valid constraint. Valid constraints are ", Arrays.format(VALID_CONSTRAINTS)));
    }

    private int verticalDockingYCoordinate(int dockHeight, Insets insets, int offset) {
        int y = dockHeight / 2;
        if (y < insets.top + offset) {
            y = insets.top + offset;
        }
        return y;
    }
}

