/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.v4_3_1.runner;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.fest.swing.junit.runner.FailureScreenshotTaker;
import org.fest.swing.junit.runner.ImageFolderCreator;
import org.fest.swing.junit.v4_3_1.runner.InnerRunner;
import org.fest.swing.junit.v4_3_1.runner.MethodRunner;
import org.fest.swing.junit.v4_3_1.runner.TestInfo;
import org.junit.Test;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.MethodValidator;
import org.junit.internal.runners.TestIntrospector;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUITestRunner
extends Runner {
    private final List<Method> testMethods;
    private final Class<?> testClass;
    private final FailureScreenshotTaker screenshotTaker;

    public GUITestRunner(Class<?> testClass) throws InitializationError {
        this.testClass = testClass;
        this.testMethods = new TestIntrospector(testClass).getTestMethods(Test.class);
        this.validate();
        this.screenshotTaker = new FailureScreenshotTaker(new ImageFolderCreator().createImageFolder());
    }

    private void validate() throws InitializationError {
        MethodValidator methodValidator = new MethodValidator(this.testClass);
        methodValidator.validateMethodsForDefaultRunner();
        methodValidator.assertValid();
    }

    @Override
    public void run(RunNotifier notifier) {
        new InnerRunner(this, notifier).runProtected();
    }

    void doRun(RunNotifier notifier) {
        if (this.testMethods.isEmpty()) {
            notifier.testAborted(this.getDescription(), new Exception("No runnable methods"));
        }
        for (Method method : this.testMethods) {
            this.invokeTestMethod(method, notifier);
        }
    }

    private void invokeTestMethod(Method method, RunNotifier notifier) {
        Object test;
        try {
            test = this.testClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            notifier.testAborted(this.descriptionOf(method), e.getCause());
            return;
        }
        catch (Exception e) {
            notifier.testAborted(this.descriptionOf(method), e);
            return;
        }
        this.createMethodRunner(test, method, notifier).run();
    }

    private MethodRunner createMethodRunner(Object test, Method method, RunNotifier notifier) {
        return new MethodRunner(new TestInfo(test, this.testClass, method), notifier, this.screenshotTaker);
    }

    final Class<?> testClass() {
        return this.testClass;
    }

    @Override
    public Description getDescription() {
        Description spec = Description.createSuiteDescription(this.testClass.getName());
        for (Method method : this.testMethods) {
            spec.addChild(this.descriptionOf(method));
        }
        return spec;
    }

    private Description descriptionOf(Method method) {
        return Description.createTestDescription(this.testClass, method.getName());
    }
}

