/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.xml;

import org.fest.util.Objects;
import org.fest.util.Strings;

public class XmlAttribute {
    private final String name;
    private final String value;

    public static XmlAttributeBuilder name(String name) {
        return new XmlAttributeBuilder(name);
    }

    XmlAttribute(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XmlAttribute other = (XmlAttribute)obj;
        if (!Objects.areEqual(this.name, other.name)) {
            return false;
        }
        return Objects.areEqual(this.value, other.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.name);
        result = 31 * result + Objects.hashCodeFor(this.value);
        return result;
    }

    public String toString() {
        return Strings.concat(this.getClass().getSimpleName(), "[", "name=", Strings.quote(this.name), ",", "value=", Strings.quote(this.value), "]");
    }

    public static class XmlAttributeBuilder {
        private final String name;

        XmlAttributeBuilder(String name) {
            this.name = name;
        }

        public XmlAttribute value(String value) {
            return new XmlAttribute(this.name, value);
        }

        public XmlAttribute value(long value) {
            return new XmlAttribute(this.name, String.valueOf(value));
        }

        public XmlAttribute value(double value) {
            return new XmlAttribute(this.name, String.valueOf(value));
        }
    }
}

