/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.keystroke;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.fest.reflect.core.Reflection;
import org.fest.reflect.exception.ReflectionError;
import org.fest.swing.exception.ParsingException;
import org.fest.swing.keystroke.KeyStrokeMapping;
import org.fest.swing.keystroke.KeyStrokeMappingProvider;
import org.fest.swing.keystroke.ParsedKeyStrokeMappingProvider;
import org.fest.util.Closeables;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

public class KeyStrokeMappingsParser {
    private static final Map<String, Character> SPECIAL_MAPPINGS = new HashMap<String, Character>();

    public KeyStrokeMappingProvider parse(String file) {
        this.validate(file);
        try {
            return this.parse(this.fileAsStream(file));
        }
        catch (IOException e) {
            throw new ParsingException(Strings.concat("An I/O error ocurred while parsing file ", file), e);
        }
    }

    private void validate(String file) {
        if (file == null) {
            throw new NullPointerException("The name of the file to parse should not be null");
        }
        if (Strings.isEmpty(file)) {
            throw new IllegalArgumentException("The name of the file to parse should not be an empty string");
        }
    }

    private InputStream fileAsStream(String file) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        if (stream == null) {
            throw new ParsingException(Strings.concat("Unable to open file ", file));
        }
        return stream;
    }

    public KeyStrokeMappingProvider parse(File file) {
        this.validate(file);
        try {
            return this.parse(this.fileAsStream(file));
        }
        catch (IOException e) {
            throw new ParsingException(Strings.concat("An I/O error ocurred while parsing file ", file), e);
        }
    }

    private void validate(File file) {
        if (file == null) {
            throw new NullPointerException("The file to parse should not be null");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(Strings.concat("The file ", file.getPath(), " is not an existing file"));
        }
    }

    private InputStream fileAsStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ParsingException(Strings.concat("The file ", file.getPath(), " was not found"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStrokeMappingProvider parse(InputStream input) throws IOException {
        ParsedKeyStrokeMappingProvider parsedKeyStrokeMappingProvider;
        ArrayList<KeyStrokeMapping> mappings = new ArrayList<KeyStrokeMapping>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        try {
            String line = reader.readLine();
            while (line != null) {
                mappings.add(this.mappingFrom(line));
                line = reader.readLine();
            }
            parsedKeyStrokeMappingProvider = new ParsedKeyStrokeMappingProvider(mappings);
        }
        catch (Throwable throwable) {
            Closeables.close(reader);
            throw throwable;
        }
        Closeables.close(reader);
        return parsedKeyStrokeMappingProvider;
    }

    @VisibleForTesting
    KeyStrokeMapping mappingFrom(String line) {
        String[] parts = KeyStrokeMappingsParser.split(line);
        if (parts.length != 3) {
            throw KeyStrokeMappingsParser.notConformingWithPatternError(line);
        }
        char character = KeyStrokeMappingsParser.characterFrom(parts[0].trim());
        int keyCode = KeyStrokeMappingsParser.keyCodeFrom(parts[1].trim());
        int modifiers = KeyStrokeMappingsParser.modifiersFrom(parts[2].trim());
        return KeyStrokeMapping.mapping(character, keyCode, modifiers);
    }

    private static String[] split(String line) {
        return line.trim().split(",");
    }

    private static ParsingException notConformingWithPatternError(String line) {
        return new ParsingException(Strings.concat("Line ", Strings.quote(line), " does not conform with pattern '{char}, {keycode}, {modifiers}'"));
    }

    private static char characterFrom(String s) {
        if (SPECIAL_MAPPINGS.containsKey(s)) {
            return SPECIAL_MAPPINGS.get(s).charValue();
        }
        if (s.length() == 1) {
            return s.charAt(0);
        }
        throw new ParsingException(Strings.concat("The text ", Strings.quote(s), " should have a single character"));
    }

    private static int keyCodeFrom(String s) {
        try {
            return Reflection.staticField(KeyStrokeMappingsParser.keyCodeNameFrom(s)).ofType(Integer.TYPE).in(KeyEvent.class).get();
        }
        catch (ReflectionError e) {
            throw new ParsingException(Strings.concat("Unable to retrieve key code from text ", Strings.quote(s)), e.getCause());
        }
    }

    private static String keyCodeNameFrom(String s) {
        return Strings.concat("VK_", s);
    }

    private static int modifiersFrom(String s) {
        if ("NO_MASK".equals(s)) {
            return 0;
        }
        try {
            return Reflection.staticField(s).ofType(Integer.TYPE).in(InputEvent.class).get();
        }
        catch (ReflectionError e) {
            throw new ParsingException(Strings.concat("Unable to retrieve modifiers from text ", Strings.quote(s)), e.getCause());
        }
    }

    static {
        SPECIAL_MAPPINGS.put("COMMA", Character.valueOf(','));
    }
}

