/*
 * Decompiled with CFR 0.152.
 */
package test.common;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.FilteredResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import test.common.LocaleSwitcher;
import test.common.LookAndFeelSwitcher;
import test.common.QuickStylesPanel;
import test.svg.transcoded.address_book_new;
import test.svg.transcoded.edit_copy;
import test.svg.transcoded.edit_cut;
import test.svg.transcoded.edit_paste;
import test.svg.transcoded.text_x_generic;
import test.svg.transcoded.x_office_document;

public class TestCommandButtons
extends JFrame {
    protected ResourceBundle resourceBundle;
    protected Locale currLocale;
    private JPanel buttonPanel;
    private JComboBox popupCombo;

    public TestCommandButtons() {
        super("Command button test");
        this.setIconImage(new BufferedImage(1, 1, 2));
        this.setLayout(new BorderLayout());
        this.currLocale = Locale.getDefault();
        this.resourceBundle = ResourceBundle.getBundle("test.resource.Resources", this.currLocale);
        this.buttonPanel = this.getButtonPanel();
        this.add((Component)this.buttonPanel, "Center");
        JPanel controlPanel = new JPanel(new FlowLayout(1));
        this.configureControlPanel(controlPanel);
        this.add((Component)controlPanel, "South");
    }

    protected JPanel getButtonPanel() {
        FormLayout lm = new FormLayout("right:pref, 10dlu, center:pref, 4dlu,center:pref, 4dlu, center:pref, 4dlu, center:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm);
        builder.setDefaultDialogBorder();
        builder.append("");
        builder.append("Action only");
        builder.append("Action (main) + popup");
        builder.append("Action + popup (main)");
        builder.append("Popup only");
        this.addButtons(builder, CommandButtonDisplayState.BIG);
        this.addButtons(builder, CommandButtonDisplayState.TILE);
        this.addButtons(builder, CommandButtonDisplayState.MEDIUM);
        this.addButtons(builder, CommandButtonDisplayState.SMALL);
        JPanel buttonsPanel = builder.getPanel();
        return buttonsPanel;
    }

    protected static String stamp() {
        return new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
    }

    private void addButtons(DefaultFormBuilder builder, CommandButtonDisplayState state) {
        builder.append(String.valueOf(state.getDisplayName()) + " state");
        JCommandButton actionButton = this.createActionButton(state);
        builder.append(actionButton);
        JCommandButton actionAndPopupMainActionButton = this.createActionAndPopupMainActionButton(state);
        builder.append(actionAndPopupMainActionButton);
        JCommandButton actionAndPopupMainPopupButton = this.createActionAndPopupMainPopupButton(state);
        builder.append(actionAndPopupMainPopupButton);
        JCommandButton popupButton = this.createPopupButton(state);
        builder.append(popupButton);
    }

    protected JCommandButton createPopupButton(CommandButtonDisplayState state) {
        JCommandButton popupButton = new JCommandButton(this.resourceBundle.getString("SelectAll.text"), new edit_paste());
        popupButton.setExtraText(this.resourceBundle.getString("SelectAll.textExtra"));
        popupButton.setPopupCallback(new TestPopupCallback());
        popupButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        popupButton.setDisplayState(state);
        popupButton.setFlat(false);
        return popupButton;
    }

    protected JCommandButton createActionAndPopupMainPopupButton(CommandButtonDisplayState state) {
        JCommandButton copyButton = new JCommandButton(this.resourceBundle.getString("Copy.text"), new edit_copy());
        copyButton.setExtraText(this.resourceBundle.getString("Copy.textExtra"));
        copyButton.setPopupCallback(new TestPopupCallback());
        copyButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
        copyButton.setDisplayState(state);
        copyButton.setFlat(false);
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(String.valueOf(TestCommandButtons.stamp()) + ": Copy");
            }
        });
        return copyButton;
    }

    protected JCommandButton createActionAndPopupMainActionButton(CommandButtonDisplayState state) {
        JCommandButton cutButton = new JCommandButton(this.resourceBundle.getString("Cut.text"), new edit_cut());
        cutButton.setExtraText(this.resourceBundle.getString("Cut.textExtra"));
        cutButton.setPopupCallback(new TestPopupCallback());
        cutButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        cutButton.setDisplayState(state);
        cutButton.setFlat(false);
        cutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(String.valueOf(TestCommandButtons.stamp()) + ": Cut");
            }
        });
        return cutButton;
    }

    protected JCommandButton createActionButton(CommandButtonDisplayState state) {
        JCommandButton mainButton = new JCommandButton(this.resourceBundle.getString("Paste.text"), new edit_paste());
        mainButton.setDisabledIcon(new FilteredResizableIcon(new edit_paste(), new ColorConvertOp(ColorSpace.getInstance(1003), null)));
        mainButton.setExtraText(this.resourceBundle.getString("Paste.textExtra"));
        mainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(String.valueOf(TestCommandButtons.stamp()) + ": Main paste");
            }
        });
        mainButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
        mainButton.setDisplayState(state);
        mainButton.setFlat(false);
        return mainButton;
    }

    protected void configureControlPanel(JPanel controlPanel) {
        controlPanel.add(LookAndFeelSwitcher.getLookAndFeelSwitcher(this));
        final JCheckBox enabled = new JCheckBox("enabled");
        enabled.setSelected(true);
        enabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.scan(TestCommandButtons.this);
                        TestCommandButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        int i = 0;
                        while (i < c.getComponentCount()) {
                            Component child = c.getComponent(i);
                            if (child instanceof AbstractCommandButton) {
                                child.setEnabled(enabled.isSelected());
                            }
                            if (child instanceof Container) {
                                this.scan((Container)child);
                            }
                            ++i;
                        }
                    }
                });
            }
        });
        controlPanel.add(enabled);
        final JCheckBox actionEnabled = new JCheckBox("action enabled");
        actionEnabled.setSelected(true);
        actionEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.scan(TestCommandButtons.this);
                        TestCommandButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        int i = 0;
                        while (i < c.getComponentCount()) {
                            Component child = c.getComponent(i);
                            if (child instanceof AbstractCommandButton) {
                                ((AbstractCommandButton)child).getActionModel().setEnabled(actionEnabled.isSelected());
                            }
                            if (child instanceof Container) {
                                this.scan((Container)child);
                            }
                            ++i;
                        }
                    }
                });
            }
        });
        controlPanel.add(actionEnabled);
        final JCheckBox popupEnabled = new JCheckBox("popup enabled");
        popupEnabled.setSelected(true);
        popupEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.scan(TestCommandButtons.this);
                        TestCommandButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        int i = 0;
                        while (i < c.getComponentCount()) {
                            Component child = c.getComponent(i);
                            if (child instanceof JCommandButton) {
                                ((JCommandButton)child).getPopupModel().setEnabled(popupEnabled.isSelected());
                            }
                            if (child instanceof Container) {
                                this.scan((Container)child);
                            }
                            ++i;
                        }
                    }
                });
            }
        });
        controlPanel.add(popupEnabled);
        final JCheckBox flat = new JCheckBox("flat");
        flat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.scan(TestCommandButtons.this);
                        TestCommandButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        int i = 0;
                        while (i < c.getComponentCount()) {
                            Component child = c.getComponent(i);
                            if (child instanceof AbstractCommandButton) {
                                ((AbstractCommandButton)child).setFlat(flat.isSelected());
                            }
                            if (child instanceof Container) {
                                this.scan((Container)child);
                            }
                            ++i;
                        }
                    }
                });
            }
        });
        controlPanel.add(flat);
        final JCheckBox downward = new JCheckBox("downward");
        downward.setSelected(true);
        downward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.scan(TestCommandButtons.this);
                        TestCommandButtons.this.repaint();
                    }

                    private void scan(Container c) {
                        int i = 0;
                        while (i < c.getComponentCount()) {
                            Component child = c.getComponent(i);
                            if (child instanceof JCommandButton) {
                                ((JCommandButton)child).setPopupOrientationKind(downward.isSelected() ? JCommandButton.CommandButtonPopupOrientationKind.DOWNWARD : JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
                            }
                            if (child instanceof Container) {
                                this.scan((Container)child);
                            }
                            ++i;
                        }
                    }
                });
            }
        });
        controlPanel.add(downward);
        this.popupCombo = new JComboBox<PopupKind>(PopupKind.values());
        this.popupCombo.setSelectedItem((Object)PopupKind.SIMPLE);
        controlPanel.add(this.popupCombo);
        JComboBox localeSwitcher = LocaleSwitcher.getLocaleSwitcher(new LocaleSwitcher.LocaleCallback(){

            @Override
            public void onLocaleSelected(Locale selected) {
                TestCommandButtons.this.currLocale = selected;
                TestCommandButtons.this.resourceBundle = ResourceBundle.getBundle("test.resource.Resources", TestCommandButtons.this.currLocale);
                TestCommandButtons.this.remove(TestCommandButtons.this.buttonPanel);
                TestCommandButtons.this.buttonPanel = TestCommandButtons.this.getButtonPanel();
                TestCommandButtons.this.add((Component)TestCommandButtons.this.buttonPanel, "Center");
                Window window = SwingUtilities.getWindowAncestor(TestCommandButtons.this.buttonPanel);
                window.applyComponentOrientation(ComponentOrientation.getOrientation(TestCommandButtons.this.currLocale));
                SwingUtilities.updateComponentTreeUI(window);
            }
        });
        controlPanel.add(localeSwitcher);
    }

    public static void main(String[] args) {
        UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
        UIManager.installLookAndFeel("JGoodies PlasticXP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        UIManager.installLookAndFeel("JGoodies Plastic3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        UIManager.installLookAndFeel("JGoodies Windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
        UIManager.installLookAndFeel("Synthetica base", "de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlackMoon", "de.javasoft.plaf.synthetica.SyntheticaBlackMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlackStar", "de.javasoft.plaf.synthetica.SyntheticaBlackStarLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueIce", "de.javasoft.plaf.synthetica.SyntheticaBlueIceLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueMoon", "de.javasoft.plaf.synthetica.SyntheticaBlueMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueSteel", "de.javasoft.plaf.synthetica.SyntheticaBlueSteelLookAndFeel");
        UIManager.installLookAndFeel("Synthetica GreenDream", "de.javasoft.plaf.synthetica.SyntheticaGreenDreamLookAndFeel");
        UIManager.installLookAndFeel("Synthetica MauveMetallic", "de.javasoft.plaf.synthetica.SyntheticaMauveMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica OrangeMetallic", "de.javasoft.plaf.synthetica.SyntheticaOrangeMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica SkyMetallic", "de.javasoft.plaf.synthetica.SyntheticaSkyMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica SilverMoon", "de.javasoft.plaf.synthetica.SyntheticaSilverMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica WhiteVision", "de.javasoft.plaf.synthetica.SyntheticaWhiteVisionLookAndFeel");
        UIManager.installLookAndFeel("A03", "a03.swing.plaf.A03LookAndFeel");
        UIManager.installLookAndFeel("Liquid", "com.birosoft.liquid.LiquidLookAndFeel");
        UIManager.installLookAndFeel("Napkin", "net.sourceforge.napkinlaf.NapkinLookAndFeel");
        UIManager.installLookAndFeel("Pagosoft", "com.pagosoft.plaf.PgsLookAndFeel");
        UIManager.installLookAndFeel("Squareness", "net.beeger.squareness.SquarenessLookAndFeel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TestCommandButtons frame = new TestCommandButtons();
                frame.setSize(800, 400);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
                frame.setDefaultCloseOperation(2);
            }
        });
    }

    private static enum PopupKind {
        SIMPLE,
        SCROLLABLE,
        COMPLEX;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    protected class TestPopupCallback
    implements PopupPanelCallback {
        protected TestPopupCallback() {
        }

        @Override
        public JPopupPanel getPopupPanel(JCommandButton commandButton) {
            MessageFormat mf = new MessageFormat(TestCommandButtons.this.resourceBundle.getString("TestMenuItem.text"));
            mf.setLocale(TestCommandButtons.this.currLocale);
            PopupKind popupKind = (PopupKind)((Object)TestCommandButtons.this.popupCombo.getSelectedItem());
            switch (popupKind) {
                case SIMPLE: {
                    JCommandPopupMenu simpleMenu = new JCommandPopupMenu();
                    simpleMenu.addMenuButton(new JCommandMenuButton(mf.format(new Object[]{"1"}), new address_book_new()));
                    simpleMenu.addMenuButton(new JCommandMenuButton(mf.format(new Object[]{"2"}), new EmptyResizableIcon(16)));
                    simpleMenu.addMenuButton(new JCommandMenuButton(mf.format(new Object[]{"3"}), new EmptyResizableIcon(16)));
                    simpleMenu.addMenuSeparator();
                    simpleMenu.addMenuButton(new JCommandMenuButton(mf.format(new Object[]{"4"}), new EmptyResizableIcon(16)));
                    simpleMenu.addMenuButton(new JCommandMenuButton(mf.format(new Object[]{"5"}), new text_x_generic()));
                    return simpleMenu;
                }
                case SCROLLABLE: {
                    JCommandPopupMenu scrollableMenu = new JCommandPopupMenu();
                    int i = 0;
                    while (i < 20) {
                        final JCommandMenuButton smb = new JCommandMenuButton(mf.format(new Object[]{i}), new text_x_generic());
                        smb.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                System.out.println("Invoked action on '" + smb.getText() + "'");
                            }
                        });
                        scrollableMenu.addMenuButton(smb);
                        ++i;
                    }
                    scrollableMenu.setMaxVisibleMenuButtons(8);
                    return scrollableMenu;
                }
                case COMPLEX: {
                    JCommandPopupMenu complexMenu = new JCommandPopupMenu(new QuickStylesPanel(TestCommandButtons.this.resourceBundle, TestCommandButtons.this.currLocale), 5, 3);
                    complexMenu.addMenuButton(new JCommandMenuButton(TestCommandButtons.this.resourceBundle.getString("SaveSelection.text"), new x_office_document()));
                    complexMenu.addMenuButton(new JCommandMenuButton(TestCommandButtons.this.resourceBundle.getString("ClearSelection.text"), new EmptyResizableIcon(16)));
                    complexMenu.addMenuSeparator();
                    complexMenu.addMenuButton(new JCommandMenuButton(TestCommandButtons.this.resourceBundle.getString("ApplyStyles.text"), new EmptyResizableIcon(16)));
                    return complexMenu;
                }
            }
            return null;
        }
    }
}

