/*
 * Decompiled with CFR 0.152.
 */
package test.ribbon;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RepaintManager;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.HorizontalAlignment;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.DecoratedResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.ribbon.JFlowRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryFooter;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntrySecondary;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizeSequencingPolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.utils.RenderingUtils;
import test.common.LookAndFeelSwitcher;
import test.ribbon.SimpleResizableIcon;
import test.ribbon.TracingRepaintManager;
import test.svg.transcoded.address_book_new;
import test.svg.transcoded.applications_games;
import test.svg.transcoded.applications_internet;
import test.svg.transcoded.applications_office;
import test.svg.transcoded.applications_other;
import test.svg.transcoded.appointment_new;
import test.svg.transcoded.bookmark_new;
import test.svg.transcoded.contact_new;
import test.svg.transcoded.document_new;
import test.svg.transcoded.document_open;
import test.svg.transcoded.document_print;
import test.svg.transcoded.document_print_preview;
import test.svg.transcoded.document_properties;
import test.svg.transcoded.document_save;
import test.svg.transcoded.document_save_as;
import test.svg.transcoded.edit_clear;
import test.svg.transcoded.edit_copy;
import test.svg.transcoded.edit_cut;
import test.svg.transcoded.edit_find;
import test.svg.transcoded.edit_find_replace;
import test.svg.transcoded.edit_paste;
import test.svg.transcoded.edit_select_all;
import test.svg.transcoded.folder;
import test.svg.transcoded.folder_remote;
import test.svg.transcoded.folder_saved_search;
import test.svg.transcoded.font_x_generic;
import test.svg.transcoded.format_indent_less;
import test.svg.transcoded.format_indent_more;
import test.svg.transcoded.format_justify_center;
import test.svg.transcoded.format_justify_fill;
import test.svg.transcoded.format_justify_left;
import test.svg.transcoded.format_justify_right;
import test.svg.transcoded.format_text_bold;
import test.svg.transcoded.format_text_italic;
import test.svg.transcoded.format_text_strikethrough;
import test.svg.transcoded.format_text_underline;
import test.svg.transcoded.help_browser;
import test.svg.transcoded.image_x_generic;
import test.svg.transcoded.mail_forward;
import test.svg.transcoded.mail_message_new;
import test.svg.transcoded.network_wireless;
import test.svg.transcoded.preferences_desktop_accessibility;
import test.svg.transcoded.preferences_desktop_assistive_technology;
import test.svg.transcoded.preferences_desktop_font;
import test.svg.transcoded.preferences_desktop_keyboard_shortcuts;
import test.svg.transcoded.preferences_desktop_locale;
import test.svg.transcoded.preferences_desktop_screensaver;
import test.svg.transcoded.preferences_desktop_theme;
import test.svg.transcoded.printer;
import test.svg.transcoded.system_log_out;
import test.svg.transcoded.system_search;
import test.svg.transcoded.text_html;
import test.svg.transcoded.text_x_generic;
import test.svg.transcoded.x_office_document;

public class BasicCheckRibbon
extends JRibbonFrame {
    protected Locale currLocale;
    protected ResourceBundle resourceBundle;
    protected RibbonContextualTaskGroup group1;
    protected RibbonContextualTaskGroup group2;
    protected JPanel statusBar;
    private JRibbonBand paragraphBand;

    private AbstractCommandButton getIconButton(final Icon icon, boolean isToggle, boolean isSelected, boolean hasPopup) {
        ResizableIcon resizableIcon = new ResizableIcon(){
            int width;
            int height;
            {
                this.width = icon2.getIconWidth();
                this.height = icon2.getIconHeight();
            }

            @Override
            public int getIconHeight() {
                return this.height;
            }

            @Override
            public int getIconWidth() {
                return this.width;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                icon.paintIcon(c, g, x, y);
            }

            @Override
            public void setDimension(Dimension newDimension) {
                this.width = newDimension.width;
                this.height = newDimension.height;
            }
        };
        AbstractCommandButton button = isToggle ? new JCommandToggleButton("", resizableIcon) : new JCommandButton("", resizableIcon);
        button.setDisplayState(CommandButtonDisplayState.SMALL);
        button.setGapScaleFactor(0.5);
        if (isSelected) {
            button.getActionModel().setSelected(true);
        }
        Insets currInsets = button.getInsets();
        button.setBorder(new EmptyBorder(currInsets.top, currInsets.top / 2, currInsets.bottom, currInsets.bottom / 2));
        if (hasPopup) {
            ((JCommandButton)button).setPopupCallback(new PopupPanelCallback(){

                @Override
                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    return new SamplePopupMenu();
                }
            });
        }
        return button;
    }

    protected JRibbonBand getActionBand() {
        JRibbonBand actionBand = new JRibbonBand(this.resourceBundle.getString("Action.textBandTitle"), new document_new(), new ExpandActionListener());
        actionBand.setResizePolicies(CoreRibbonResizePolicies.getCorePoliciesRestrictive(actionBand));
        actionBand.startGroup();
        JCommandButton addressBookButton = new JCommandButton(this.resourceBundle.getString("AddressBook.text"), new address_book_new());
        addressBookButton.setActionKeyTip("NA");
        actionBand.addCommandButton(addressBookButton, RibbonElementPriority.TOP);
        actionBand.startGroup();
        JCommandButton documentButton = new JCommandButton(this.resourceBundle.getString("Document.text"), new document_new());
        documentButton.setActionKeyTip("ND");
        actionBand.addCommandButton(documentButton, RibbonElementPriority.TOP);
        JCommandButton appointmentButton = new JCommandButton(this.resourceBundle.getString("Appointment.text"), new appointment_new());
        appointmentButton.setActionKeyTip("NP");
        actionBand.addCommandButton(appointmentButton, RibbonElementPriority.MEDIUM);
        JCommandButton bookmarkButton = new JCommandButton(this.resourceBundle.getString("Bookmark.text"), new bookmark_new());
        bookmarkButton.setActionKeyTip("NB");
        actionBand.addCommandButton(bookmarkButton, RibbonElementPriority.MEDIUM);
        JCommandButton contactButton = new JCommandButton(this.resourceBundle.getString("Contact.text"), new contact_new());
        contactButton.setActionKeyTip("NC");
        actionBand.addCommandButton(contactButton, RibbonElementPriority.MEDIUM);
        ArrayList<RibbonBandResizePolicy> resizePolicies = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)actionBand.getControlPanel()));
        resizePolicies.add(new CoreRibbonResizePolicies.Mid2Low((JBandControlPanel)actionBand.getControlPanel()));
        resizePolicies.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)actionBand.getControlPanel()));
        actionBand.setResizePolicies(resizePolicies);
        return actionBand;
    }

    protected JRibbonBand getPreferencesBand() {
        JRibbonBand preferencesBand = new JRibbonBand(this.resourceBundle.getString("Preferences.textBandTitle"), new preferences_desktop_font(), new ExpandActionListener());
        preferencesBand.setResizePolicies(CoreRibbonResizePolicies.getCorePoliciesRestrictive(preferencesBand));
        preferencesBand.startGroup();
        JCommandButton accessibility = new JCommandButton(this.resourceBundle.getString("Accessibility.text"), new preferences_desktop_accessibility());
        accessibility.setActionKeyTip("Y");
        preferencesBand.addCommandButton(accessibility, RibbonElementPriority.MEDIUM);
        JCommandButton assistiveTech = new JCommandButton(this.resourceBundle.getString("Assistive.text"), new preferences_desktop_assistive_technology());
        assistiveTech.setActionKeyTip("E");
        preferencesBand.addCommandButton(assistiveTech, RibbonElementPriority.MEDIUM);
        JCommandButton keyboardShortcuts = new JCommandButton(this.resourceBundle.getString("KeyboardShortcuts.text"), new preferences_desktop_keyboard_shortcuts());
        keyboardShortcuts.setPopupKeyTip("H");
        keyboardShortcuts.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        keyboardShortcuts.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                return new SamplePopupMenu();
            }
        });
        preferencesBand.addCommandButton(keyboardShortcuts, RibbonElementPriority.MEDIUM);
        preferencesBand.startGroup();
        JCommandButton size = new JCommandButton(this.resourceBundle.getString("Font.text"), new preferences_desktop_font());
        size.setActionKeyTip("Z");
        preferencesBand.addCommandButton(size, RibbonElementPriority.TOP);
        JCommandButton locale = new JCommandButton(this.resourceBundle.getString("Locale.text"), new preferences_desktop_locale());
        locale.setActionKeyTip("L");
        preferencesBand.addCommandButton(locale, RibbonElementPriority.TOP);
        preferencesBand.startGroup();
        JCommandButton screensaver = new JCommandButton(this.resourceBundle.getString("Screensaver.text"), new preferences_desktop_screensaver());
        screensaver.setActionKeyTip("V");
        preferencesBand.addCommandButton(screensaver, RibbonElementPriority.MEDIUM);
        JCommandButton themes = new JCommandButton(this.resourceBundle.getString("Themes.text"), new preferences_desktop_theme());
        themes.setActionKeyTip("T");
        preferencesBand.addCommandButton(themes, RibbonElementPriority.MEDIUM);
        return preferencesBand;
    }

    protected JRibbonBand getParagraphBand() {
        JRibbonBand paragraphBand = new JRibbonBand(this.resourceBundle.getString("Paragraph.textBandTitle"), new format_justify_left(), null);
        paragraphBand.startGroup(this.resourceBundle.getString("Indent.text"));
        JRibbonComponent justifyLeftWrapper = new JRibbonComponent(new format_justify_left(), this.resourceBundle.getString("IndentLeft.text"), new JSpinner(new SpinnerNumberModel(0, 0, 100, 5)));
        justifyLeftWrapper.setKeyTip("PL");
        RichTooltip justifyLeftTooltip = new RichTooltip();
        justifyLeftTooltip.setTitle(this.resourceBundle.getString("IndentLeft.tooltip.title"));
        justifyLeftTooltip.addDescriptionSection(this.resourceBundle.getString("IndentLeft.tooltip.actionParagraph1"));
        justifyLeftTooltip.addDescriptionSection(this.resourceBundle.getString("IndentLeft.tooltip.actionParagraph2"));
        justifyLeftWrapper.setRichTooltip(justifyLeftTooltip);
        paragraphBand.addRibbonComponent(justifyLeftWrapper);
        JRibbonComponent justifyRightWrapper = new JRibbonComponent(new format_justify_right(), this.resourceBundle.getString("IndentRight.text"), new JSpinner(new SpinnerNumberModel(0, 0, 100, 5)));
        justifyRightWrapper.setKeyTip("PR");
        RichTooltip justifyRightTooltip = new RichTooltip();
        justifyRightTooltip.setTitle(this.resourceBundle.getString("IndentRight.tooltip.title"));
        justifyRightTooltip.addDescriptionSection(this.resourceBundle.getString("IndentRight.tooltip.actionParagraph1"));
        justifyRightTooltip.addDescriptionSection(this.resourceBundle.getString("IndentRight.tooltip.actionParagraph2"));
        justifyRightWrapper.setRichTooltip(justifyRightTooltip);
        paragraphBand.addRibbonComponent(justifyRightWrapper);
        paragraphBand.startGroup(this.resourceBundle.getString("Spacing.text"));
        JRibbonComponent beforeWrapper = new JRibbonComponent(new JSpinner(new SpinnerNumberModel(0, 0, 100, 5)));
        beforeWrapper.setKeyTip("PB");
        paragraphBand.addRibbonComponent(beforeWrapper);
        JRibbonComponent afterWrapper = new JRibbonComponent(new JSpinner(new SpinnerNumberModel(10, 0, 100, 5)));
        afterWrapper.setKeyTip("PA");
        paragraphBand.addRibbonComponent(afterWrapper);
        return paragraphBand;
    }

    protected JRibbonBand getShowHideBand() {
        JRibbonBand showHideBand = new JRibbonBand(this.resourceBundle.getString("ShowHide.textBandTitle"), new format_justify_left(), null);
        JCheckBox ruler = new JCheckBox(this.resourceBundle.getString("Ruler.text"));
        ruler.setSelected(true);
        JRibbonComponent rulerWrapper = new JRibbonComponent(ruler);
        rulerWrapper.setKeyTip("SR");
        showHideBand.addRibbonComponent(rulerWrapper);
        JCheckBox gridlines = new JCheckBox(this.resourceBundle.getString("Gridlines.text"));
        JRibbonComponent gridlinesWrapper = new JRibbonComponent(gridlines);
        gridlinesWrapper.setKeyTip("SG");
        showHideBand.addRibbonComponent(gridlinesWrapper);
        JCheckBox messageBar = new JCheckBox(this.resourceBundle.getString("MessageBar.text"));
        messageBar.setEnabled(false);
        JRibbonComponent messageBarWrapper = new JRibbonComponent(messageBar);
        messageBarWrapper.setKeyTip("SM");
        showHideBand.addRibbonComponent(messageBarWrapper);
        JCheckBox documentMap = new JCheckBox(this.resourceBundle.getString("DocumentMap.text"));
        JRibbonComponent documentMapWrapper = new JRibbonComponent(documentMap);
        documentMapWrapper.setKeyTip("SD");
        showHideBand.addRibbonComponent(documentMapWrapper);
        JCheckBox thumbnails = new JCheckBox(this.resourceBundle.getString("Thumbnails.text"));
        JRibbonComponent thumbnailsWrapper = new JRibbonComponent(thumbnails);
        thumbnailsWrapper.setKeyTip("ST");
        showHideBand.addRibbonComponent(thumbnailsWrapper);
        return showHideBand;
    }

    protected JRibbonBand getApplicationsBand() {
        JRibbonBand applicationsBand = new JRibbonBand(this.resourceBundle.getString("Applications.textBandTitle"), new applications_other(), new ExpandActionListener());
        JRibbonComponent games = new JRibbonComponent(new applications_games(), this.resourceBundle.getString("Games.text"), new JComboBox<Object>(new Object[]{"Tetris", "Minesweeper", "Doom"}));
        games.setKeyTip("AG");
        games.setResizingAware(true);
        games.setHorizontalAlignment(HorizontalAlignment.FILL);
        applicationsBand.addRibbonComponent(games);
        JRibbonComponent internet = new JRibbonComponent(new applications_internet(), this.resourceBundle.getString("Internet.text"), new JComboBox<Object>(new Object[]{"Firefox", "Opera", "Konqueror"}));
        internet.setKeyTip("AI");
        internet.setEnabled(false);
        internet.setResizingAware(true);
        internet.setHorizontalAlignment(HorizontalAlignment.FILL);
        applicationsBand.addRibbonComponent(internet);
        JRibbonComponent multimedia = new JRibbonComponent(null, this.resourceBundle.getString("Multimedia.text"), new JComboBox<Object>(new Object[]{this.resourceBundle.getString("Pictures.text"), this.resourceBundle.getString("Video.text"), this.resourceBundle.getString("Audio.text")}));
        multimedia.setKeyTip("AM");
        multimedia.setResizingAware(true);
        multimedia.setHorizontalAlignment(HorizontalAlignment.FILL);
        applicationsBand.addRibbonComponent(multimedia);
        return applicationsBand;
    }

    protected JRibbonBand getDocumentBand() {
        JRibbonBand result = new JRibbonBand(this.resourceBundle.getString("Document.textBandTitle"), new applications_office(), new ExpandActionListener());
        result.setExpandButtonKeyTip("FY");
        result.setCollapsedStateKeyTip("ZD");
        result.startGroup();
        JCommandButton localFolderButton = new JCommandButton(this.resourceBundle.getString("DocumentLocal.text"), new folder());
        result.addCommandButton(localFolderButton, RibbonElementPriority.TOP);
        JCommandButton remoteFolderButton = new JCommandButton(this.resourceBundle.getString("DocumentRemote.text"), new folder_remote());
        result.addCommandButton(remoteFolderButton, RibbonElementPriority.TOP);
        JCommandButton savedFolderButton = new JCommandButton(this.resourceBundle.getString("DocumentSaved.text"), new folder_saved_search());
        result.addCommandButton(savedFolderButton, RibbonElementPriority.TOP);
        result.startGroup();
        JCommandButton docNewButton = new JCommandButton(this.resourceBundle.getString("DocumentNew.text"), new document_new());
        result.addCommandButton(docNewButton, RibbonElementPriority.MEDIUM);
        JCommandButton docOpenButton = new JCommandButton(this.resourceBundle.getString("DocumentOpen.text"), new document_open());
        result.addCommandButton(docOpenButton, RibbonElementPriority.MEDIUM);
        JCommandButton docSaveButton = new JCommandButton(this.resourceBundle.getString("DocumentSave.text"), new document_save());
        result.addCommandButton(docSaveButton, RibbonElementPriority.MEDIUM);
        JCommandButton docPrintButton = new JCommandButton(this.resourceBundle.getString("DocumentPrint.text"), new document_print());
        result.addCommandButton(docPrintButton, RibbonElementPriority.MEDIUM);
        JCommandButton docPrintPreviewButton = new JCommandButton(this.resourceBundle.getString("DocumentPrintPreview.text"), new document_print_preview());
        result.addCommandButton(docPrintPreviewButton, RibbonElementPriority.MEDIUM);
        JCommandButton docPropertiesButton = new JCommandButton(this.resourceBundle.getString("DocumentProperties.text"), new document_properties());
        result.addCommandButton(docPropertiesButton, RibbonElementPriority.MEDIUM);
        result.setResizePolicies(CoreRibbonResizePolicies.getCorePoliciesRestrictive(result));
        return result;
    }

    protected JRibbonBand getClipboardBand() {
        JRibbonBand clipboardBand = new JRibbonBand(this.resourceBundle.getString("Clipboard.textBandTitle"), new edit_paste(), new ExpandActionListener());
        clipboardBand.setExpandButtonKeyTip("FO");
        RichTooltip expandRichTooltip = new RichTooltip();
        expandRichTooltip.setTitle(this.resourceBundle.getString("Clipboard.textBandTitle"));
        expandRichTooltip.addDescriptionSection(this.resourceBundle.getString("Clipboard.textBandTooltipParagraph1"));
        clipboardBand.setExpandButtonRichTooltip(expandRichTooltip);
        clipboardBand.setCollapsedStateKeyTip("ZC");
        JCommandButton mainButton = new JCommandButton(this.resourceBundle.getString("Paste.text"), new edit_paste());
        mainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Pasted!");
            }
        });
        mainButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                return new SamplePopupMenu();
            }
        });
        mainButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        RichTooltip mainRichTooltip = new RichTooltip();
        mainRichTooltip.setTitle(this.resourceBundle.getString("Paste.text"));
        mainRichTooltip.addDescriptionSection(this.resourceBundle.getString("Paste.tooltip.actionParagraph1"));
        mainButton.setActionRichTooltip(mainRichTooltip);
        mainButton.setPopupKeyTip("V");
        RichTooltip mainPopupRichTooltip = new RichTooltip();
        mainPopupRichTooltip.setTitle(this.resourceBundle.getString("Paste.text"));
        mainPopupRichTooltip.addDescriptionSection(this.resourceBundle.getString("Paste.tooltip.popupParagraph1"));
        mainButton.setPopupRichTooltip(mainPopupRichTooltip);
        clipboardBand.addCommandButton(mainButton, RibbonElementPriority.TOP);
        JCommandButton cutButton = new JCommandButton(this.resourceBundle.getString("Cut.text"), new edit_cut());
        cutButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                return new SamplePopupMenu();
            }
        });
        cutButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        RichTooltip cutRichTooltip = new RichTooltip();
        cutRichTooltip.setTitle(this.resourceBundle.getString("Cut.text"));
        cutRichTooltip.addDescriptionSection(this.resourceBundle.getString("Cut.tooltip.actionParagraph1"));
        cutButton.setActionRichTooltip(cutRichTooltip);
        cutButton.setPopupKeyTip("X");
        clipboardBand.addCommandButton(cutButton, RibbonElementPriority.MEDIUM);
        JCommandButton copyButton = new JCommandButton(this.resourceBundle.getString("Copy.text"), new edit_copy());
        copyButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                return new SamplePopupMenu();
            }
        });
        copyButton.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
        copyButton.setPopupKeyTip("C");
        clipboardBand.addCommandButton(copyButton, RibbonElementPriority.MEDIUM);
        JCommandButton formatButton = new JCommandButton(this.resourceBundle.getString("Format.text"), new edit_paste());
        formatButton.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                JCommandPopupMenu popupMenu = new JCommandPopupMenu(new QuickStylesPanel(), 5, 3);
                JCommandMenuButton saveSelectionButton = new JCommandMenuButton(BasicCheckRibbon.this.resourceBundle.getString("Format.menuSaveSelection.text"), new EmptyResizableIcon(16));
                saveSelectionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Save Selection activated");
                    }
                });
                saveSelectionButton.setActionKeyTip("SS");
                popupMenu.addMenuButton(saveSelectionButton);
                JCommandMenuButton clearSelectionButton = new JCommandMenuButton(BasicCheckRibbon.this.resourceBundle.getString("Format.menuClearSelection.text"), new EmptyResizableIcon(16));
                clearSelectionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Clear Selection activated");
                    }
                });
                clearSelectionButton.setActionKeyTip("SC");
                popupMenu.addMenuButton(clearSelectionButton);
                popupMenu.addMenuSeparator();
                JCommandMenuButton applyStylesButton = new JCommandMenuButton(BasicCheckRibbon.this.resourceBundle.getString("Format.applyStyles.text"), new EmptyResizableIcon(16));
                applyStylesButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Apply Styles activated");
                    }
                });
                applyStylesButton.setActionKeyTip("SA");
                popupMenu.addMenuButton(applyStylesButton);
                return popupMenu;
            }
        });
        formatButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        formatButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        formatButton.setPopupKeyTip("FP");
        clipboardBand.addCommandButton(formatButton, RibbonElementPriority.MEDIUM);
        ArrayList<RibbonBandResizePolicy> resizePolicies = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)clipboardBand.getControlPanel()));
        resizePolicies.add(new CoreRibbonResizePolicies.Mid2Low((JBandControlPanel)clipboardBand.getControlPanel()));
        clipboardBand.setResizePolicies(resizePolicies);
        return clipboardBand;
    }

    protected JRibbonBand getFindBand() {
        JRibbonBand findBand = new JRibbonBand(this.resourceBundle.getString("Find.textBandTitle"), new edit_find());
        findBand.setCollapsedStateKeyTip("ZY");
        JCommandToggleButton findButton = new JCommandToggleButton(this.resourceBundle.getString("Find.text"), new system_search());
        findButton.setActionKeyTip("FD");
        findBand.addCommandButton(findButton, RibbonElementPriority.TOP);
        JCommandToggleButton replaceButton = new JCommandToggleButton(this.resourceBundle.getString("Find.text"), new edit_find());
        findBand.addCommandButton(replaceButton, RibbonElementPriority.MEDIUM);
        JCommandToggleButton findReplaceButton = new JCommandToggleButton(this.resourceBundle.getString("FindReplace.text"), new edit_find_replace());
        findReplaceButton.setEnabled(false);
        findBand.addCommandButton(findReplaceButton, RibbonElementPriority.MEDIUM);
        JCommandToggleButton selectAllButton = new JCommandToggleButton(this.resourceBundle.getString("SelectAll.text"), new edit_select_all());
        findBand.addCommandButton(selectAllButton, RibbonElementPriority.MEDIUM);
        ArrayList<RibbonBandResizePolicy> resizePolicies = new ArrayList<RibbonBandResizePolicy>();
        resizePolicies.add(new CoreRibbonResizePolicies.Mirror((JBandControlPanel)findBand.getControlPanel()));
        resizePolicies.add(new IconRibbonBandResizePolicy((AbstractBandControlPanel)findBand.getControlPanel()));
        findBand.setResizePolicies(resizePolicies);
        return findBand;
    }

    protected JRibbonBand getQuickStylesBand() {
        JRibbonBand quickStylesBand = new JRibbonBand(this.resourceBundle.getString("QuickStyles.textBandTitle"), new preferences_desktop_theme());
        quickStylesBand.setCollapsedStateKeyTip("ZS");
        quickStylesBand.setResizePolicies(CoreRibbonResizePolicies.getCorePoliciesRestrictive(quickStylesBand));
        HashMap<RibbonElementPriority, Integer> stylesGalleryVisibleButtonCounts = new HashMap<RibbonElementPriority, Integer>();
        stylesGalleryVisibleButtonCounts.put(RibbonElementPriority.LOW, 1);
        stylesGalleryVisibleButtonCounts.put(RibbonElementPriority.MEDIUM, 2);
        stylesGalleryVisibleButtonCounts.put(RibbonElementPriority.TOP, 2);
        ArrayList<StringValuePair<List<JCommandToggleButton>>> stylesGalleryButtons = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
        ArrayList<JCommandToggleButton> stylesGalleryButtonsList = new ArrayList<JCommandToggleButton>();
        ArrayList<JCommandToggleButton> stylesGalleryButtonsList2 = new ArrayList<JCommandToggleButton>();
        MessageFormat mfButtonText = new MessageFormat(this.resourceBundle.getString("StylesGallery.textButton"));
        mfButtonText.setLocale(this.currLocale);
        int i = 0;
        while (i < 30) {
            final int index = i;
            font_x_generic fontIcon = new font_x_generic();
            DecoratedResizableIcon finalIcon = new DecoratedResizableIcon(fontIcon, new DecoratedResizableIcon.IconDecorator(){

                @Override
                public void paintIconDecoration(Component c, Graphics g, int x, int y, int width, int height) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setColor(Color.black);
                    RenderingUtils.installDesktopHints(g2d);
                    g2d.setFont(UIManager.getFont("Label.font"));
                    g2d.drawString("" + index, x + 2, y + height - 2);
                    g2d.dispose();
                }
            });
            JCommandToggleButton jrb = new JCommandToggleButton(mfButtonText.format(new Object[]{i}), finalIcon);
            if (i == 1) {
                jrb.getActionModel().setSelected(true);
            }
            jrb.setName("Style " + i);
            jrb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Invoked action on " + index);
                }
            });
            if (i < 10) {
                stylesGalleryButtonsList.add(jrb);
            } else {
                stylesGalleryButtonsList2.add(jrb);
            }
            ++i;
        }
        stylesGalleryButtons.add(new StringValuePair(this.resourceBundle.getString("StylesGallery.textGroupTitle1"), stylesGalleryButtonsList));
        stylesGalleryButtons.add(new StringValuePair(this.resourceBundle.getString("StylesGallery.textGroupTitle2"), stylesGalleryButtonsList2));
        quickStylesBand.addRibbonGallery("Styles", stylesGalleryButtons, stylesGalleryVisibleButtonCounts, 3, 3, JRibbonBand.BIG_FIXED_LANDSCAPE, RibbonElementPriority.TOP);
        quickStylesBand.setRibbonGalleryPopupCallback("Styles", new JRibbonBand.RibbonGalleryPopupCallback(){

            @Override
            public void popupToBeShown(JCommandPopupMenu menu) {
                JCommandMenuButton saveSelectionButton = new JCommandMenuButton(BasicCheckRibbon.this.resourceBundle.getString("Format.menuSaveSelection.text"), new EmptyResizableIcon(16));
                saveSelectionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Save Selection activated");
                    }
                });
                saveSelectionButton.setActionKeyTip("SS");
                menu.addMenuButton(saveSelectionButton);
                JCommandMenuButton clearSelectionButton = new JCommandMenuButton(BasicCheckRibbon.this.resourceBundle.getString("Format.menuClearSelection.text"), new EmptyResizableIcon(16));
                clearSelectionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Clear Selection activated");
                    }
                });
                clearSelectionButton.setActionKeyTip("SC");
                menu.addMenuButton(clearSelectionButton);
                menu.addMenuSeparator();
                JCommandMenuButton applyStylesButton = new JCommandMenuButton(BasicCheckRibbon.this.resourceBundle.getString("Format.applyStyles.text"), new font_x_generic());
                applyStylesButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Apply Styles activated");
                    }
                });
                applyStylesButton.setActionKeyTip("SA");
                menu.addMenuButton(applyStylesButton);
            }
        });
        quickStylesBand.setRibbonGalleryExpandKeyTip("Styles", "L");
        JCommandButton stylesButton1 = new JCommandButton(this.resourceBundle.getString("Styles1.text"), new font_x_generic());
        stylesButton1.setActionKeyTip("SA");
        quickStylesBand.addCommandButton(stylesButton1, RibbonElementPriority.MEDIUM);
        JCommandButton styles2Button = new JCommandButton(this.resourceBundle.getString("Styles2.text"), new image_x_generic());
        styles2Button.setActionKeyTip("SB");
        quickStylesBand.addCommandButton(styles2Button, RibbonElementPriority.MEDIUM);
        styles2Button.setEnabled(false);
        JCommandButton styles3Button = new JCommandButton(this.resourceBundle.getString("Styles3.text"), new text_html());
        styles3Button.setActionKeyTip("SC");
        quickStylesBand.addCommandButton(styles3Button, RibbonElementPriority.MEDIUM);
        return quickStylesBand;
    }

    protected JRibbonBand getPreviewBand() {
        JRibbonBand previewBand = new JRibbonBand(this.resourceBundle.getString("Preview.textBandTitle"), new SimpleResizableIcon(RibbonElementPriority.TOP, 32, 32));
        previewBand.setResizePolicies(CoreRibbonResizePolicies.getCorePoliciesNone(previewBand));
        JCommandButton findButton = new JCommandButton(this.resourceBundle.getString("Preview.text"), new SimpleResizableIcon(RibbonElementPriority.TOP, 32, 32));
        previewBand.addCommandButton(findButton, RibbonElementPriority.TOP);
        JCommandButton slideShowButton = new JCommandButton(this.resourceBundle.getString("SlideShow.text"), new SimpleResizableIcon(RibbonElementPriority.TOP, 32, 32));
        previewBand.addCommandButton(slideShowButton, RibbonElementPriority.TOP);
        return previewBand;
    }

    protected JRibbonBand getRowSpanBand() {
        JRibbonBand rowSpanBand = new JRibbonBand(this.resourceBundle.getString("RowSpans.textBandTitle"), new SimpleResizableIcon(RibbonElementPriority.TOP, 32, 32));
        JTextPane textPane1 = new JTextPane();
        textPane1.setText(this.resourceBundle.getString("ThreeRows.text"));
        JScrollPane scrollPane1 = new JScrollPane(textPane1);
        scrollPane1.setPreferredSize(new Dimension(120, 100));
        JRibbonComponent text1 = new JRibbonComponent(scrollPane1);
        rowSpanBand.addRibbonComponent(text1, 3);
        JRibbonComponent text2 = new JRibbonComponent(new JTextField(this.resourceBundle.getString("OneRow.text"), 8));
        rowSpanBand.addRibbonComponent(text2, 1);
        JTextPane textPane3 = new JTextPane();
        textPane3.setText(this.resourceBundle.getString("TwoRows.text"));
        JScrollPane scrollPane3 = new JScrollPane(textPane3);
        scrollPane3.setPreferredSize(new Dimension(80, 100));
        JRibbonComponent text3 = new JRibbonComponent(scrollPane3);
        rowSpanBand.addRibbonComponent(text3, 2);
        JTextPane textPane4 = new JTextPane();
        textPane4.setText(this.resourceBundle.getString("TwoRows.text"));
        JScrollPane scrollPane4 = new JScrollPane(textPane4);
        scrollPane4.setPreferredSize(new Dimension(80, 100));
        JRibbonComponent text4 = new JRibbonComponent(scrollPane4);
        rowSpanBand.addRibbonComponent(text4, 2);
        JRibbonComponent text5 = new JRibbonComponent(new JTextField(this.resourceBundle.getString("OneRow.text"), 8));
        rowSpanBand.addRibbonComponent(text5, 1);
        JTextPane textPane6 = new JTextPane();
        textPane6.setText(this.resourceBundle.getString("TwoRows.text"));
        JScrollPane scrollPane6 = new JScrollPane(textPane6);
        scrollPane6.setPreferredSize(new Dimension(80, 100));
        JRibbonComponent text6 = new JRibbonComponent(scrollPane6);
        rowSpanBand.addRibbonComponent(text6, 2);
        JTextPane textPane7 = new JTextPane();
        textPane7.setText(this.resourceBundle.getString("TwoRows.text"));
        JScrollPane scrollPane7 = new JScrollPane(textPane7);
        scrollPane7.setPreferredSize(new Dimension(80, 100));
        JRibbonComponent text7 = new JRibbonComponent(scrollPane7);
        rowSpanBand.addRibbonComponent(text7, 2);
        rowSpanBand.setResizePolicies(CoreRibbonResizePolicies.getCorePoliciesNone(rowSpanBand));
        return rowSpanBand;
    }

    protected JRibbonBand getAlignmentBand() {
        JRibbonBand alignmentBand = new JRibbonBand(this.resourceBundle.getString("Alignment.textTaskTitle"), new format_justify_left(), null);
        alignmentBand.startGroup();
        JRibbonComponent wideWrapper1 = new JRibbonComponent(new JLabel(this.resourceBundle.getString("VeryLong.text")));
        alignmentBand.addRibbonComponent(wideWrapper1);
        JRibbonComponent alignLeadingWrapper1 = new JRibbonComponent(null, this.resourceBundle.getString("Leading.text"), new JSpinner(new SpinnerNumberModel(0, 0, 100, 5)));
        alignLeadingWrapper1.setHorizontalAlignment(HorizontalAlignment.LEADING);
        alignmentBand.addRibbonComponent(alignLeadingWrapper1);
        JRibbonComponent alignTrailingWrapper1 = new JRibbonComponent(null, this.resourceBundle.getString("Trailing.text"), new JSpinner(new SpinnerNumberModel(0, 0, 100, 5)));
        alignTrailingWrapper1.setHorizontalAlignment(HorizontalAlignment.TRAILING);
        alignmentBand.addRibbonComponent(alignTrailingWrapper1);
        JRibbonComponent wideWrapper2 = new JRibbonComponent(new JLabel(this.resourceBundle.getString("VeryLong.text")));
        alignmentBand.addRibbonComponent(wideWrapper2);
        JRibbonComponent alignCenterWrapper1 = new JRibbonComponent(null, this.resourceBundle.getString("Center.text"), new JSpinner(new SpinnerNumberModel(0, 0, 100, 5)));
        alignCenterWrapper1.setHorizontalAlignment(HorizontalAlignment.CENTER);
        alignmentBand.addRibbonComponent(alignCenterWrapper1);
        JRibbonComponent alignFillWrapper1 = new JRibbonComponent(null, this.resourceBundle.getString("Fill.text"), new JSpinner(new SpinnerNumberModel(0, 0, 100, 5)));
        alignFillWrapper1.setHorizontalAlignment(HorizontalAlignment.FILL);
        alignmentBand.addRibbonComponent(alignFillWrapper1);
        alignmentBand.startGroup();
        JRibbonComponent wideWrapper3 = new JRibbonComponent(new JLabel(this.resourceBundle.getString("Long.text")));
        alignmentBand.addRibbonComponent(wideWrapper3);
        JRibbonComponent alignLeadingWrapper2 = new JRibbonComponent(new JSpinner(new SpinnerNumberModel(0, 0, 100, 5)));
        alignLeadingWrapper2.setHorizontalAlignment(HorizontalAlignment.LEADING);
        alignmentBand.addRibbonComponent(alignLeadingWrapper2);
        JRibbonComponent alignTrailingWrapper2 = new JRibbonComponent(new JSpinner(new SpinnerNumberModel(0, 0, 100, 5)));
        alignTrailingWrapper2.setHorizontalAlignment(HorizontalAlignment.TRAILING);
        alignmentBand.addRibbonComponent(alignTrailingWrapper2);
        JRibbonComponent wideWrapper4 = new JRibbonComponent(new JLabel(this.resourceBundle.getString("Long.text")));
        alignmentBand.addRibbonComponent(wideWrapper4);
        JRibbonComponent alignCenterWrapper2 = new JRibbonComponent(new JSpinner(new SpinnerNumberModel(0, 0, 100, 5)));
        alignCenterWrapper2.setHorizontalAlignment(HorizontalAlignment.CENTER);
        alignmentBand.addRibbonComponent(alignCenterWrapper2);
        JRibbonComponent alignFillWrapper2 = new JRibbonComponent(new JSpinner(new SpinnerNumberModel(0, 0, 100, 5)));
        alignFillWrapper2.setHorizontalAlignment(HorizontalAlignment.FILL);
        alignmentBand.addRibbonComponent(alignFillWrapper2);
        return alignmentBand;
    }

    protected JRibbonBand getAnimationBand() {
        JRibbonBand animationBand = new JRibbonBand(this.resourceBundle.getString("Animation.textBandTitle"), new SimpleResizableIcon(RibbonElementPriority.TOP, 32, 32));
        JCommandButton button1 = new JCommandButton(this.resourceBundle.getString("CustomAnimation.text"), new SimpleResizableIcon(RibbonElementPriority.TOP, 32, 32));
        animationBand.addCommandButton(button1, RibbonElementPriority.TOP);
        JCommandButton button2 = new JCommandButton(this.resourceBundle.getString("CustomAnimation.text"), new SimpleResizableIcon(RibbonElementPriority.TOP, 32, 32));
        animationBand.addCommandButton(button2, RibbonElementPriority.TOP);
        JCommandButton button3 = new JCommandButton(this.resourceBundle.getString("CustomAnimation.text"), new SimpleResizableIcon(RibbonElementPriority.TOP, 32, 32));
        animationBand.addCommandButton(button3, RibbonElementPriority.TOP);
        animationBand.setResizePolicies(CoreRibbonResizePolicies.getCorePoliciesNone(animationBand));
        return animationBand;
    }

    protected JRibbonBand getTransitionBand() {
        JRibbonBand transitionBand = new JRibbonBand(this.resourceBundle.getString("TransitionToThis.textBandTitle"), new SimpleResizableIcon(RibbonElementPriority.TOP, 32, 32));
        HashMap<RibbonElementPriority, Integer> transitionGalleryVisibleButtonCounts = new HashMap<RibbonElementPriority, Integer>();
        transitionGalleryVisibleButtonCounts.put(RibbonElementPriority.LOW, 2);
        transitionGalleryVisibleButtonCounts.put(RibbonElementPriority.MEDIUM, 4);
        transitionGalleryVisibleButtonCounts.put(RibbonElementPriority.TOP, 6);
        ArrayList<StringValuePair<List<JCommandToggleButton>>> transitionGalleryButtons = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
        ArrayList<JCommandToggleButton> transitionGalleryButtonsList = new ArrayList<JCommandToggleButton>();
        int i = 1;
        while (i <= 40) {
            final int index = i++;
            appointment_new mainIcon = new appointment_new();
            DecoratedResizableIcon finalIcon = new DecoratedResizableIcon(mainIcon, new DecoratedResizableIcon.IconDecorator(){

                @Override
                public void paintIconDecoration(Component c, Graphics g, int x, int y, int width, int height) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    RenderingUtils.installDesktopHints(g2d);
                    g2d.setFont(UIManager.getFont("Label.font").deriveFont(9.0f));
                    g2d.setColor(Color.black);
                    g2d.drawString("" + index, x + 1, y + height - 2);
                    g2d.drawString("" + index, x + 3, y + height - 2);
                    g2d.drawString("" + index, x + 2, y + height - 1);
                    g2d.drawString("" + index, x + 2, y + height - 3);
                    g2d.setColor(Color.white);
                    g2d.drawString("" + index, x + 2, y + height - 2);
                    g2d.dispose();
                }
            });
            JCommandToggleButton button = new JCommandToggleButton("", finalIcon);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Activated action " + index);
                }
            });
            button.setHorizontalAlignment(0);
            transitionGalleryButtonsList.add(button);
        }
        transitionGalleryButtons.add(new StringValuePair(this.resourceBundle.getString("TransitionGallery.textGroupTitle1"), transitionGalleryButtonsList));
        ArrayList<JCommandToggleButton> transitionGalleryButtonsList2 = new ArrayList<JCommandToggleButton>();
        int i2 = 41;
        while (i2 <= 70) {
            final int index = i2++;
            appointment_new mainIcon = new appointment_new();
            DecoratedResizableIcon finalIcon = new DecoratedResizableIcon(mainIcon, new DecoratedResizableIcon.IconDecorator(){

                @Override
                public void paintIconDecoration(Component c, Graphics g, int x, int y, int width, int height) {
                    Graphics2D g2d = (Graphics2D)g.create();
                    RenderingUtils.installDesktopHints(g2d);
                    g2d.setFont(UIManager.getFont("Label.font").deriveFont(9.0f));
                    g2d.setColor(Color.black);
                    g2d.drawString("" + index, x + 1, y + height - 2);
                    g2d.drawString("" + index, x + 3, y + height - 2);
                    g2d.drawString("" + index, x + 2, y + height - 1);
                    g2d.drawString("" + index, x + 2, y + height - 3);
                    g2d.setColor(Color.white);
                    g2d.drawString("" + index, x + 2, y + height - 2);
                    g2d.dispose();
                }
            });
            JCommandToggleButton button = new JCommandToggleButton("", finalIcon);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Activated action " + index);
                }
            });
            button.setHorizontalAlignment(0);
            transitionGalleryButtonsList2.add(button);
        }
        transitionGalleryButtons.add(new StringValuePair(this.resourceBundle.getString("TransitionGallery.textGroupTitle2"), transitionGalleryButtonsList2));
        transitionBand.addRibbonGallery("Transitions", transitionGalleryButtons, transitionGalleryVisibleButtonCounts, 6, 6, CommandButtonDisplayState.SMALL, RibbonElementPriority.TOP);
        transitionBand.startGroup();
        transitionBand.addRibbonComponent(new JRibbonComponent(new SimpleResizableIcon(RibbonElementPriority.TOP, 16, 16), this.resourceBundle.getString("Sound.text"), new JComboBox<Object>(new Object[]{"[" + this.resourceBundle.getString("NoSound.text") + "]     "})));
        transitionBand.addRibbonComponent(new JRibbonComponent(null, this.resourceBundle.getString("Speed.text"), new JComboBox<Object>(new Object[]{String.valueOf(this.resourceBundle.getString("Medium.text")) + "           "})));
        JCommandButton applyToAll = new JCommandButton(this.resourceBundle.getString("ApplyToAll.text"), new SimpleResizableIcon(RibbonElementPriority.TOP, 16, 16));
        applyToAll.setDisplayState(CommandButtonDisplayState.MEDIUM);
        applyToAll.setVGapScaleFactor(0.5);
        transitionBand.addRibbonComponent(new JRibbonComponent(applyToAll));
        return transitionBand;
    }

    protected JRibbonBand getTransitionNextBand() {
        JRibbonBand transitionBand = new JRibbonBand(this.resourceBundle.getString("TransitionToNext.textBandTitle"), new SimpleResizableIcon(RibbonElementPriority.TOP, 32, 32));
        JCheckBox mouseClick = new JCheckBox(this.resourceBundle.getString("OnMouseClick.text"));
        mouseClick.setSelected(true);
        JRibbonComponent mouseClickWrapper = new JRibbonComponent(mouseClick);
        transitionBand.addRibbonComponent(mouseClickWrapper);
        JCheckBox autoAfter = new JCheckBox(this.resourceBundle.getString("AutoAfter.text"));
        JRibbonComponent autoAfterWrapper = new JRibbonComponent(autoAfter);
        transitionBand.addRibbonComponent(autoAfterWrapper);
        transitionBand.addRibbonComponent(new JRibbonComponent(new SimpleResizableIcon(RibbonElementPriority.TOP, 16, 16), "", new JSpinner(new SpinnerDateModel())));
        return transitionBand;
    }

    public BasicCheckRibbon() {
        this.setApplicationIcon(new applications_internet());
        this.currLocale = Locale.getDefault();
        this.resourceBundle = ResourceBundle.getBundle("test.resource.Resources", this.currLocale);
        this.setTitle(this.resourceBundle.getString("Frame.title"));
    }

    public void configureRibbon() {
        JRibbonBand clipboardBand = this.getClipboardBand();
        JRibbonBand quickStylesBand = this.getQuickStylesBand();
        JFlowRibbonBand fontBand = this.getFontBand();
        JRibbonBand documentBand = this.getDocumentBand();
        JRibbonBand findBand = this.getFindBand();
        RibbonTask pageLayoutTask = new RibbonTask(this.resourceBundle.getString("PageLayout.textTaskTitle"), clipboardBand, quickStylesBand, fontBand, documentBand, findBand);
        pageLayoutTask.setKeyTip("P");
        JRibbonBand actionBand = this.getActionBand();
        JRibbonBand preferencesBand = this.getPreferencesBand();
        JRibbonBand arrangeBand = this.getApplicationsBand();
        this.paragraphBand = this.getParagraphBand();
        JRibbonBand showHideBand = this.getShowHideBand();
        RibbonTask writeTask = new RibbonTask(this.resourceBundle.getString("Write.textTaskTitle"), actionBand, preferencesBand, arrangeBand, this.paragraphBand, showHideBand);
        writeTask.setResizeSequencingPolicy(new CoreRibbonResizeSequencingPolicies.CollapseFromLast(writeTask));
        writeTask.setKeyTip("W");
        JRibbonBand previewBand = this.getPreviewBand();
        JRibbonBand animationBand = this.getAnimationBand();
        JRibbonBand transitionBand = this.getTransitionBand();
        JRibbonBand transitionNextBand = this.getTransitionNextBand();
        RibbonTask animationsTask = new RibbonTask(this.resourceBundle.getString("Animations.textTaskTitle"), previewBand, animationBand, transitionBand, transitionNextBand);
        animationsTask.setKeyTip("A");
        JRibbonBand rowSpanBand = this.getRowSpanBand();
        JRibbonBand alignmentBand = this.getAlignmentBand();
        RibbonTask wrappedTask = new RibbonTask(this.resourceBundle.getString("Wrapped.textTaskTitle"), rowSpanBand, alignmentBand);
        wrappedTask.setKeyTip("R");
        this.getRibbon().addTask(pageLayoutTask);
        this.getRibbon().addTask(writeTask);
        this.getRibbon().addTask(animationsTask);
        this.getRibbon().addTask(wrappedTask);
        this.getRibbon().configureHelp(new help_browser(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(BasicCheckRibbon.this, "Help button clicked");
            }
        });
        this.group1 = new RibbonContextualTaskGroup(this.resourceBundle.getString("Group1.textTaskGroupTitle"), Color.red, this.getContextualRibbonTask(this.resourceBundle.getString("Task11.textTaskTitle"), "XA"), this.getContextualRibbonTask(this.resourceBundle.getString("Task12.textTaskTitle"), "XB"));
        this.group2 = new RibbonContextualTaskGroup(this.resourceBundle.getString("Group2.textTaskGroupTitle"), Color.green, this.getContextualRibbonTask(this.resourceBundle.getString("Task21.textTaskTitle"), "YA"));
        this.getRibbon().addContextualTaskGroup(this.group1);
        this.getRibbon().addContextualTaskGroup(this.group2);
        this.configureTaskBar();
        this.configureApplicationMenu();
        JPanel controlPanel = new JPanel();
        controlPanel.setBorder(new EmptyBorder(20, 0, 0, 5));
        FormLayout lm = new FormLayout("right:pref, 4dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(lm, controlPanel);
        this.configureControlPanel(builder);
        this.add((Component)controlPanel, "East");
        this.add((Component)new RulerPanel(), "Center");
        this.configureStatusBar();
    }

    protected void configureTaskBar() {
        JCommandButton taskbarButtonPaste = new JCommandButton("", new edit_paste());
        taskbarButtonPaste.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        taskbarButtonPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Taskbar Paste activated");
            }
        });
        taskbarButtonPaste.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                return new SamplePopupMenu();
            }
        });
        taskbarButtonPaste.setActionRichTooltip(new RichTooltip(this.resourceBundle.getString("Paste.text"), this.resourceBundle.getString("Paste.tooltip.actionParagraph1")));
        taskbarButtonPaste.setPopupRichTooltip(new RichTooltip(this.resourceBundle.getString("Paste.text"), this.resourceBundle.getString("Paste.tooltip.popupParagraph1")));
        taskbarButtonPaste.setActionKeyTip("1");
        this.getRibbon().addTaskbarComponent(taskbarButtonPaste);
        JCommandButton taskbarButtonClear = new JCommandButton("", new edit_clear());
        taskbarButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Taskbar Clear activated");
            }
        });
        taskbarButtonClear.setEnabled(false);
        taskbarButtonClear.setActionKeyTip("2");
        this.getRibbon().addTaskbarComponent(taskbarButtonClear);
        JCommandButton taskbarButtonCopy = new JCommandButton("", new edit_copy());
        taskbarButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Taskbar Copy activated");
            }
        });
        taskbarButtonCopy.setActionKeyTip("3");
        this.getRibbon().addTaskbarComponent(taskbarButtonCopy);
        this.getRibbon().addTaskbarComponent(new JSeparator(1));
        JCommandButton taskbarButtonFind = new JCommandButton("", new edit_find());
        taskbarButtonFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Taskbar Find activated");
            }
        });
        taskbarButtonFind.setActionKeyTip("4");
        this.getRibbon().addTaskbarComponent(taskbarButtonFind);
    }

    protected void configureApplicationMenu() {
        RibbonApplicationMenuEntryPrimary amEntryNew = new RibbonApplicationMenuEntryPrimary(new document_new(), this.resourceBundle.getString("AppMenuNew.text"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Invoked creating new document");
            }
        }, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntryNew.setActionKeyTip("N");
        RibbonApplicationMenuEntryPrimary amEntryOpen = new RibbonApplicationMenuEntryPrimary(new document_open(), this.resourceBundle.getString("AppMenuOpen.text"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Invoked opening document");
            }
        }, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntryOpen.setRolloverCallback(new RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback(){

            @Override
            public void menuEntryActivated(JPanel targetPanel) {
                targetPanel.removeAll();
                JCommandButtonPanel openHistoryPanel = new JCommandButtonPanel(CommandButtonDisplayState.MEDIUM);
                String groupName = BasicCheckRibbon.this.resourceBundle.getString("AppMenuOpen.secondary.textGroupTitle1");
                openHistoryPanel.addButtonGroup(groupName);
                MessageFormat mf = new MessageFormat(BasicCheckRibbon.this.resourceBundle.getString("AppMenuOpen.secondary.textButton"));
                mf.setLocale(BasicCheckRibbon.this.currLocale);
                int i = 0;
                while (i < 5) {
                    JCommandButton historyButton = new JCommandButton(mf.format(new Object[]{i}), new text_html());
                    historyButton.setHorizontalAlignment(2);
                    openHistoryPanel.addButtonToLastGroup(historyButton);
                    ++i;
                }
                openHistoryPanel.setMaxButtonColumns(1);
                targetPanel.setLayout(new BorderLayout());
                targetPanel.add((Component)openHistoryPanel, "Center");
            }
        });
        amEntryOpen.setActionKeyTip("O");
        RibbonApplicationMenuEntryPrimary amEntrySave = new RibbonApplicationMenuEntryPrimary(new document_save(), this.resourceBundle.getString("AppMenuSave.text"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Invoked saving document");
            }
        }, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntrySave.setEnabled(false);
        amEntrySave.setActionKeyTip("S");
        RibbonApplicationMenuEntryPrimary amEntrySaveAs = new RibbonApplicationMenuEntryPrimary(new document_save_as(), this.resourceBundle.getString("AppMenuSaveAs.text"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Invoked saving document as");
            }
        }, JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        amEntrySaveAs.setActionKeyTip("A");
        amEntrySaveAs.setPopupKeyTip("F");
        RibbonApplicationMenuEntrySecondary amEntrySaveAsWord = new RibbonApplicationMenuEntrySecondary(new x_office_document(), this.resourceBundle.getString("AppMenuSaveAs.word.text"), null, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntrySaveAsWord.setDescriptionText(this.resourceBundle.getString("AppMenuSaveAs.word.description"));
        amEntrySaveAsWord.setActionKeyTip("W");
        RibbonApplicationMenuEntrySecondary amEntrySaveAsHtml = new RibbonApplicationMenuEntrySecondary(new text_html(), this.resourceBundle.getString("AppMenuSaveAs.html.text"), null, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntrySaveAsHtml.setDescriptionText(this.resourceBundle.getString("AppMenuSaveAs.html.description"));
        amEntrySaveAsHtml.setEnabled(false);
        amEntrySaveAsHtml.setActionKeyTip("H");
        RibbonApplicationMenuEntrySecondary amEntrySaveAsOtherFormats = new RibbonApplicationMenuEntrySecondary(new document_save_as(), this.resourceBundle.getString("AppMenuSaveAs.other.text"), null, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntrySaveAsOtherFormats.setDescriptionText(this.resourceBundle.getString("AppMenuSaveAs.other.description"));
        amEntrySaveAsOtherFormats.setActionKeyTip("O");
        amEntrySaveAs.addSecondaryMenuGroup(this.resourceBundle.getString("AppMenuSaveAs.secondary.textGroupTitle1"), amEntrySaveAsWord, amEntrySaveAsHtml, amEntrySaveAsOtherFormats);
        RibbonApplicationMenuEntryPrimary amEntryPrint = new RibbonApplicationMenuEntryPrimary(new document_print(), this.resourceBundle.getString("AppMenuPrint.text"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Invoked printing document");
            }
        }, JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        amEntryPrint.setActionKeyTip("P");
        amEntryPrint.setPopupKeyTip("W");
        RibbonApplicationMenuEntrySecondary amEntryPrintSelect = new RibbonApplicationMenuEntrySecondary(new printer(), this.resourceBundle.getString("AppMenuPrint.print.text"), null, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntryPrintSelect.setDescriptionText(this.resourceBundle.getString("AppMenuPrint.print.description"));
        amEntryPrintSelect.setActionKeyTip("P");
        RibbonApplicationMenuEntrySecondary amEntryPrintDefault = new RibbonApplicationMenuEntrySecondary(new document_print(), this.resourceBundle.getString("AppMenuPrint.quick.text"), null, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntryPrintDefault.setDescriptionText(this.resourceBundle.getString("AppMenuPrint.quick.description"));
        amEntryPrintDefault.setActionKeyTip("Q");
        RibbonApplicationMenuEntrySecondary amEntryPrintPreview = new RibbonApplicationMenuEntrySecondary(new document_print_preview(), this.resourceBundle.getString("AppMenuPrint.preview.text"), null, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntryPrintPreview.setDescriptionText(this.resourceBundle.getString("AppMenuPrint.preview.description"));
        amEntryPrintPreview.setActionKeyTip("V");
        amEntryPrint.addSecondaryMenuGroup(this.resourceBundle.getString("AppMenuPrint.secondary.textGroupTitle1"), amEntryPrintSelect, amEntryPrintDefault, amEntryPrintPreview);
        RibbonApplicationMenuEntrySecondary amEntryPrintMemo = new RibbonApplicationMenuEntrySecondary(new text_x_generic(), this.resourceBundle.getString("AppMenuPrint.memo.text"), null, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntryPrintMemo.setActionKeyTip("M");
        amEntryPrint.addSecondaryMenuGroup(this.resourceBundle.getString("AppMenuPrint.secondary.textGroupTitle2"), amEntryPrintMemo);
        RibbonApplicationMenuEntryPrimary amEntrySend = new RibbonApplicationMenuEntryPrimary(new mail_forward(), this.resourceBundle.getString("AppMenuSend.text"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Invoked sending document");
            }
        }, JCommandButton.CommandButtonKind.POPUP_ONLY);
        amEntrySend.setPopupKeyTip("D");
        RibbonApplicationMenuEntrySecondary amEntrySendMail = new RibbonApplicationMenuEntrySecondary(new mail_message_new(), this.resourceBundle.getString("AppMenuSend.email.text"), null, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntrySendMail.setDescriptionText(this.resourceBundle.getString("AppMenuSend.email.description"));
        amEntrySendMail.setActionKeyTip("E");
        RibbonApplicationMenuEntrySecondary amEntrySendHtml = new RibbonApplicationMenuEntrySecondary(new text_html(), this.resourceBundle.getString("AppMenuSend.html.text"), null, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntrySendHtml.setDescriptionText(this.resourceBundle.getString("AppMenuSend.html.description"));
        amEntrySendHtml.setActionKeyTip("H");
        RibbonApplicationMenuEntrySecondary amEntrySendDoc = new RibbonApplicationMenuEntrySecondary(new x_office_document(), this.resourceBundle.getString("AppMenuSend.word.text"), null, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntrySendDoc.setDescriptionText(this.resourceBundle.getString("AppMenuSend.word.description"));
        amEntrySendDoc.setActionKeyTip("W");
        RibbonApplicationMenuEntrySecondary amEntrySendWireless = new RibbonApplicationMenuEntrySecondary(new network_wireless(), this.resourceBundle.getString("AppMenuSend.wireless.text"), null, JCommandButton.CommandButtonKind.POPUP_ONLY);
        amEntrySendWireless.setPopupKeyTip("X");
        amEntrySendWireless.setPopupCallback(new PopupPanelCallback(){

            @Override
            public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                JCommandPopupMenu wirelessChoices = new JCommandPopupMenu();
                JCommandMenuButton wiFiMenuButton = new JCommandMenuButton(BasicCheckRibbon.this.resourceBundle.getString("AppMenuSend.wireless.wifi.text"), new EmptyResizableIcon(16));
                wiFiMenuButton.setActionKeyTip("W");
                wiFiMenuButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("WiFi activated");
                    }
                });
                wirelessChoices.addMenuButton(wiFiMenuButton);
                JCommandMenuButton blueToothMenuButton = new JCommandMenuButton(BasicCheckRibbon.this.resourceBundle.getString("AppMenuSend.wireless.bluetooth.text"), new EmptyResizableIcon(16));
                blueToothMenuButton.setActionKeyTip("B");
                blueToothMenuButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("BlueTooth activated");
                    }
                });
                wirelessChoices.addMenuButton(blueToothMenuButton);
                return wirelessChoices;
            }
        });
        amEntrySendWireless.setDescriptionText(this.resourceBundle.getString("AppMenuSend.wireless.description"));
        amEntrySend.addSecondaryMenuGroup(this.resourceBundle.getString("AppMenuSend.secondary.textGroupTitle1"), amEntrySendMail, amEntrySendHtml, amEntrySendDoc, amEntrySendWireless);
        RibbonApplicationMenuEntryPrimary amEntryExit = new RibbonApplicationMenuEntryPrimary(new system_log_out(), this.resourceBundle.getString("AppMenuExit.text"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        }, JCommandButton.CommandButtonKind.ACTION_ONLY);
        amEntryExit.setActionKeyTip("X");
        RibbonApplicationMenu applicationMenu = new RibbonApplicationMenu();
        applicationMenu.addMenuEntry(amEntryNew);
        applicationMenu.addMenuEntry(amEntryOpen);
        applicationMenu.addMenuEntry(amEntrySave);
        applicationMenu.addMenuEntry(amEntrySaveAs);
        applicationMenu.addMenuSeparator();
        applicationMenu.addMenuEntry(amEntryPrint);
        applicationMenu.addMenuEntry(amEntrySend);
        applicationMenu.addMenuSeparator();
        applicationMenu.addMenuEntry(amEntryExit);
        applicationMenu.setDefaultCallback(new RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback(){

            @Override
            public void menuEntryActivated(JPanel targetPanel) {
                targetPanel.removeAll();
                JCommandButtonPanel openHistoryPanel = new JCommandButtonPanel(CommandButtonDisplayState.MEDIUM);
                String groupName = BasicCheckRibbon.this.resourceBundle.getString("AppMenu.default.textGroupTitle1");
                openHistoryPanel.addButtonGroup(groupName);
                MessageFormat mf = new MessageFormat(BasicCheckRibbon.this.resourceBundle.getString("AppMenu.default.textButton"));
                mf.setLocale(BasicCheckRibbon.this.currLocale);
                int i = 0;
                while (i < 5) {
                    JCommandButton historyButton = new JCommandButton(mf.format(new Object[]{i}), new text_html());
                    historyButton.setHorizontalAlignment(2);
                    openHistoryPanel.addButtonToLastGroup(historyButton);
                    ++i;
                }
                openHistoryPanel.setMaxButtonColumns(1);
                targetPanel.setLayout(new BorderLayout());
                targetPanel.add((Component)openHistoryPanel, "Center");
            }
        });
        RibbonApplicationMenuEntryFooter amFooterProps = new RibbonApplicationMenuEntryFooter(new document_properties(), this.resourceBundle.getString("AppMenuOptions.text"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Invoked Options");
            }
        });
        RibbonApplicationMenuEntryFooter amFooterExit = new RibbonApplicationMenuEntryFooter(new system_log_out(), this.resourceBundle.getString("AppMenuExit.text"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        amFooterExit.setEnabled(false);
        applicationMenu.addFooterEntry(amFooterProps);
        applicationMenu.addFooterEntry(amFooterExit);
        this.getRibbon().setApplicationMenu(applicationMenu);
        RichTooltip appMenuRichTooltip = new RichTooltip();
        appMenuRichTooltip.setTitle(this.resourceBundle.getString("AppMenu.tooltip.title"));
        appMenuRichTooltip.addDescriptionSection(this.resourceBundle.getString("AppMenu.tooltip.paragraph1"));
        try {
            appMenuRichTooltip.setMainImage(ImageIO.read(BasicCheckRibbon.class.getResource("/test/ribbon/appmenubutton-tooltip-main.png")));
            appMenuRichTooltip.setFooterImage(ImageIO.read(BasicCheckRibbon.class.getResource("/test/ribbon/help-browser.png")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        appMenuRichTooltip.addFooterSection(this.resourceBundle.getString("AppMenu.tooltip.footer1"));
        this.getRibbon().setApplicationMenuRichTooltip(appMenuRichTooltip);
        this.getRibbon().setApplicationMenuKeyTip("F");
    }

    protected RibbonTask getContextualRibbonTask(String title, String keyTip) {
        JRibbonBand actionBand = this.getActionBand();
        JRibbonBand arrangeBand = this.getApplicationsBand();
        JRibbonBand previewBand = this.getPreviewBand();
        JRibbonBand transitionBand = this.getTransitionBand();
        RibbonTask task = new RibbonTask(title, actionBand, arrangeBand, previewBand, transitionBand);
        task.setKeyTip(keyTip);
        return task;
    }

    protected void configureControlPanel(DefaultFormBuilder builder) {
        final JCheckBox group1Visible = new JCheckBox("visible");
        final JCheckBox group2Visible = new JCheckBox("visible");
        group1Visible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BasicCheckRibbon.this.getRibbon().setVisible((this).BasicCheckRibbon.this.group1, group1Visible.isSelected());
                    }
                });
            }
        });
        group2Visible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BasicCheckRibbon.this.getRibbon().setVisible((this).BasicCheckRibbon.this.group2, group2Visible.isSelected());
                    }
                });
            }
        });
        builder.append("Group 1", (Component)group1Visible);
        builder.append("Group 2", (Component)group2Visible);
        builder.append("Look & feel", (Component)LookAndFeelSwitcher.getLookAndFeelSwitcher(this));
        final JCheckBox appMenuVisible = new JCheckBox("visible");
        appMenuVisible.setSelected(true);
        appMenuVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!appMenuVisible.isSelected()) {
                            BasicCheckRibbon.this.getRibbon().setApplicationMenu(null);
                        } else {
                            BasicCheckRibbon.this.configureApplicationMenu();
                        }
                    }
                });
            }
        });
        builder.append("App menu", (Component)appMenuVisible);
        final JCheckBox taskbarFull = new JCheckBox("full");
        taskbarFull.setSelected(true);
        taskbarFull.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!taskbarFull.isSelected()) {
                            ArrayList<Component> taskbarComps = new ArrayList<Component>(BasicCheckRibbon.this.getRibbon().getTaskbarComponents());
                            for (Component taskbarComp : taskbarComps) {
                                BasicCheckRibbon.this.getRibbon().removeTaskbarComponent(taskbarComp);
                            }
                        } else {
                            BasicCheckRibbon.this.configureTaskBar();
                        }
                        BasicCheckRibbon.this.repaint();
                    }
                });
            }
        });
        builder.append("Taskbar", (Component)taskbarFull);
        JButton changeParagraph = new JButton("change");
        changeParagraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BasicCheckRibbon.this.paragraphBand.setGroupTitle(0, this.getRandomString(5, 15));
                        BasicCheckRibbon.this.paragraphBand.getRibbonComponents(0).get(0).setCaption(this.getRandomString(4, 10));
                    }

                    private String getRandomString(int minLength, int maxLength) {
                        Random random = new Random();
                        int len = minLength + random.nextInt(maxLength - minLength);
                        String newTitle = new String();
                        String letters = "abcdefghijklmnopqrstubvwxyz       ";
                        int i = 0;
                        while (i < len) {
                            newTitle = String.valueOf(newTitle) + letters.charAt(random.nextInt(letters.length()));
                            ++i;
                        }
                        return newTitle;
                    }
                });
            }
        });
        builder.append("Change 'Paragraph'", (Component)changeParagraph);
    }

    protected JFlowRibbonBand getFontBand() {
        JFlowRibbonBand fontBand = new JFlowRibbonBand(this.resourceBundle.getString("Font.textBandTitle"), new preferences_desktop_font(), new ExpandActionListener());
        fontBand.setExpandButtonKeyTip("FN");
        fontBand.setCollapsedStateKeyTip("ZF");
        JComboBox<Object> fontCombo = new JComboBox<Object>(new Object[]{"+ Minor (Calibri)   ", "+ Minor (Columbus)   ", "+ Minor (Consolas)   ", "+ Minor (Cornelius)   ", "+ Minor (Cleopatra)   ", "+ Minor (Cornucopia)   ", "+ Minor (Candella)   ", "+ Minor (Cambria)   "});
        JRibbonComponent fontComboWrapper = new JRibbonComponent(fontCombo);
        fontComboWrapper.setKeyTip("SF");
        fontBand.addFlowComponent(fontComboWrapper);
        JComboBox<Object> sizeCombo = new JComboBox<Object>(new Object[]{"11  "});
        JRibbonComponent sizeComboWrapper = new JRibbonComponent(sizeCombo);
        sizeComboWrapper.setKeyTip("SS");
        fontBand.addFlowComponent(sizeComboWrapper);
        JCommandButtonStrip indentStrip = new JCommandButtonStrip();
        JCommandButton indentLeftButton = new JCommandButton("", new format_indent_less());
        indentLeftButton.setActionKeyTip("AO");
        indentStrip.add(indentLeftButton);
        JCommandButton indentRightButton = new JCommandButton("", new format_indent_more());
        indentRightButton.setActionKeyTip("AI");
        indentStrip.add(indentRightButton);
        fontBand.addFlowComponent(indentStrip);
        JCommandButtonStrip styleStrip = new JCommandButtonStrip();
        JCommandToggleButton styleBoldButton = new JCommandToggleButton("", new format_text_bold());
        styleBoldButton.getActionModel().setSelected(true);
        styleBoldButton.setActionRichTooltip(new RichTooltip(this.resourceBundle.getString("FontBold.tooltip.textActionTitle"), this.resourceBundle.getString("FontBold.tooltip.textActionParagraph1")));
        styleBoldButton.setActionKeyTip("1");
        styleStrip.add(styleBoldButton);
        JCommandToggleButton styleItalicButton = new JCommandToggleButton("", new format_text_italic());
        styleItalicButton.setActionRichTooltip(new RichTooltip(this.resourceBundle.getString("FontItalic.tooltip.textActionTitle"), this.resourceBundle.getString("FontItalic.tooltip.textActionParagraph1")));
        styleItalicButton.setActionKeyTip("2");
        styleStrip.add(styleItalicButton);
        JCommandToggleButton styleUnderlineButton = new JCommandToggleButton("", new format_text_underline());
        styleUnderlineButton.setActionRichTooltip(new RichTooltip(this.resourceBundle.getString("FontUnderline.tooltip.textActionTitle"), this.resourceBundle.getString("FontUnderline.tooltip.textActionParagraph1")));
        styleUnderlineButton.setActionKeyTip("3");
        styleStrip.add(styleUnderlineButton);
        JCommandToggleButton styleStrikeThroughButton = new JCommandToggleButton("", new format_text_strikethrough());
        styleStrikeThroughButton.setActionRichTooltip(new RichTooltip(this.resourceBundle.getString("FontStrikethrough.tooltip.textActionTitle"), this.resourceBundle.getString("FontStrikethrough.tooltip.textActionParagraph1")));
        styleStrikeThroughButton.setActionKeyTip("4");
        styleStrip.add(styleStrikeThroughButton);
        fontBand.addFlowComponent(styleStrip);
        JCommandButtonStrip alignStrip = new JCommandButtonStrip();
        CommandToggleButtonGroup alignGroup = new CommandToggleButtonGroup();
        JCommandToggleButton alignLeftButton = new JCommandToggleButton("", new format_justify_left());
        alignLeftButton.setActionKeyTip("AL");
        alignLeftButton.getActionModel().setSelected(true);
        alignGroup.add(alignLeftButton);
        alignStrip.add(alignLeftButton);
        JCommandToggleButton alignCenterButton = new JCommandToggleButton("", new format_justify_center());
        alignCenterButton.setActionKeyTip("AC");
        alignGroup.add(alignCenterButton);
        alignStrip.add(alignCenterButton);
        JCommandToggleButton alignRightButton = new JCommandToggleButton("", new format_justify_right());
        alignRightButton.setActionKeyTip("AR");
        alignGroup.add(alignRightButton);
        alignStrip.add(alignRightButton);
        JCommandToggleButton alignFillButton = new JCommandToggleButton("", new format_justify_fill());
        alignFillButton.setActionKeyTip("AF");
        alignGroup.add(alignFillButton);
        alignStrip.add(alignFillButton);
        fontBand.addFlowComponent(alignStrip);
        return fontBand;
    }

    public static void main(String[] args) {
        UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
        UIManager.installLookAndFeel("JGoodies PlasticXP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        UIManager.installLookAndFeel("JGoodies Plastic3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        UIManager.installLookAndFeel("JGoodies Windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
        UIManager.installLookAndFeel("Synthetica base", "de.javasoft.plaf.synthetica.SyntheticaStandardLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlackEye", "de.javasoft.plaf.synthetica.SyntheticaBlackEyeLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlackMoon", "de.javasoft.plaf.synthetica.SyntheticaBlackMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlackStar", "de.javasoft.plaf.synthetica.SyntheticaBlackStarLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueIce", "de.javasoft.plaf.synthetica.SyntheticaBlueIceLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueMoon", "de.javasoft.plaf.synthetica.SyntheticaBlueMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica BlueSteel", "de.javasoft.plaf.synthetica.SyntheticaBlueSteelLookAndFeel");
        UIManager.installLookAndFeel("Synthetica GreenDream", "de.javasoft.plaf.synthetica.SyntheticaGreenDreamLookAndFeel");
        UIManager.installLookAndFeel("Synthetica MauveMetallic", "de.javasoft.plaf.synthetica.SyntheticaMauveMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica OrangeMetallic", "de.javasoft.plaf.synthetica.SyntheticaOrangeMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica SkyMetallic", "de.javasoft.plaf.synthetica.SyntheticaSkyMetallicLookAndFeel");
        UIManager.installLookAndFeel("Synthetica SilverMoon", "de.javasoft.plaf.synthetica.SyntheticaSilverMoonLookAndFeel");
        UIManager.installLookAndFeel("Synthetica WhiteVision", "de.javasoft.plaf.synthetica.SyntheticaWhiteVisionLookAndFeel");
        UIManager.installLookAndFeel("Synthetica Simple2D", "de.javasoft.plaf.synthetica.SyntheticaSimple2DLookAndFeel");
        UIManager.installLookAndFeel("A03", "a03.swing.plaf.A03LookAndFeel");
        UIManager.installLookAndFeel("Liquid", "com.birosoft.liquid.LiquidLookAndFeel");
        UIManager.installLookAndFeel("Napkin", "net.sourceforge.napkinlaf.NapkinLookAndFeel");
        UIManager.installLookAndFeel("Pagosoft", "com.pagosoft.plaf.PgsLookAndFeel");
        UIManager.installLookAndFeel("Squareness", "net.beeger.squareness.SquarenessLookAndFeel");
        JFrame.setDefaultLookAndFeelDecorated(true);
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicCheckRibbon c = new BasicCheckRibbon();
                c.configureRibbon();
                c.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                c.setPreferredSize(new Dimension(r.width, r.height / 2));
                c.setMinimumSize(new Dimension(r.width / 10, r.height / 2));
                c.pack();
                c.setLocation(r.x, r.y);
                c.setVisible(true);
                c.setDefaultCloseOperation(2);
                c.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke("alt shift E"), "installTracingRepaintManager");
                c.getRootPane().getActionMap().put("installTracingRepaintManager", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RepaintManager.setCurrentManager(new TracingRepaintManager());
                    }
                });
            }
        });
    }

    protected void configureStatusBar() {
        this.statusBar = new JPanel(new FlowLayout(4));
        JLabel helper = new JLabel("Right click to show menu");
        this.statusBar.add(helper);
        JCommandButtonStrip alignStrip = new JCommandButtonStrip();
        CommandToggleButtonGroup alignGroup = new CommandToggleButtonGroup();
        JCommandToggleButton alignLeftButton = new JCommandToggleButton("", new format_justify_left());
        alignLeftButton.getActionModel().setSelected(true);
        alignGroup.add(alignLeftButton);
        alignStrip.add(alignLeftButton);
        JCommandToggleButton alignCenterButton = new JCommandToggleButton("", new format_justify_center());
        alignGroup.add(alignCenterButton);
        alignStrip.add(alignCenterButton);
        JCommandToggleButton alignRightButton = new JCommandToggleButton("", new format_justify_right());
        alignGroup.add(alignRightButton);
        alignStrip.add(alignRightButton);
        JCommandToggleButton alignFillButton = new JCommandToggleButton("", new format_justify_fill());
        alignGroup.add(alignFillButton);
        alignStrip.add(alignFillButton);
        this.statusBar.add(alignStrip);
        final TreeMap selection = new TreeMap();
        this.statusBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.processPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.processPopup(e);
                }
            }

            private void processPopup(MouseEvent e) {
                Point pt = new Point(e.getPoint());
                SwingUtilities.convertPointToScreen(pt, BasicCheckRibbon.this.statusBar);
                final JCommandPopupMenu menu = new JCommandPopupMenu();
                int i = 0;
                while (i < 10) {
                    final int ind = i;
                    final JCommandToggleMenuButton button = new JCommandToggleMenuButton("option " + i, null);
                    button.getActionModel().addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            selection.put(ind, button.getActionModel().isSelected());
                        }
                    });
                    if (selection.containsKey(i)) {
                        button.getActionModel().setSelected((Boolean)selection.get(i));
                    }
                    menu.addMenuButton(button);
                    if (i == 3 || i == 7) {
                        menu.addMenuSeparator();
                    }
                    ++i;
                }
                menu.setToDismissOnChildClick(false);
                Popup popup = PopupFactory.getSharedInstance().getPopup(BasicCheckRibbon.this.statusBar, menu, pt.x, pt.y - menu.getPreferredSize().height);
                PopupPanelManager.defaultManager().addPopup(BasicCheckRibbon.this.statusBar, popup, menu);
                PopupPanelManager.PopupListener tracker = new PopupPanelManager.PopupListener(){

                    @Override
                    public void popupShown(PopupPanelManager.PopupEvent event) {
                    }

                    @Override
                    public void popupHidden(PopupPanelManager.PopupEvent event) {
                        if (event.getSource() == menu) {
                            System.out.print("Current selection: ");
                            for (Map.Entry e : selection.entrySet()) {
                                if (!((Boolean)e.getValue()).booleanValue()) continue;
                                System.out.print(e.getKey() + " ");
                            }
                            System.out.println();
                        }
                        PopupPanelManager.defaultManager().removePopupListener(this);
                    }
                };
                PopupPanelManager.defaultManager().addPopupListener(tracker);
            }
        });
        this.add((Component)this.statusBar, "South");
    }

    private class ExpandActionListener
    implements ActionListener {
        private ExpandActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(BasicCheckRibbon.this, "Expand button clicked");
        }
    }

    protected class QuickStylesPanel
    extends JCommandButtonPanel {
        public QuickStylesPanel() {
            super(32);
            MessageFormat mfGroupTitle = new MessageFormat(BasicCheckRibbon.this.resourceBundle.getString("PanelStyles.text"));
            mfGroupTitle.setLocale(BasicCheckRibbon.this.currLocale);
            MessageFormat mfTooltipTitle = new MessageFormat(BasicCheckRibbon.this.resourceBundle.getString("PanelStyles.tooltip.textActionTitle"));
            mfTooltipTitle.setLocale(BasicCheckRibbon.this.currLocale);
            MessageFormat mfTooltipParagraph = new MessageFormat(BasicCheckRibbon.this.resourceBundle.getString("PanelStyles.tooltip.textActionParagraph1"));
            mfTooltipParagraph.setLocale(BasicCheckRibbon.this.currLocale);
            int groupIndex = 0;
            while (groupIndex < 4) {
                String iconGroupName = mfGroupTitle.format(new Object[]{groupIndex});
                this.addButtonGroup(iconGroupName, groupIndex);
                int i = 0;
                while (i < 15) {
                    final int index = i;
                    font_x_generic fontIcon = new font_x_generic();
                    DecoratedResizableIcon finalIcon = new DecoratedResizableIcon(fontIcon, new DecoratedResizableIcon.IconDecorator(){

                        @Override
                        public void paintIconDecoration(Component c, Graphics g, int x, int y, int width, int height) {
                            Graphics2D g2d = (Graphics2D)g.create();
                            g2d.setColor(Color.black);
                            g2d.setFont(UIManager.getFont("Label.font"));
                            RenderingUtils.installDesktopHints(g2d);
                            g2d.drawString("" + index, x + 2, y + height - 2);
                            g2d.dispose();
                        }
                    });
                    JCommandToggleButton jrb = new JCommandToggleButton(null, finalIcon);
                    jrb.setName("Group " + groupIndex + ", index " + i);
                    jrb.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            System.out.println("Invoked action on " + index);
                        }
                    });
                    String actionTooltipTitle = mfTooltipTitle.format(new Object[]{i});
                    String actionTooltipParagraph1 = mfTooltipParagraph.format(new Object[]{i});
                    jrb.setActionRichTooltip(new RichTooltip(actionTooltipTitle, actionTooltipParagraph1));
                    this.addButtonToLastGroup(jrb);
                    ++i;
                }
                ++groupIndex;
            }
            this.setSingleSelectionMode(true);
        }
    }

    public static class RulerPanel
    extends JPanel {
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g.create();
            RenderingUtils.installDesktopHints(g2d);
            g2d.setColor(Color.gray);
            if (this.getComponentOrientation().isLeftToRight()) {
                int c;
                int offset;
                int i = offset = 20;
                while (i < this.getWidth()) {
                    if ((i - offset) % 100 != 0) {
                        g2d.drawLine(i, 9, i, 11);
                    }
                    i += 10;
                }
                i = offset + 50;
                while (i < this.getWidth()) {
                    g2d.drawLine(i, 7, i, 13);
                    i += 100;
                }
                i = offset;
                while (i < this.getWidth()) {
                    c = (i - offset) / 100 % 10;
                    g2d.drawString("" + c, i - 2, 15);
                    i += 100;
                }
                i = offset;
                while (i < this.getHeight()) {
                    if ((i - offset) % 100 != 0) {
                        g2d.drawLine(9, i, 11, i);
                    }
                    i += 10;
                }
                i = offset + 50;
                while (i < this.getHeight()) {
                    g2d.drawLine(7, i, 13, i);
                    i += 100;
                }
                i = offset;
                while (i < this.getHeight()) {
                    c = (i - offset) / 100 % 10;
                    g2d.drawString("" + c, 8, i + 4);
                    i += 100;
                }
            } else {
                int c;
                int offset = 20;
                int i = this.getWidth() - offset;
                while (i > 0) {
                    if ((this.getWidth() - offset - i) % 100 != 0) {
                        g2d.drawLine(i, 9, i, 11);
                    }
                    i -= 10;
                }
                i = this.getWidth() - offset - 50;
                while (i > 0) {
                    g2d.drawLine(i, 7, i, 13);
                    i -= 100;
                }
                i = this.getWidth() - offset;
                while (i > 0) {
                    c = (this.getWidth() - offset - i) / 100 % 10;
                    g2d.drawString("" + c, i - 2, 15);
                    i -= 100;
                }
                i = offset;
                while (i < this.getHeight()) {
                    if ((i - offset) % 100 != 0) {
                        g2d.drawLine(this.getWidth() - 9, i, this.getWidth() - 11, i);
                    }
                    i += 10;
                }
                i = offset + 50;
                while (i < this.getHeight()) {
                    g2d.drawLine(this.getWidth() - 7, i, this.getWidth() - 13, i);
                    i += 100;
                }
                i = offset;
                while (i < this.getHeight()) {
                    c = (i - offset) / 100 % 10;
                    g2d.drawString("" + c, this.getWidth() - 14, i + 4);
                    i += 100;
                }
            }
            g2d.dispose();
        }
    }

    private class SamplePopupMenu
    extends JCommandPopupMenu {
        public SamplePopupMenu() {
            MessageFormat mf = new MessageFormat(BasicCheckRibbon.this.resourceBundle.getString("TestMenuItem.text"));
            mf.setLocale(BasicCheckRibbon.this.currLocale);
            JCommandMenuButton menuButton1 = new JCommandMenuButton(mf.format(new Object[]{"1"}), new EmptyResizableIcon(16));
            menuButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Test menu item 1 activated");
                }
            });
            menuButton1.setActionKeyTip("1");
            this.addMenuButton(menuButton1);
            JCommandMenuButton menuButton2 = new JCommandMenuButton(mf.format(new Object[]{"2"}), new EmptyResizableIcon(16));
            menuButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Test menu item 2 activated");
                }
            });
            menuButton2.setActionKeyTip("2");
            this.addMenuButton(menuButton2);
            JCommandMenuButton menuButton3 = new JCommandMenuButton(mf.format(new Object[]{"3"}), new EmptyResizableIcon(16));
            menuButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Test menu item 3 activated");
                }
            });
            menuButton3.setActionKeyTip("3");
            this.addMenuButton(menuButton3);
            this.addMenuSeparator();
            JCommandMenuButton menuButton4 = new JCommandMenuButton(mf.format(new Object[]{"4"}), new EmptyResizableIcon(16));
            menuButton4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Test menu item 4 activated");
                }
            });
            menuButton4.setActionKeyTip("4");
            this.addMenuButton(menuButton4);
            JCommandMenuButton menuButton5 = new JCommandMenuButton(mf.format(new Object[]{"5"}), new EmptyResizableIcon(16));
            menuButton5.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Test menu item 5 activated");
                }
            });
            menuButton5.setActionKeyTip("5");
            this.addMenuButton(menuButton5);
        }
    }
}

