/*
 * Decompiled with CFR 0.152.
 */
package utest.bcb;

import java.util.Arrays;
import junit.framework.TestCase;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarModel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;

public class BreadcrumbBarModelTestCase
extends TestCase {
    public void testEmptyStringModel() {
        BreadcrumbBarModel model = new BreadcrumbBarModel();
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 0);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(0));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 0);
    }

    public void testEmptyFileModel() {
        BreadcrumbBarModel model = new BreadcrumbBarModel();
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 0);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(0));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 0);
    }

    public void testAddingToStringModel() {
        BreadcrumbBarModel<String> model = new BreadcrumbBarModel<String>();
        BreadcrumbItem<String> item1 = new BreadcrumbItem<String>("key1", "data1");
        model.addLast(item1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItem(0), item1);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(-1));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(1));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().get(0), item1);
        BreadcrumbItem<String> item2 = new BreadcrumbItem<String>("key2", "data2");
        model.addLast(item2);
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 2);
        BreadcrumbBarModelTestCase.assertEquals(model.getItem(0), item1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItem(1), item2);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(-1));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(2));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 2);
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().get(0), item1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().get(1), item2);
    }

    public void testReplacingInStringModel() {
        BreadcrumbBarModel<String> model = new BreadcrumbBarModel<String>();
        BreadcrumbItem<String> item1 = new BreadcrumbItem<String>("key1", "data1");
        model.addLast(item1);
        BreadcrumbItem<String> item2 = new BreadcrumbItem<String>("key2", "data2");
        model.addLast(item2);
        BreadcrumbItem<String> item3 = new BreadcrumbItem<String>("key3", "data3");
        model.replace(Arrays.asList(item3));
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItem(0), item3);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(-1));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(1));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().get(0), item3);
        BreadcrumbItem<String> item4 = new BreadcrumbItem<String>("key4", "data4");
        BreadcrumbItem<String> item5 = new BreadcrumbItem<String>("key5", "data5");
        model.replace(Arrays.asList(item4, item5));
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 2);
        BreadcrumbBarModelTestCase.assertEquals(model.getItem(0), item4);
        BreadcrumbBarModelTestCase.assertEquals(model.getItem(1), item5);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(-1));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(2));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 2);
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().get(0), item4);
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().get(1), item5);
        model.replace(Arrays.asList(item4));
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItem(0), item4);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(-1));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(1));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().get(0), item4);
    }

    public void testResettingInStringModel() {
        BreadcrumbBarModel<String> model = new BreadcrumbBarModel<String>();
        BreadcrumbItem<String> item1 = new BreadcrumbItem<String>("key1", "data1");
        model.addLast(item1);
        BreadcrumbItem<String> item2 = new BreadcrumbItem<String>("key2", "data2");
        model.addLast(item2);
        model.reset();
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 0);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(0));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(-1));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(1));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 0);
        BreadcrumbItem<String> item3 = new BreadcrumbItem<String>("key3", "data3");
        model.replace(Arrays.asList(item3));
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItem(0), item3);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(-1));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(1));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().get(0), item3);
        model.reset();
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 0);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(0));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(-1));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(1));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 0);
    }

    public void testRemovingFromStringModel() {
        BreadcrumbBarModel<String> model = new BreadcrumbBarModel<String>();
        BreadcrumbItem<String> item1 = new BreadcrumbItem<String>("key1", "data1");
        model.addLast(item1);
        BreadcrumbItem<String> item2 = new BreadcrumbItem<String>("key2", "data2");
        model.addLast(item2);
        model.removeLast();
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItem(0), item1);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(-1));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(1));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().get(0), item1);
        BreadcrumbItem<String> item3 = new BreadcrumbItem<String>("key3", "data3");
        model.addLast(item3);
        BreadcrumbItem<String> item4 = new BreadcrumbItem<String>("key4", "data4");
        model.addLast(item4);
        model.removeLast();
        BreadcrumbBarModelTestCase.assertEquals(model.getItemCount(), 2);
        BreadcrumbBarModelTestCase.assertEquals(model.getItem(0), item1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItem(1), item3);
        BreadcrumbBarModelTestCase.assertNull(model.getItem(-1));
        BreadcrumbBarModelTestCase.assertNull(model.getItem(2));
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().size(), 2);
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().get(0), item1);
        BreadcrumbBarModelTestCase.assertEquals(model.getItems().get(1), item3);
    }

    public void testIndexOfStringModel() {
        BreadcrumbBarModel<String> model = new BreadcrumbBarModel<String>();
        BreadcrumbItem<String> item1 = new BreadcrumbItem<String>("key1", "data1");
        model.addLast(item1);
        BreadcrumbItem<String> item2 = new BreadcrumbItem<String>("key2", "data2");
        model.addLast(item2);
        BreadcrumbBarModelTestCase.assertEquals(model.indexOf(item1), 0);
        BreadcrumbBarModelTestCase.assertEquals(model.indexOf(item2), 1);
        BreadcrumbItem<String> item3 = new BreadcrumbItem<String>("key3", "data3");
        BreadcrumbBarModelTestCase.assertEquals(model.indexOf(item3), -1);
        model.addLast(item3);
        BreadcrumbBarModelTestCase.assertEquals(model.indexOf(item1), 0);
        BreadcrumbBarModelTestCase.assertEquals(model.indexOf(item2), 1);
        BreadcrumbBarModelTestCase.assertEquals(model.indexOf(item3), 2);
    }
}

