/*
 * Decompiled with CFR 0.152.
 */
package utest.common;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.JFrame;
import org.fest.assertions.Assertions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.junit.testcase.FestSwingJUnitTestCase;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.junit.Before;
import org.junit.Test;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.svg.SvgBatikResizableIcon;
import utest.common.CommandToggleButtonTestCase;

public class CommandToggleButtonGroupTestCase
extends FestSwingJUnitTestCase {
    JFrame buttonFrame;
    static final int COUNT = 3;
    JCommandToggleButton[] buttons;
    CommandToggleButtonGroup group;
    int propertyChangeCount;
    PropertyChangeListener propertyChangeListener;

    @Override
    @Before
    public void onSetUp() {
        String[] iconNames = new String[]{"paste", "copy", "cut"};
        final ResizableIcon[] icons = new ResizableIcon[3];
        int i = 0;
        while (i < 3) {
            URL iconUrl = CommandToggleButtonGroupTestCase.class.getClassLoader().getResource("utest/common/edit-" + iconNames[i] + ".svg");
            Assertions.assertThat(iconUrl).isNotNull();
            icons[i] = SvgBatikResizableIcon.getSvgIcon(iconUrl, new Dimension(32, 32));
            ++i;
        }
        Pause.pause(new Condition("Waiting to load the SVG icons"){

            @Override
            public boolean test() {
                int i = 0;
                while (i < 3) {
                    if (((AsynchronousLoading)((Object)icons[i])).isLoading()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttonFrame = new JFrame();
                CommandToggleButtonGroupTestCase.this.buttonFrame.setLayout(new FlowLayout());
                CommandToggleButtonGroupTestCase.this.propertyChangeCount = 0;
                CommandToggleButtonGroupTestCase.this.group = new CommandToggleButtonGroup();
                CommandToggleButtonGroupTestCase.this.buttons = new JCommandToggleButton[3];
                int i = 0;
                while (i < 3) {
                    CommandToggleButtonGroupTestCase.this.buttons[i] = new JCommandToggleButton("test" + i, icons[i]);
                    CommandToggleButtonGroupTestCase.this.buttons[i].setDisplayState(CommandButtonDisplayState.BIG);
                    CommandToggleButtonGroupTestCase.this.group.add(CommandToggleButtonGroupTestCase.this.buttons[i]);
                    CommandToggleButtonGroupTestCase.this.buttonFrame.add(CommandToggleButtonGroupTestCase.this.buttons[i]);
                    ++i;
                }
                CommandToggleButtonGroupTestCase.this.buttonFrame.setSize(300, 200);
                CommandToggleButtonGroupTestCase.this.buttonFrame.setLocationRelativeTo(null);
                CommandToggleButtonGroupTestCase.this.buttonFrame.setDefaultCloseOperation(2);
                CommandToggleButtonGroupTestCase.this.buttonFrame.setVisible(true);
            }
        });
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                Point locOnScreen = CommandToggleButtonGroupTestCase.this.buttonFrame.getLocationOnScreen();
                locOnScreen.move(10, 20);
                CommandToggleButtonGroupTestCase.this.robot().moveMouse(locOnScreen);
            }
        });
    }

    @Test
    public void buttonActivationWithMouse() {
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        int i = 0;
        while (i < 3) {
            int indexToSelect = i;
            this.robot().click(this.buttons[indexToSelect]);
            this.robot().waitForIdle();
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

                @Override
                protected JCommandToggleButton executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.group.getSelected();
                }
            })).isEqualTo(this.buttons[i]);
            int j = 0;
            while (j < 3) {
                final int index = j;
                Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                    @Override
                    protected Boolean executeInEDT() throws Throwable {
                        return CommandToggleButtonGroupTestCase.this.buttons[index].getActionModel().isSelected();
                    }
                })).isEqualTo(indexToSelect == index);
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void buttonActivationWithAPI() {
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        int i = 0;
        while (i < 3) {
            final int indexToSelect = i;
            GuiActionRunner.execute(new GuiTask(){

                @Override
                protected void executeInEDT() throws Throwable {
                    CommandToggleButtonGroupTestCase.this.buttons[indexToSelect].getActionModel().setSelected(true);
                }
            });
            this.robot().waitForIdle();
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

                @Override
                protected JCommandToggleButton executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.group.getSelected();
                }
            })).isEqualTo(this.buttons[i]);
            int j = 0;
            while (j < 3) {
                final int index = j;
                Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                    @Override
                    protected Boolean executeInEDT() throws Throwable {
                        return CommandToggleButtonGroupTestCase.this.buttons[index].getActionModel().isSelected();
                    }
                })).isEqualTo(indexToSelect == index);
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void buttonActivationWithGroupAPI() {
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        int i = 0;
        while (i < 3) {
            final int indexToSelect = i;
            GuiActionRunner.execute(new GuiTask(){

                @Override
                protected void executeInEDT() throws Throwable {
                    CommandToggleButtonGroupTestCase.this.group.setSelected(CommandToggleButtonGroupTestCase.this.buttons[indexToSelect], true);
                }
            });
            this.robot().waitForIdle();
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

                @Override
                protected JCommandToggleButton executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.group.getSelected();
                }
            })).isEqualTo(this.buttons[indexToSelect]);
            int j = 0;
            while (j < 3) {
                final int index = j;
                Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                    @Override
                    protected Boolean executeInEDT() throws Throwable {
                        return CommandToggleButtonGroupTestCase.this.buttons[index].getActionModel().isSelected();
                    }
                })).isEqualTo(indexToSelect == index);
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void addUnselectedButtonWithNoPreviousSelection() {
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        URL cutIconUrl = CommandToggleButtonTestCase.class.getClassLoader().getResource("utest/common/edit-cut.svg");
        Assertions.assertThat(cutIconUrl).isNotNull();
        final SvgBatikResizableIcon cutIcon = SvgBatikResizableIcon.getSvgIcon(cutIconUrl, new Dimension(16, 16));
        Pause.pause(new Condition("Waiting to load the SVG icon"){

            @Override
            public boolean test() {
                return !((AsynchronousLoading)((Object)cutIcon)).isLoading();
            }
        });
        final JCommandToggleButton newButton = GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                JCommandToggleButton result = new JCommandToggleButton("new button", cutIcon);
                result.setDisplayState(CommandButtonDisplayState.BIG);
                CommandToggleButtonGroupTestCase.this.buttonFrame.add(result);
                CommandToggleButtonGroupTestCase.this.buttonFrame.invalidate();
                CommandToggleButtonGroupTestCase.this.buttonFrame.validate();
                return result;
            }
        });
        this.robot().waitForIdle();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.add(newButton);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                newButton.getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(newButton);
        int j = 0;
        while (j < 3) {
            final int index = j++;
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.buttons[index].getActionModel().isSelected();
                }
            })).isFalse();
        }
    }

    @Test
    public void addUnselectedButtonWithPreviousSelection() {
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        URL cutIconUrl = CommandToggleButtonTestCase.class.getClassLoader().getResource("utest/common/edit-cut.svg");
        Assertions.assertThat(cutIconUrl).isNotNull();
        final SvgBatikResizableIcon cutIcon = SvgBatikResizableIcon.getSvgIcon(cutIconUrl, new Dimension(16, 16));
        Pause.pause(new Condition("Waiting to load the SVG icon"){

            @Override
            public boolean test() {
                return !((AsynchronousLoading)((Object)cutIcon)).isLoading();
            }
        });
        final JCommandToggleButton newButton = GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                JCommandToggleButton result = new JCommandToggleButton("new button", cutIcon);
                result.setDisplayState(CommandButtonDisplayState.BIG);
                CommandToggleButtonGroupTestCase.this.buttonFrame.add(result);
                CommandToggleButtonGroupTestCase.this.buttonFrame.invalidate();
                CommandToggleButtonGroupTestCase.this.buttonFrame.validate();
                return result;
            }
        });
        this.robot().waitForIdle();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.add(newButton);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                newButton.getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(newButton);
        int j = 0;
        while (j < 3) {
            final int index = j++;
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.buttons[index].getActionModel().isSelected();
                }
            })).isFalse();
        }
    }

    @Test
    public void addSelectedButtonWithNoPreviousSelection() {
        int index;
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        URL cutIconUrl = CommandToggleButtonTestCase.class.getClassLoader().getResource("utest/common/edit-cut.svg");
        Assertions.assertThat(cutIconUrl).isNotNull();
        final SvgBatikResizableIcon cutIcon = SvgBatikResizableIcon.getSvgIcon(cutIconUrl, new Dimension(16, 16));
        Pause.pause(new Condition("Waiting to load the SVG icon"){

            @Override
            public boolean test() {
                return !((AsynchronousLoading)((Object)cutIcon)).isLoading();
            }
        });
        final JCommandToggleButton newButton = GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                JCommandToggleButton result = new JCommandToggleButton("new button", cutIcon);
                result.getActionModel().setSelected(true);
                result.setDisplayState(CommandButtonDisplayState.BIG);
                CommandToggleButtonGroupTestCase.this.buttonFrame.add(result);
                CommandToggleButtonGroupTestCase.this.buttonFrame.invalidate();
                CommandToggleButtonGroupTestCase.this.buttonFrame.validate();
                return result;
            }
        });
        this.robot().waitForIdle();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.add(newButton);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(newButton);
        int j = 0;
        while (j < 3) {
            index = j++;
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.buttons[index].getActionModel().isSelected();
                }
            })).isFalse();
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        j = 1;
        while (j < 3) {
            index = j++;
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.buttons[index].getActionModel().isSelected();
                }
            })).isFalse();
        }
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return newButton.getActionModel().isSelected();
            }
        })).isFalse();
    }

    @Test
    public void addSelectedButtonWithPreviousSelection() {
        int index;
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        URL cutIconUrl = CommandToggleButtonTestCase.class.getClassLoader().getResource("utest/common/edit-cut.svg");
        Assertions.assertThat(cutIconUrl).isNotNull();
        final SvgBatikResizableIcon cutIcon = SvgBatikResizableIcon.getSvgIcon(cutIconUrl, new Dimension(16, 16));
        Pause.pause(new Condition("Waiting to load the SVG icon"){

            @Override
            public boolean test() {
                return !((AsynchronousLoading)((Object)cutIcon)).isLoading();
            }
        });
        final JCommandToggleButton newButton = GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                JCommandToggleButton result = new JCommandToggleButton("new button", cutIcon);
                result.getActionModel().setSelected(true);
                result.setDisplayState(CommandButtonDisplayState.BIG);
                CommandToggleButtonGroupTestCase.this.buttonFrame.add(result);
                CommandToggleButtonGroupTestCase.this.buttonFrame.invalidate();
                CommandToggleButtonGroupTestCase.this.buttonFrame.validate();
                return result;
            }
        });
        this.robot().waitForIdle();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.add(newButton);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        int j = 1;
        while (j < 3) {
            index = j++;
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.buttons[index].getActionModel().isSelected();
                }
            })).isFalse();
        }
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return newButton.getActionModel().isSelected();
            }
        })).isFalse();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                newButton.getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(newButton);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return newButton.getActionModel().isSelected();
            }
        })).isTrue();
        j = 0;
        while (j < 3) {
            index = j++;
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.buttons[index].getActionModel().isSelected();
                }
            })).isFalse();
        }
    }

    @Test
    public void removeSelectedButton() {
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.remove(CommandToggleButtonGroupTestCase.this.buttons[0]);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().isSelected();
            }
        })).isFalse();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[2].getActionModel().isSelected();
            }
        })).isFalse();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[1]);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[2].getActionModel().isSelected();
            }
        })).isFalse();
    }

    @Test
    public void removeUnselectedButtonFromGroupWithSelection() {
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.remove(CommandToggleButtonGroupTestCase.this.buttons[1]);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().isSelected();
            }
        })).isFalse();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[2].getActionModel().isSelected();
            }
        })).isFalse();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[2].getActionModel().isSelected();
            }
        })).isFalse();
    }

    @Test
    public void removeUnselectedButtonFromGroupWithNoSelection() {
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.remove(CommandToggleButtonGroupTestCase.this.buttons[1]);
            }
        });
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        int i = 0;
        while (i < 3) {
            final int index = i++;
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.buttons[index].getActionModel().isSelected();
                }
            })).isFalse();
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().setSelected(true);
                CommandToggleButtonGroupTestCase.this.buttons[2].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[2]);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().isSelected();
            }
        })).isFalse();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[2].getActionModel().isSelected();
            }
        })).isTrue();
    }

    @Test
    public void clearSelection() {
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.clearSelection();
            }
        });
        this.robot().waitForIdle();
        int i = 0;
        while (i < 3) {
            final int index = i++;
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.buttons[index].getActionModel().isSelected();
                }
            })).isFalse();
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().setSelected(true);
                CommandToggleButtonGroupTestCase.this.group.remove(CommandToggleButtonGroupTestCase.this.buttons[1]);
                CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[2].getActionModel().isSelected();
            }
        })).isFalse();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.clearSelection();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().isSelected();
            }
        })).isFalse();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[2].getActionModel().isSelected();
            }
        })).isFalse();
    }

    @Test
    public void clickSelectedButton() {
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        this.robot().click(this.buttons[0]);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        this.robot().click(this.buttons[0]);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo((Object)null);
        int i = 0;
        while (i <= 2) {
            final int fi = i++;
            Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

                @Override
                protected Boolean executeInEDT() throws Throwable {
                    return CommandToggleButtonGroupTestCase.this.buttons[fi].getActionModel().isSelected();
                }
            })).isFalse();
        }
    }

    @Test
    public void clickSelectedButtonWhenClearingSelectionIsNotAllowed() {
        this.group.setAllowsClearingSelection(false);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        this.robot().click(this.buttons[0]);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        this.robot().click(this.buttons[0]);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().isSelected();
            }
        })).isFalse();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[2].getActionModel().isSelected();
            }
        })).isFalse();
    }

    @Test
    public void clearSelectionWhenClearingSelectionIsNotAllowed() {
        this.group.setAllowsClearingSelection(false);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        this.robot().click(this.buttons[0]);
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.clearSelection();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().isSelected();
            }
        })).isTrue();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().isSelected();
            }
        })).isFalse();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.buttons[2].getActionModel().isSelected();
            }
        })).isFalse();
    }

    @Test
    public void propertyChangeListener() {
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.propertyChangeCount).isZero();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.propertyChangeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("selected".equals(evt.getPropertyName())) {
                            ++(this).CommandToggleButtonGroupTestCase.this.propertyChangeCount;
                        }
                    }
                };
                CommandToggleButtonGroupTestCase.this.group.addPropertyChangeListener(CommandToggleButtonGroupTestCase.this.propertyChangeListener);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.propertyChangeCount).isZero();
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.propertyChangeCount).isEqualTo(1);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[1]);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.clearSelection();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.propertyChangeCount).isEqualTo(2);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isNull();
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[0].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.propertyChangeCount).isEqualTo(3);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.removePropertyChangeListener(CommandToggleButtonGroupTestCase.this.propertyChangeListener);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.propertyChangeCount).isEqualTo(3);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[0]);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.buttons[1].getActionModel().setSelected(true);
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.propertyChangeCount).isEqualTo(3);
        Assertions.assertThat(GuiActionRunner.execute(new GuiQuery<JCommandToggleButton>(){

            @Override
            protected JCommandToggleButton executeInEDT() throws Throwable {
                return CommandToggleButtonGroupTestCase.this.group.getSelected();
            }
        })).isEqualTo(this.buttons[1]);
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() throws Throwable {
                CommandToggleButtonGroupTestCase.this.group.clearSelection();
            }
        });
        this.robot().waitForIdle();
        Assertions.assertThat(this.propertyChangeCount).isEqualTo(3);
    }
}

