/*
 * Decompiled with CFR 0.152.
 */
package utest.ribbon;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;

public class RibbonGalleryTestCase
extends TestCase {
    JCommandToggleButton[][] buttons;
    JRibbonGallery gallery;
    JRibbonFrame ribbonFrame;
    JRibbonBand ribbonBand;
    static final String GALLERY_NAME = "Gallery";

    @Override
    protected void setUp() throws Exception {
        this.buttons = new JCommandToggleButton[4][10];
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 10) {
                this.buttons[i][j] = new JCommandToggleButton("Button " + i + ":" + j, new EmptyResizableIcon(32));
                ++j;
            }
            ++i;
        }
        this.ribbonFrame = new JRibbonFrame();
        this.ribbonBand = new JRibbonBand("Band", new EmptyResizableIcon(32));
        HashMap<RibbonElementPriority, Integer> visibleButtonCounts = new HashMap<RibbonElementPriority, Integer>();
        visibleButtonCounts.put(RibbonElementPriority.LOW, 1);
        visibleButtonCounts.put(RibbonElementPriority.MEDIUM, 6);
        visibleButtonCounts.put(RibbonElementPriority.TOP, 10);
        ArrayList<StringValuePair<List<JCommandToggleButton>>> galleryButtons = new ArrayList<StringValuePair<List<JCommandToggleButton>>>();
        int i2 = 0;
        while (i2 < 4) {
            ArrayList<JCommandToggleButton> galleryButtonsList = new ArrayList<JCommandToggleButton>();
            int j = 0;
            while (j < 10) {
                galleryButtonsList.add(this.buttons[i2][j]);
                ++j;
            }
            galleryButtons.add(new StringValuePair("Group " + i2, galleryButtonsList));
            ++i2;
        }
        this.ribbonBand.addRibbonGallery(GALLERY_NAME, galleryButtons, visibleButtonCounts, 6, 4, RibbonElementPriority.TOP);
        this.ribbonFrame.getRibbon().addTask(new RibbonTask("Task 0", this.ribbonBand));
        this.gallery = ((JBandControlPanel)this.ribbonBand.getControlPanel()).getRibbonGallery(GALLERY_NAME);
    }

    public void testCreation() {
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroupCount(), 4);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 40);
        int i = 0;
        while (i < this.gallery.getButtonGroupCount()) {
            List<JCommandToggleButton> buttonGroup = this.gallery.getButtonGroup("Group " + i);
            RibbonGalleryTestCase.assertEquals(buttonGroup.size(), 10);
            int j = 0;
            while (j < 10) {
                RibbonGalleryTestCase.assertEquals(buttonGroup.get(j), this.buttons[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public void testSelection() {
        int i = 0;
        while (i < this.gallery.getButtonCount()) {
            RibbonGalleryTestCase.assertFalse(this.gallery.getButtonAt(i).getActionModel().isSelected());
            ++i;
        }
        int[][] nArrayArray = new int[5][];
        nArrayArray[0] = new int[2];
        nArrayArray[1] = new int[]{1, 5};
        nArrayArray[2] = new int[]{2, 1};
        int[] nArray = new int[2];
        nArray[1] = 8;
        nArrayArray[3] = nArray;
        nArrayArray[4] = new int[]{3, 6};
        int[][] toTest = nArrayArray;
        int sel = 0;
        while (sel < toTest.length) {
            int selRow = toTest[sel][0];
            int selCol = toTest[sel][1];
            this.ribbonBand.setSelectedRibbonGalleryButton(GALLERY_NAME, this.buttons[selRow][selCol]);
            int i2 = 0;
            while (i2 < this.gallery.getButtonGroupCount()) {
                List<JCommandToggleButton> buttonGroup = this.gallery.getButtonGroup("Group " + i2);
                int j = 0;
                while (j < 10) {
                    JCommandToggleButton button = buttonGroup.get(j);
                    if (i2 == selRow && j == selCol) {
                        RibbonGalleryTestCase.assertTrue(button.getActionModel().isSelected());
                    } else {
                        RibbonGalleryTestCase.assertFalse(button.getActionModel().isSelected());
                    }
                    ++j;
                }
                ++i2;
            }
            ++sel;
        }
    }

    public void testSelectionWithMouse() {
        final CountDownLatch latch = new CountDownLatch(1);
        final Throwable[] ts = new Throwable[1];
        int i = 0;
        while (i < this.gallery.getButtonCount()) {
            RibbonGalleryTestCase.assertFalse(this.gallery.getButtonAt(i).getActionModel().isSelected());
            ++i;
        }
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        final int[] toTest = nArray;
        final boolean[] tested = new boolean[toTest.length];
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle r = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                RibbonGalleryTestCase.this.ribbonFrame.setPreferredSize(new Dimension(r.width, r.height / 2));
                RibbonGalleryTestCase.this.ribbonFrame.pack();
                RibbonGalleryTestCase.this.ribbonFrame.setLocation(r.x, r.y);
                RibbonGalleryTestCase.this.ribbonFrame.setVisible(true);
                RibbonGalleryTestCase.this.ribbonFrame.setDefaultCloseOperation(2);
                Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        ts[0] = e;
                        e.printStackTrace();
                    }
                });
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Robot robot = new Robot();
                            int sel = 0;
                            while (sel < toTest.length) {
                                int selCol = toTest[sel];
                                JCommandToggleButton toClick = (this).RibbonGalleryTestCase.this.buttons[0][selCol];
                                Point buttonLeftTop = toClick.getLocationOnScreen();
                                int buttonWidth = toClick.getWidth();
                                int buttonHeight = toClick.getHeight();
                                robot.mouseMove(buttonLeftTop.x + buttonWidth / 2, buttonLeftTop.y + buttonHeight / 2);
                                robot.mousePress(16);
                                robot.mouseRelease(16);
                                Thread.sleep(1000L);
                                final int fSel = sel++;
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        int selectedCount = 0;
                                        int i = 0;
                                        while (i < ((this).this).RibbonGalleryTestCase.this.gallery.getButtonGroupCount()) {
                                            List<JCommandToggleButton> buttonGroup = ((this).this).RibbonGalleryTestCase.this.gallery.getButtonGroup("Group " + i);
                                            int j = 0;
                                            while (j < buttonGroup.size()) {
                                                JCommandToggleButton button = buttonGroup.get(j);
                                                if (button.getActionModel().isSelected()) {
                                                    ++selectedCount;
                                                }
                                                ++j;
                                            }
                                            ++i;
                                        }
                                        tested[fSel] = selectedCount == 1 && ((this).this).RibbonGalleryTestCase.this.gallery.getButtonGroup("Group 0").get(fSel).getActionModel().isSelected();
                                    }
                                });
                            }
                        }
                        catch (Throwable t) {
                            ts[0] = t;
                        }
                        new Thread(){

                            @Override
                            public void run() {
                                ((this).this).RibbonGalleryTestCase.this.ribbonFrame.dispose();
                                latch.countDown();
                            }
                        }.start();
                    }
                }.start();
            }
        });
        try {
            RibbonGalleryTestCase.assertTrue(latch.await(10L, TimeUnit.SECONDS));
        }
        catch (Exception exception) {
            // empty catch block
        }
        RibbonGalleryTestCase.assertNull(ts[0]);
        boolean[] blArray = tested;
        int n = tested.length;
        int n2 = 0;
        while (n2 < n) {
            boolean test = blArray[n2];
            RibbonGalleryTestCase.assertTrue(test);
            ++n2;
        }
    }

    public void testRemoval() {
        this.ribbonBand.removeRibbonGalleryButtons(GALLERY_NAME, this.buttons[0][0]);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroupCount(), 4);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 39);
        int i = 0;
        while (i < this.gallery.getButtonGroupCount()) {
            int j;
            List<JCommandToggleButton> buttonGroup = this.gallery.getButtonGroup("Group " + i);
            if (i == 0) {
                RibbonGalleryTestCase.assertEquals(buttonGroup.size(), 9);
                j = 0;
                while (j < 9) {
                    RibbonGalleryTestCase.assertEquals(buttonGroup.get(j), this.buttons[i][j + 1]);
                    ++j;
                }
            } else {
                RibbonGalleryTestCase.assertEquals(buttonGroup.size(), 10);
                j = 0;
                while (j < 10) {
                    RibbonGalleryTestCase.assertEquals(buttonGroup.get(j), this.buttons[i][j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void testRemoval2() {
        this.ribbonBand.removeRibbonGalleryButtons(GALLERY_NAME, this.buttons[1][5]);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroupCount(), 4);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 39);
        int i = 0;
        while (i < this.gallery.getButtonGroupCount()) {
            int j;
            List<JCommandToggleButton> buttonGroup = this.gallery.getButtonGroup("Group " + i);
            if (i == 1) {
                RibbonGalleryTestCase.assertEquals(buttonGroup.size(), 9);
                j = 0;
                while (j < 5) {
                    RibbonGalleryTestCase.assertEquals(buttonGroup.get(j), this.buttons[i][j]);
                    ++j;
                }
                j = 5;
                while (j < 9) {
                    RibbonGalleryTestCase.assertEquals(buttonGroup.get(j), this.buttons[i][j + 1]);
                    ++j;
                }
            } else {
                RibbonGalleryTestCase.assertEquals(buttonGroup.size(), 10);
                j = 0;
                while (j < 10) {
                    RibbonGalleryTestCase.assertEquals(buttonGroup.get(j), this.buttons[i][j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void testRemoval3() {
        this.ribbonBand.removeRibbonGalleryButtons(GALLERY_NAME, this.buttons[2][9], this.buttons[1][9]);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroupCount(), 4);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 38);
        int i = 0;
        while (i < this.gallery.getButtonGroupCount()) {
            int j;
            List<JCommandToggleButton> buttonGroup = this.gallery.getButtonGroup("Group " + i);
            if (i == 2 || i == 1) {
                RibbonGalleryTestCase.assertEquals(buttonGroup.size(), 9);
                j = 0;
                while (j < 9) {
                    RibbonGalleryTestCase.assertEquals(buttonGroup.get(j), this.buttons[i][j]);
                    ++j;
                }
            } else {
                RibbonGalleryTestCase.assertEquals(buttonGroup.size(), 10);
                j = 0;
                while (j < 10) {
                    RibbonGalleryTestCase.assertEquals(buttonGroup.get(j), this.buttons[i][j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    public void testRemovalAll() {
        int removed = 0;
        int i = 0;
        while (i < 4) {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            int j = 0;
            while (j < 10) {
                indexes.add(j);
                ++j;
            }
            Collections.shuffle(indexes);
            Iterator iterator = indexes.iterator();
            while (iterator.hasNext()) {
                int toRemove = (Integer)iterator.next();
                this.ribbonBand.removeRibbonGalleryButtons(GALLERY_NAME, this.buttons[i][toRemove]);
                RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 40 - ++removed);
            }
            ++i;
        }
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 0);
    }

    public void testRemovalAll2() {
        int removed = 0;
        int i = 0;
        while (i < 4) {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            int j = 0;
            while (j < 5) {
                indexes.add(j);
                ++j;
            }
            Collections.shuffle(indexes);
            Iterator iterator = indexes.iterator();
            while (iterator.hasNext()) {
                int toRemove = (Integer)iterator.next();
                this.ribbonBand.removeRibbonGalleryButtons(GALLERY_NAME, this.buttons[i][toRemove], this.buttons[i][9 - toRemove]);
                RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 40 - (removed += 2));
            }
            ++i;
        }
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 0);
    }

    public void testRemovalAll3() {
        int removed = 0;
        int i = 0;
        while (i < 2) {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            int j = 0;
            while (j < 5) {
                indexes.add(j);
                ++j;
            }
            Collections.shuffle(indexes);
            Iterator iterator = indexes.iterator();
            while (iterator.hasNext()) {
                int toRemove = (Integer)iterator.next();
                this.ribbonBand.removeRibbonGalleryButtons(GALLERY_NAME, this.buttons[i][toRemove], this.buttons[i][9 - toRemove], this.buttons[i + 2][toRemove], this.buttons[i + 2][9 - toRemove]);
                RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 40 - (removed += 4));
            }
            ++i;
        }
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 0);
    }

    public void testRemovalAndSelection() {
        int i = 0;
        while (i < this.gallery.getButtonCount()) {
            RibbonGalleryTestCase.assertFalse(this.gallery.getButtonAt(i).getActionModel().isSelected());
            ++i;
        }
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[2];
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{1, 6};
        nArrayArray[2] = new int[]{2, 8};
        int[] nArray2 = new int[2];
        nArray2[1] = 3;
        nArrayArray[3] = nArray2;
        nArrayArray[4] = new int[]{3, 1};
        int[][] toTest = nArrayArray;
        int sel = 0;
        while (sel < toTest.length) {
            int selRow = toTest[sel][0];
            int selCol = toTest[sel][1];
            this.ribbonBand.setSelectedRibbonGalleryButton(GALLERY_NAME, this.buttons[selRow][selCol]);
            this.ribbonBand.removeRibbonGalleryButtons(GALLERY_NAME, this.buttons[selRow][selCol]);
            int i2 = 0;
            while (i2 < this.gallery.getButtonGroupCount()) {
                List<JCommandToggleButton> buttonGroup = this.gallery.getButtonGroup("Group " + i2);
                int j = 0;
                while (j < buttonGroup.size()) {
                    JCommandToggleButton button = buttonGroup.get(j);
                    RibbonGalleryTestCase.assertFalse(button.getActionModel().isSelected());
                    ++j;
                }
                ++i2;
            }
            ++sel;
        }
    }

    public void testAddition() {
        JCommandToggleButton newButton = new JCommandToggleButton("New", new EmptyResizableIcon(32));
        this.ribbonBand.addRibbonGalleryButtons(GALLERY_NAME, "Group 0", newButton);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroupCount(), 4);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 41);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 0").size(), 11);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 1").size(), 10);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 2").size(), 10);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 3").size(), 10);
        JCommandToggleButton newButton2 = new JCommandToggleButton("New 2", new EmptyResizableIcon(32));
        this.ribbonBand.addRibbonGalleryButtons(GALLERY_NAME, "Group non-existent", newButton2);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroupCount(), 4);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 41);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 0").size(), 11);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 1").size(), 10);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 2").size(), 10);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 3").size(), 10);
        RibbonGalleryTestCase.assertTrue(this.gallery.getButtonGroup("Group 0").contains(newButton));
        JCommandToggleButton newButton3 = new JCommandToggleButton("New 3", new EmptyResizableIcon(32));
        JCommandToggleButton newButton4 = new JCommandToggleButton("New 4", new EmptyResizableIcon(32));
        this.ribbonBand.addRibbonGalleryButtons(GALLERY_NAME, "Group 2", newButton3, newButton4);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroupCount(), 4);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonCount(), 43);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 0").size(), 11);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 1").size(), 10);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 2").size(), 12);
        RibbonGalleryTestCase.assertEquals(this.gallery.getButtonGroup("Group 3").size(), 10);
        RibbonGalleryTestCase.assertTrue(this.gallery.getButtonGroup("Group 0").contains(newButton));
        RibbonGalleryTestCase.assertTrue(this.gallery.getButtonGroup("Group 2").contains(newButton3));
        RibbonGalleryTestCase.assertTrue(this.gallery.getButtonGroup("Group 2").contains(newButton4));
    }
}

