/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.http.core.Monitor;
import org.simpleframework.http.core.Producer;
import org.simpleframework.http.core.ProducerException;
import org.simpleframework.transport.Sender;

class CloseProducer
implements Producer {
    private final Monitor monitor;
    private final Sender sender;

    public CloseProducer(Sender sender, Monitor monitor) {
        this.monitor = monitor;
        this.sender = sender;
    }

    public void produce(byte[] array) throws IOException {
        this.produce(array, 0, array.length);
    }

    public void produce(byte[] array, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(array, off, len);
        if (len > 0) {
            this.produce(buffer);
        }
    }

    public void produce(ByteBuffer buffer) throws IOException {
        int size;
        int mark = buffer.position();
        if (mark > (size = buffer.limit())) {
            throw new ProducerException("Buffer position greater than limit");
        }
        this.produce(buffer, 0, size - mark);
    }

    public void produce(ByteBuffer buffer, int off, int len) throws IOException {
        if (this.monitor.isClosed()) {
            throw new ProducerException("Stream has been closed");
        }
        try {
            this.sender.send(buffer, off, len);
        }
        catch (Exception cause) {
            if (this.sender != null) {
                this.monitor.error(this.sender);
            }
            throw new ProducerException("Error sending response", cause);
        }
    }

    public void flush() throws IOException {
        try {
            if (!this.monitor.isClosed()) {
                this.sender.flush();
            }
        }
        catch (Exception cause) {
            if (this.sender != null) {
                this.monitor.error(this.sender);
            }
            throw new ProducerException("Error sending response", cause);
        }
    }

    public void close() throws IOException {
        try {
            if (!this.monitor.isClosed()) {
                this.monitor.close(this.sender);
                this.sender.close();
            }
        }
        catch (Exception cause) {
            if (this.sender != null) {
                this.monitor.error(this.sender);
            }
            throw new ProducerException("Error sending response", cause);
        }
    }
}

