/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import org.simpleframework.http.core.ChunkedProducer;
import org.simpleframework.http.core.CloseProducer;
import org.simpleframework.http.core.Conversation;
import org.simpleframework.http.core.EmptyProducer;
import org.simpleframework.http.core.FixedProducer;
import org.simpleframework.http.core.Monitor;
import org.simpleframework.http.core.Producer;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.Sender;

class ProducerFactory {
    private final Conversation support;
    private final Monitor monitor;
    private final Sender sender;

    public ProducerFactory(Conversation support, Channel channel, Monitor monitor) {
        this.sender = channel.getSender();
        this.support = support;
        this.monitor = monitor;
    }

    public Producer getInstance() {
        boolean keepAlive = this.support.isKeepAlive();
        boolean chunkable = this.support.isChunkedEncoded();
        if (!keepAlive) {
            return new CloseProducer(this.sender, this.monitor);
        }
        return this.getInstance(chunkable);
    }

    private Producer getInstance(boolean chunkable) {
        long length = this.support.getContentLength();
        if (!this.support.isHead()) {
            if (length > 0L) {
                return new FixedProducer(this.sender, this.monitor, length);
            }
            if (chunkable) {
                return new ChunkedProducer(this.sender, this.monitor);
            }
        }
        return new EmptyProducer(this.sender, this.monitor);
    }
}

