/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.TransportException;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.Reactor;
import org.simpleframework.transport.trace.Trace;

class Scheduler {
    private Operation task;
    private Reactor reactor;
    private Trace trace;
    private Object lock;
    private volatile boolean running;
    private volatile boolean closed;

    public Scheduler(Socket socket, Reactor reactor, Operation task, Object lock) {
        this.trace = socket.getTrace();
        this.reactor = reactor;
        this.task = task;
        this.lock = lock;
    }

    public void repeat() throws IOException {
        if (this.closed) {
            throw new TransportException("Socket closed");
        }
        if (this.running) {
            this.trace.trace((Object)TransportEvent.WRITE_WAIT);
            this.reactor.process(this.task, 4);
        }
    }

    public void schedule(boolean block) throws IOException {
        if (this.closed) {
            throw new TransportException("Socket closed");
        }
        if (!this.running) {
            this.trace.trace((Object)TransportEvent.WRITE_WAIT);
            this.reactor.process(this.task, 4);
            this.running = true;
        }
        if (block) {
            this.listen();
        }
    }

    private void listen() throws IOException {
        try {
            if (!this.closed) {
                this.trace.trace((Object)TransportEvent.WRITE_BLOCKING);
                this.lock.wait(120000L);
            }
        }
        catch (Exception e) {
            throw new TransportException("Schedule error", e);
        }
        if (this.closed) {
            throw new TransportException("Socket closed");
        }
    }

    public void release() {
        this.lock.notifyAll();
    }

    public void ready() {
        this.lock.notifyAll();
        this.running = false;
    }

    public void close() {
        this.lock.notifyAll();
        this.closed = true;
    }
}

