/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.reactor;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import org.simpleframework.transport.reactor.Action;
import org.simpleframework.transport.reactor.ActionMap;
import org.simpleframework.transport.reactor.ActionQueue;
import org.simpleframework.transport.reactor.ActionSelector;
import org.simpleframework.transport.reactor.ActionSet;
import org.simpleframework.transport.reactor.CancelAction;
import org.simpleframework.transport.reactor.Distributor;
import org.simpleframework.transport.reactor.ExecuteAction;
import org.simpleframework.transport.reactor.Latch;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.util.thread.Daemon;

class ActionDistributor
extends Daemon
implements Distributor {
    private ActionSelector selector = new ActionSelector();
    private ActionQueue pending;
    private ActionMap selecting = new ActionMap();
    private ActionMap executing = new ActionMap();
    private Executor executor;
    private Latch latch;
    private long expiry;
    private long update;
    private boolean cancel;
    private volatile boolean dead;

    public ActionDistributor(Executor executor) throws IOException {
        this(executor, true);
    }

    public ActionDistributor(Executor executor, boolean cancel) throws IOException {
        this(executor, cancel, 120000L);
    }

    public ActionDistributor(Executor executor, boolean cancel, long expiry) throws IOException {
        this.pending = new ActionQueue();
        this.latch = new Latch();
        this.executor = executor;
        this.cancel = cancel;
        this.expiry = expiry;
        this.start();
    }

    public void run() {
        this.execute();
        this.purge();
    }

    private void execute() {
        while (!this.dead) {
            try {
                this.register();
                this.cancel();
                this.expire();
                this.distribute();
            }
            catch (Exception e) {}
        }
    }

    private void purge() {
        try {
            this.register();
            this.cancel();
            this.drain();
        }
        catch (Exception e) {
            return;
        }
    }

    public void process(Operation task, int require) throws IOException {
        ExecuteAction action = new ExecuteAction(task, require, this.expiry);
        if (this.dead) {
            throw new IOException("Distributor is closed");
        }
        this.pending.offer(action);
        this.selector.wake();
    }

    public void close() throws IOException {
        this.dead = true;
        this.selector.wake();
        this.latch.close();
    }

    private void drain() throws IOException {
        List<ActionSet> sets = this.selector.registeredSets();
        for (ActionSet set : sets) {
            this.expire(set, Long.MAX_VALUE);
        }
        this.selector.close();
        this.latch.signal();
    }

    private void expire() throws IOException {
        long time;
        List<ActionSet> sets = this.selector.registeredSets();
        if (this.cancel && this.update <= (time = System.currentTimeMillis())) {
            for (ActionSet set : sets) {
                this.expire(set, time);
            }
            this.update = time + 10000L;
        }
    }

    private void expire(ActionSet set, long time) throws IOException {
        SelectionKey key = set.key();
        int mask = key.interestOps();
        for (Action task : set) {
            int interest = task.getInterest();
            long expiry = task.getExpiry();
            if (expiry >= time) continue;
            this.expire(set, task);
            mask &= ~interest;
        }
        this.update(set, mask);
    }

    private void update(ActionSet set, int interest) throws IOException {
        SelectionKey key = set.key();
        if (interest == 0) {
            key.cancel();
        } else {
            key.interestOps(interest);
        }
    }

    private void expire(ActionSet set, Action action) throws IOException {
        CancelAction cancel = new CancelAction(action);
        if (set != null) {
            int interest = action.getInterest();
            set.remove(interest);
            this.executor.execute(cancel);
        }
    }

    private void cancel() throws IOException {
        Collection list = this.executing.values();
        for (ActionSet set : list) {
            set.cancel();
            set.clear();
        }
        this.executing.clear();
    }

    private void register() throws IOException {
        while (!this.pending.isEmpty()) {
            Action action = (Action)this.pending.poll();
            if (action == null) continue;
            SelectableChannel channel = action.getChannel();
            ActionSet set = (ActionSet)this.executing.remove(channel);
            if (set == null) {
                set = (ActionSet)this.selecting.get(channel);
            }
            if (set != null) {
                this.register(action, set);
                continue;
            }
            this.register(action);
        }
    }

    private void register(Action action) throws IOException {
        SelectableChannel channel = action.getChannel();
        if (channel.isOpen()) {
            this.select(action);
        }
    }

    private void register(Action action, ActionSet set) throws IOException {
        SelectionKey key = set.key();
        int interest = action.getInterest();
        int current = key.interestOps();
        int updated = current | interest;
        key.interestOps(updated);
        set.attach(action, interest);
    }

    private void select(Action action) throws IOException {
        ActionSet set;
        SelectableChannel channel = action.getChannel();
        int interest = action.getInterest();
        if (interest > 0 && (set = this.selector.register(channel, interest)) != null) {
            set.attach(action, interest);
            this.selecting.put(channel, set);
        }
    }

    private void distribute() throws IOException {
        if (this.selector.select(5000L) > 0 && !this.dead) {
            this.process();
        }
    }

    private void process() throws IOException {
        List<ActionSet> ready = this.selector.selectedSets();
        for (ActionSet set : ready) {
            this.remove(set);
            this.process(set);
            this.clear(set);
        }
    }

    private void process(ActionSet set) throws IOException {
        for (Action action : set) {
            this.executor.execute(action);
        }
    }

    private void remove(ActionSet set) throws IOException {
        SelectableChannel channel = set.channel();
        if (this.cancel) {
            this.executing.put(channel, set);
        }
        this.selecting.remove(channel);
    }

    private void clear(ActionSet set) throws IOException {
        if (this.cancel) {
            set.clear();
        }
    }
}

