/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.service;

import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.util.Assert;

public class RuntimeBindingConversionExecutor
implements ConversionExecutor {
    private Class<?> targetClass;
    private ConversionService conversionService;

    public RuntimeBindingConversionExecutor(Class<?> targetClass, ConversionService conversionService) {
        Assert.notNull(targetClass, (String)"The target class of the conversion is required");
        Assert.notNull((Object)conversionService, (String)"The conversion service is required");
        this.targetClass = targetClass;
        this.conversionService = conversionService;
    }

    @Override
    public Class<?> getSourceClass() {
        return null;
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RuntimeBindingConversionExecutor)) {
            return false;
        }
        RuntimeBindingConversionExecutor o = (RuntimeBindingConversionExecutor)obj;
        return this.targetClass.equals(o.targetClass);
    }

    public int hashCode() {
        return this.targetClass.hashCode();
    }

    @Override
    public Object execute(Object source) throws ConversionExecutionException {
        return this.execute(source, null);
    }

    public Object execute(Object source, Object context) throws ConversionExecutionException {
        return this.conversionService.getConversionExecutor(source.getClass(), this.targetClass).execute(source);
    }
}

