/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.support;

import java.util.Collection;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class CollectionAddingExpression
implements Expression {
    private Expression collectionExpression;

    public CollectionAddingExpression(Expression collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    @Override
    public Object getValue(Object context) throws EvaluationException {
        return this.collectionExpression.getValue(context);
    }

    @Override
    public void setValue(Object context, Object value) throws EvaluationException {
        Object result = this.getValue(context);
        if (result == null) {
            throw new EvaluationException(context.getClass(), this.collectionExpression.getExpressionString(), "Unable to access collection value for expression '" + this.collectionExpression.getExpressionString() + "'", new IllegalStateException("The collection expression evaluated to a [null] reference"));
        }
        Assert.isInstanceOf(Collection.class, (Object)result, (String)"Not a collection: ");
        if (value != null) {
            ((Collection)result).add(value);
        }
    }

    @Override
    public Class<?> getValueType(Object context) {
        return Object.class;
    }

    @Override
    public String getExpressionString() {
        return this.collectionExpression.getExpressionString();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("collectionExpression", (Object)this.collectionExpression).toString();
    }
}

