/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.mapping.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.binding.mapping.MappingResult;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.MappingResultsCriteria;

public class DefaultMappingResults
implements MappingResults {
    private Object source;
    private Object target;
    private List<MappingResult> mappingResults;

    public DefaultMappingResults(Object source, Object target, List<MappingResult> mappingResults) {
        this.source = source;
        this.target = target;
        this.mappingResults = mappingResults;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public List<MappingResult> getAllResults() {
        return Collections.unmodifiableList(this.mappingResults);
    }

    @Override
    public boolean hasErrorResults() {
        for (MappingResult result : this.mappingResults) {
            if (!result.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<MappingResult> getErrorResults() {
        ArrayList<MappingResult> errorResults = new ArrayList<MappingResult>();
        for (MappingResult result : this.mappingResults) {
            if (!result.isError()) continue;
            errorResults.add(result);
        }
        return Collections.unmodifiableList(errorResults);
    }

    @Override
    public List<MappingResult> getResults(MappingResultsCriteria criteria) {
        ArrayList<MappingResult> results = new ArrayList<MappingResult>();
        for (MappingResult result : this.mappingResults) {
            if (!criteria.test(result)) continue;
            results.add(result);
        }
        return Collections.unmodifiableList(results);
    }

    public String toString() {
        return "Mapping Results = " + this.mappingResults.toString();
    }
}

