/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core;

import ar.com.fdvs.dj.core.BarcodeTypes;
import java.awt.image.BufferedImage;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeFactory;
import net.sourceforge.barbecue.BarcodeImageHandler;
import net.sourceforge.barbecue.linear.code39.Code39Barcode;
import net.sourceforge.barbecue.linear.ean.UCCEAN128Barcode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BarcodeHelper
implements BarcodeTypes {
    private static final Log logger = LogFactory.getLog((Class)BarcodeHelper.class);
    private static Barcode bc = null;

    public static BufferedImage getBarcodeImage(int type, Object aText, boolean showText, boolean checkSum) {
        return BarcodeHelper.getBarcodeImage(type, aText, showText, checkSum, "", 0, 0);
    }

    public static BufferedImage getBarcodeImage(int type, Object aText, boolean showText, boolean checkSum, Object applicationIdentifier, int width, int height) {
        String text = null;
        text = aText instanceof String ? (String)aText : aText.toString();
        try {
            switch (type) {
                case 0: {
                    bc = BarcodeFactory.create2of7((String)text);
                    break;
                }
                case 1: {
                    bc = BarcodeFactory.create3of9((String)text, (boolean)checkSum);
                    break;
                }
                case 2: {
                    bc = BarcodeFactory.createBookland((String)text);
                    break;
                }
                case 3: {
                    bc = BarcodeFactory.createCodabar((String)text);
                    break;
                }
                case 4: {
                    bc = BarcodeFactory.createCode128((String)text);
                    break;
                }
                case 5: {
                    bc = BarcodeFactory.createCode128A((String)text);
                    break;
                }
                case 6: {
                    bc = BarcodeFactory.createCode128B((String)text);
                    break;
                }
                case 7: {
                    bc = BarcodeFactory.createCode128B((String)text);
                    break;
                }
                case 8: {
                    bc = BarcodeFactory.createCode39((String)text, (boolean)checkSum);
                    break;
                }
                case 9: {
                    bc = BarcodeFactory.createEAN128((String)text);
                    break;
                }
                case 10: {
                    bc = BarcodeFactory.createEAN13((String)text);
                    break;
                }
                case 11: {
                    bc = BarcodeFactory.createGlobalTradeItemNumber((String)text);
                    break;
                }
                case 12: {
                    bc = BarcodeFactory.createInt2of5((String)text, (boolean)checkSum);
                    break;
                }
                case 13: {
                    bc = BarcodeFactory.createMonarch((String)text);
                    break;
                }
                case 14: {
                    bc = BarcodeFactory.createNW7((String)text);
                    break;
                }
                case 16: {
                    bc = BarcodeFactory.createPDF417((String)text);
                    break;
                }
                case 15: {
                    bc = BarcodeFactory.createSCC14ShippingCode((String)text);
                    break;
                }
                case 17: {
                    bc = BarcodeFactory.createShipmentIdentificationNumber((String)text);
                    break;
                }
                case 20: {
                    bc = new UCCEAN128Barcode("00", text, checkSum);
                    break;
                }
                case 19: {
                    bc = BarcodeFactory.createStd2of5((String)text, (boolean)checkSum);
                    break;
                }
                case 18: {
                    if (applicationIdentifier == null) {
                        applicationIdentifier = "";
                    }
                    bc = new UCCEAN128Barcode(applicationIdentifier.toString(), text, checkSum);
                    break;
                }
                case 21: {
                    bc = BarcodeFactory.createUPCA((String)text);
                    break;
                }
                case 22: {
                    bc = BarcodeFactory.createUSD3((String)text, (boolean)checkSum);
                    break;
                }
                case 23: {
                    bc = BarcodeFactory.createUSD4((String)text);
                    break;
                }
                case 24: {
                    bc = BarcodeFactory.createUSPS((String)text);
                    break;
                }
                case 25: {
                    bc = new Code39Barcode(text, checkSum, true);
                    break;
                }
            }
            if (width > 0) {
                bc.setBarWidth(width);
            }
            if (height > 0) {
                bc.setBarHeight(height);
            }
            bc.setDrawingText(showText);
            return BarcodeImageHandler.getImage((Barcode)bc);
        }
        catch (Exception e) {
            logger.error((Object)("Error generating BarCode," + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

