/*
 * $Id:$
 */

package csbase.client.applications.commandsmonitor.dal.xml.elements;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLElement;
import tecgraf.javautils.xml.XMLElementInterface;
import csbase.client.applications.commandsmonitor.models.TabbedPaneDTO;
import csbase.client.applications.commandsmonitor.models.TablesTabDTO;

/**
 * Elemento de tabbed pane
 * 
 * @author Tecgraf
 */
public class TabbedPaneElement extends XMLElement {

  /**
   * Nome do atributo de seleo.
   */
  private final String ATTR_SELECTED = "selected";

  /**
   * Consulta o nome da tag
   * 
   * @return tag
   */
  public static final String getTagName() {
    return "tabs";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {

    String selected = null;
    if (hasAttribute(ATTR_SELECTED)) {
      selected = getAttributeStrValue(ATTR_SELECTED);
    }

    List<TablesTabDTO> tabsInfo = new ArrayList<TablesTabDTO>();

    ImprovedXMLListIterator iterator =
      new ImprovedXMLListIterator(childrenList);
    while (iterator.hasNext()) {
      XMLElementInterface aTabElement = iterator.next();
      TablesTabDTO aTabInfo = (TablesTabDTO) aTabElement.getAppObject();
      tabsInfo.add(aTabInfo);
    }

    setAppObject(new TabbedPaneDTO(selected, tabsInfo));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer writer, String ident) throws IOException {
    throw new IllegalAccessError("Esse mtodo no deve ser utilizado.");
  }
}
