package csbase.client.applications.filetransferclient.panels.remotepanel;

import java.awt.Color;
import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import tecgraf.javautils.core.lng.FormatUtils;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.logic.filetransferservice.FileTransferElement;

/**
 * Renderizador da tabela de requisies
 * 
 * @author Tecgraf/PUC-Rio
 */
class RemoteTableRenderer implements TableCellRenderer {

  /**
   * Renderer default.
   */
  public static final DefaultTableCellRenderer DEFAULT_RENDERER =
    new DefaultTableCellRenderer();

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    Component renderer =
      DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected,
        hasFocus, row, column);
    final JLabel label = ((JLabel) renderer);
    label.setOpaque(true);
    label.setIcon(null);
    label.setHorizontalAlignment(SwingConstants.LEFT);
    label.setForeground(Color.black);

    if (column == 0) {
      final FileTransferElement file = (FileTransferElement) value;
      label.setHorizontalAlignment(SwingConstants.CENTER);
      Icon icon = null;
      if (file.isDirectory()) {
        icon = FileTransferClientUI.IMG_TYPE_DIRECTORY;
      }
      else {
        icon = FileTransferClientUI.IMG_TYPE_FILE;
      }
      if (file.isLink()) {
        icon = FileTransferClientUI.IMG_TYPE_LINK;
      }
      label.setIcon(icon);
      label.setText(null);
    }
    else if (column == 1) {
      final String name = (String) value;
      label.setHorizontalAlignment(SwingConstants.LEFT);
      label.setText(name);
    }
    else if (column == 2) {
      final long size = (Long) value;
      if (size < 0) {
        label.setText(null);
      }
      else {
        label.setHorizontalAlignment(SwingConstants.RIGHT);
        final ApplicationManager mgr = ApplicationManager.getInstance();
        label.setText(FormatUtils.formatSize(size, 2, mgr.getLocale()));
      }
    }

    return label;
  }

  /**
   * Construtor
   */
  public RemoteTableRenderer() {
  }

}
